/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AbstractPatternNodeVisitor;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class PoliceExtensionUse
extends AbstractPatternNodeVisitor {
    private boolean synchronizationDesignatorEncountered;
    private World world;
    private Pointcut p;

    public PoliceExtensionUse(World w, Pointcut p2) {
        this.world = w;
        this.p = p2;
        this.synchronizationDesignatorEncountered = false;
    }

    public boolean synchronizationDesignatorEncountered() {
        return this.synchronizationDesignatorEncountered;
    }

    public Object visit(KindedPointcut node, Object data) {
        if (this.world == null) {
            return super.visit(node, data);
        }
        if (node.getKind() == Shadow.SynchronizationLock || node.getKind() == Shadow.SynchronizationUnlock) {
            this.synchronizationDesignatorEncountered = true;
        }
        if (!this.world.isJoinpointSynchronizationEnabled()) {
            if (node.getKind() == Shadow.SynchronizationLock) {
                IMessage m2 = MessageUtil.warn("lock() pointcut designator cannot be used without the option -Xjoinpoints:synchronization", this.p.getSourceLocation());
                this.world.getMessageHandler().handleMessage(m2);
            } else if (node.getKind() == Shadow.SynchronizationUnlock) {
                IMessage m3 = MessageUtil.warn("unlock() pointcut designator cannot be used without the option -Xjoinpoints:synchronization", this.p.getSourceLocation());
                this.world.getMessageHandler().handleMessage(m3);
            }
        }
        return super.visit(node, data);
    }

    public Object visit(AndPointcut node, Object data) {
        node.getLeft().accept(this, data);
        node.getRight().accept(this, data);
        return node;
    }

    public Object visit(NotPointcut node, Object data) {
        node.getNegatedPointcut().accept(this, data);
        return node;
    }

    public Object visit(OrPointcut node, Object data) {
        node.getLeft().accept(this, data);
        node.getRight().accept(this, data);
        return node;
    }
}

