/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private static final ElementValue[] NO_VALUES = new ElementValue[0];
    private ElementValue[] evalues = NO_VALUES;

    public ElementValue[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }

    public ArrayElementValue(ConstantPool cp) {
        super(91, cp);
    }

    public ArrayElementValue(int type, ElementValue[] datums, ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        }
        this.evalues = datums;
    }

    public ArrayElementValue(ArrayElementValue value, ConstantPool cpool, boolean copyPoolEntries) {
        super(91, cpool);
        this.evalues = new ElementValue[value.getElementValuesArraySize()];
        ElementValue[] in = value.getElementValuesArray();
        int i2 = 0;
        while (i2 < in.length) {
            this.evalues[i2] = ElementValue.copy(in[i2], cpool, copyPoolEntries);
            ++i2;
        }
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.evalues.length);
        int i2 = 0;
        while (i2 < this.evalues.length) {
            this.evalues[i2].dump(dos);
            ++i2;
        }
    }

    public String stringifyValue() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i2 = 0;
        while (i2 < this.evalues.length) {
            ElementValue element = this.evalues[i2];
            sb.append(element.stringifyValue());
            if (i2 + 1 < this.evalues.length) {
                sb.append(",");
            }
            ++i2;
        }
        sb.append("]");
        return sb.toString();
    }

    public void addElement(ElementValue gen) {
        ElementValue[] old = this.evalues;
        this.evalues = new ElementValue[this.evalues.length + 1];
        System.arraycopy(old, 0, this.evalues, 0, old.length);
        this.evalues[old.length] = gen;
    }
}

