/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.InnerClass;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;
    private int number_of_classes;

    public InnerClasses(InnerClasses c2) {
        this(c2.getNameIndex(), c2.getLength(), c2.getInnerClasses(), c2.getConstantPool());
    }

    public InnerClasses(int name_index, int length, InnerClass[] inner_classes, ConstantPool constant_pool) {
        super((byte)6, name_index, length, constant_pool);
        this.setInnerClasses(inner_classes);
    }

    InnerClasses(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (InnerClass[])null, constant_pool);
        this.number_of_classes = file.readUnsignedShort();
        this.inner_classes = new InnerClass[this.number_of_classes];
        int i2 = 0;
        while (i2 < this.number_of_classes) {
            this.inner_classes[i2] = new InnerClass(file);
            ++i2;
        }
    }

    public void accept(ClassVisitor v) {
        v.visitInnerClasses(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.number_of_classes);
        int i2 = 0;
        while (i2 < this.number_of_classes) {
            this.inner_classes[i2].dump(file);
            ++i2;
        }
    }

    public final InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public final void setInnerClasses(InnerClass[] inner_classes) {
        this.inner_classes = inner_classes;
        this.number_of_classes = inner_classes == null ? 0 : inner_classes.length;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < this.number_of_classes) {
            buf.append(String.valueOf(this.inner_classes[i2].toString(this.cpool)) + "\n");
            ++i2;
        }
        return buf.toString();
    }
}

