/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlRuntimeException;

public class XmlException
extends Exception {
    private static final long serialVersionUID = 1L;
    private List _errors;

    public XmlException(String m2) {
        super(m2);
    }

    public XmlException(String m2, Throwable t) {
        super(m2, t);
    }

    public XmlException(Throwable t) {
        super(t);
    }

    public XmlException(XmlError error) {
        this(error.toString(), null, error);
    }

    public XmlException(String m2, Throwable t, XmlError error) {
        this(m2, t, Collections.singletonList(error));
    }

    public XmlException(String m2, Throwable t, Collection errors) {
        super(m2, t);
        if (errors != null) {
            this._errors = Collections.unmodifiableList(new ArrayList(errors));
        }
    }

    public XmlException(XmlRuntimeException xmlRuntimeException) {
        super(xmlRuntimeException.getMessage(), xmlRuntimeException.getCause());
        Collection errors = xmlRuntimeException.getErrors();
        if (errors != null) {
            this._errors = Collections.unmodifiableList(new ArrayList(errors));
        }
    }

    public XmlError getError() {
        if (this._errors == null || this._errors.size() == 0) {
            return null;
        }
        return (XmlError)this._errors.get(0);
    }

    public Collection getErrors() {
        return this._errors;
    }
}

