/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.ObjectNameWrapper;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionMXBean;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;

public class PoolableConnection
extends DelegatingConnection<Connection>
implements PoolableConnectionMXBean {
    private static MBeanServer MBEAN_SERVER;
    private final ObjectPool<PoolableConnection> pool;
    private final ObjectNameWrapper jmxObjectName;
    private PreparedStatement validationPreparedStatement;
    private String lastValidationSql;
    private boolean fatalSqlExceptionThrown = false;
    private final Collection<String> disconnectionSqlCodes;
    private final boolean fastFailValidation;

    public PoolableConnection(Connection conn, ObjectPool<PoolableConnection> pool, ObjectName jmxObjectName, Collection<String> disconnectSqlCodes, boolean fastFailValidation) {
        super(conn);
        this.pool = pool;
        this.jmxObjectName = ObjectNameWrapper.wrap(jmxObjectName);
        this.disconnectionSqlCodes = disconnectSqlCodes;
        this.fastFailValidation = fastFailValidation;
        if (jmxObjectName != null) {
            try {
                MBEAN_SERVER.registerMBean(this, jmxObjectName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException jMException) {
                // empty catch block
            }
        }
    }

    public PoolableConnection(Connection conn, ObjectPool<PoolableConnection> pool, ObjectName jmxName) {
        this(conn, pool, jmxName, null, true);
    }

    @Override
    protected void passivate() throws SQLException {
        super.passivate();
        this.setClosedInternal(true);
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosedInternal()) {
            return true;
        }
        if (this.getDelegateInternal().isClosed()) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean isUnderlyingConnectionClosed;
        if (this.isClosedInternal()) {
            return;
        }
        try {
            isUnderlyingConnectionClosed = this.getDelegateInternal().isClosed();
        }
        catch (SQLException e2) {
            try {
                this.pool.invalidateObject(this);
            }
            catch (IllegalStateException ise) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Cannot close connection (isClosed check failed)", e2);
        }
        if (isUnderlyingConnectionClosed) {
            try {
                this.pool.invalidateObject(this);
            }
            catch (IllegalStateException e3) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception e4) {
                throw new SQLException("Cannot close connection (invalidating pooled object failed)", e4);
            }
        } else {
            try {
                this.pool.returnObject(this);
            }
            catch (IllegalStateException e5) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (SQLException e6) {
                throw e6;
            }
            catch (RuntimeException e7) {
                throw e7;
            }
            catch (Exception e8) {
                throw new SQLException("Cannot close connection (return to pool failed)", e8);
            }
        }
    }

    @Override
    public void reallyClose() throws SQLException {
        if (this.jmxObjectName != null) {
            this.jmxObjectName.unregisterMBean();
        }
        if (this.validationPreparedStatement != null) {
            try {
                this.validationPreparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.closeInternal();
    }

    @Override
    public String getToString() {
        return this.toString();
    }

    public void validate(String sql, int timeoutSeconds) throws SQLException {
        if (this.fastFailValidation && this.fatalSqlExceptionThrown) {
            throw new SQLException(Utils.getMessage("poolableConnection.validate.fastFail"));
        }
        if (sql == null || sql.length() == 0) {
            if (timeoutSeconds < 0) {
                timeoutSeconds = 0;
            }
            if (!this.isValid(timeoutSeconds)) {
                throw new SQLException("isValid() returned false");
            }
            return;
        }
        if (!sql.equals(this.lastValidationSql)) {
            this.lastValidationSql = sql;
            this.validationPreparedStatement = this.getInnermostDelegateInternal().prepareStatement(sql);
        }
        if (timeoutSeconds > 0) {
            this.validationPreparedStatement.setQueryTimeout(timeoutSeconds);
        }
        try (ResultSet rs = this.validationPreparedStatement.executeQuery();){
            if (!rs.next()) {
                throw new SQLException("validationQuery didn't return a row");
            }
        }
    }

    private boolean isDisconnectionSqlException(SQLException e2) {
        boolean fatalException = false;
        String sqlState = e2.getSQLState();
        if (sqlState != null) {
            SQLException nextException;
            boolean bl = this.disconnectionSqlCodes == null ? sqlState.startsWith("08") || Utils.DISCONNECTION_SQL_CODES.contains(sqlState) : (fatalException = this.disconnectionSqlCodes.contains(sqlState));
            if (!fatalException && (nextException = e2.getNextException()) != null && nextException != e2) {
                fatalException = this.isDisconnectionSqlException(e2.getNextException());
            }
        }
        return fatalException;
    }

    @Override
    protected void handleException(SQLException e2) throws SQLException {
        this.fatalSqlExceptionThrown |= this.isDisconnectionSqlException(e2);
        super.handleException(e2);
    }

    public Collection<String> getDisconnectionSqlCodes() {
        return this.disconnectionSqlCodes;
    }

    public boolean isFastFailValidation() {
        return this.fastFailValidation;
    }

    static {
        try {
            MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }
}

