/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.ELParser;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageDataImpl;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.el.ELContextImpl;
import org.apache.tomcat.util.security.Escape;
import org.xml.sax.Attributes;

class Validator {
    Validator() {
    }

    public static void validateDirectives(Compiler compiler, Node.Nodes page) throws JasperException {
        page.visit(new DirectiveVisitor(compiler));
    }

    public static void validateExDirectives(Compiler compiler, Node.Nodes page) throws JasperException {
        PageInfo pageInfo = compiler.getPageInfo();
        String contentType = pageInfo.getContentType();
        if (contentType == null || contentType.indexOf("charset=") < 0) {
            boolean isXml = page.getRoot().isXmlSyntax();
            String defaultType = contentType == null ? (isXml ? "text/xml" : "text/html") : contentType;
            String charset = null;
            if (isXml) {
                charset = "UTF-8";
            } else if (!page.getRoot().isDefaultPageEncoding()) {
                charset = page.getRoot().getPageEncoding();
            }
            if (charset != null) {
                pageInfo.setContentType(defaultType + ";charset=" + charset);
            } else {
                pageInfo.setContentType(defaultType);
            }
        }
        page.visit(new ValidateVisitor(compiler));
        Validator.validateXmlView(new PageDataImpl(page, compiler), compiler);
        page.visit(new TagExtraInfoVisitor(compiler));
    }

    private static void validateXmlView(PageData xmlView, Compiler compiler) throws JasperException {
        StringBuilder errMsg = null;
        ErrorDispatcher errDisp = compiler.getErrorDispatcher();
        for (TagLibraryInfo o2 : compiler.getPageInfo().getTaglibs()) {
            TagLibraryInfoImpl tli;
            ValidationMessage[] errors;
            if (!(o2 instanceof TagLibraryInfoImpl) || (errors = (tli = (TagLibraryInfoImpl)o2).validate(xmlView)) == null || errors.length == 0) continue;
            if (errMsg == null) {
                errMsg = new StringBuilder();
            }
            errMsg.append("<h3>");
            errMsg.append(Localizer.getMessage("jsp.error.tlv.invalid.page", tli.getShortName(), compiler.getPageInfo().getJspFile()));
            errMsg.append("</h3>");
            for (ValidationMessage error : errors) {
                if (error == null) continue;
                errMsg.append("<p>");
                errMsg.append(error.getId());
                errMsg.append(": ");
                errMsg.append(error.getMessage());
                errMsg.append("</p>");
            }
        }
        if (errMsg != null) {
            errDisp.jspError(errMsg.toString(), new String[0]);
        }
    }

    private static class TagExtraInfoVisitor
    extends Node.Visitor {
        private final ErrorDispatcher err;

        TagExtraInfoVisitor(Compiler compiler) {
            this.err = compiler.getErrorDispatcher();
        }

        @Override
        public void visit(Node.CustomTag n2) throws JasperException {
            ValidationMessage[] errors;
            TagInfo tagInfo = n2.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)n2, "jsp.error.missing.tagInfo", n2.getQName());
            }
            if ((errors = tagInfo.validate(n2.getTagData())) != null && errors.length != 0) {
                StringBuilder errMsg = new StringBuilder();
                errMsg.append("<h3>");
                errMsg.append(Localizer.getMessage("jsp.error.tei.invalid.attributes", n2.getQName()));
                errMsg.append("</h3>");
                for (ValidationMessage error : errors) {
                    errMsg.append("<p>");
                    if (error.getId() != null) {
                        errMsg.append(error.getId());
                        errMsg.append(": ");
                    }
                    errMsg.append(error.getMessage());
                    errMsg.append("</p>");
                }
                this.err.jspError((Node)n2, errMsg.toString(), new String[0]);
            }
            this.visitBody(n2);
        }
    }

    private static class ValidateVisitor
    extends Node.Visitor {
        private static final Pattern METHOD_NAME_PATTERN = Pattern.compile(".*[ \t\n\r]+(.+?)[ \t\n\r]*\\(.*", 32);
        private final PageInfo pageInfo;
        private final ErrorDispatcher err;
        private final ClassLoader loader;
        private final StringBuilder buf = new StringBuilder(32);
        private static final JspUtil.ValidAttribute[] jspRootAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("xsi:schemaLocation"), new JspUtil.ValidAttribute("version", true)};
        private static final JspUtil.ValidAttribute[] includeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] taglibDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri"), new JspUtil.ValidAttribute("tagdir"), new JspUtil.ValidAttribute("prefix", true)};
        private static final JspUtil.ValidAttribute[] includeActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};
        private static final JspUtil.ValidAttribute[] paramActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("value", true)};
        private static final JspUtil.ValidAttribute[] forwardActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};
        private static final JspUtil.ValidAttribute[] getPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};
        private static final JspUtil.ValidAttribute[] setPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value", false), new JspUtil.ValidAttribute("param")};
        private static final JspUtil.ValidAttribute[] useBeanAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id", true), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName", false)};
        private static final JspUtil.ValidAttribute[] plugInAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height", false), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width", false), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};
        private static final JspUtil.ValidAttribute[] attributeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("trim"), new JspUtil.ValidAttribute("omit")};
        private static final JspUtil.ValidAttribute[] invokeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("fragment", true), new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] doBodyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] jspOutputAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("omit-xml-declaration"), new JspUtil.ValidAttribute("doctype-root-element"), new JspUtil.ValidAttribute("doctype-public"), new JspUtil.ValidAttribute("doctype-system")};
        private final ExpressionFactory expressionFactory;

        ValidateVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
            this.loader = compiler.getCompilationContext().getClassLoader();
            this.expressionFactory = JspFactory.getDefaultFactory().getJspApplicationContext(compiler.getCompilationContext().getServletContext()).getExpressionFactory();
        }

        @Override
        public void visit(Node.JspRoot n2) throws JasperException {
            JspUtil.checkAttributes("Jsp:root", n2, jspRootAttrs, this.err);
            String version = n2.getTextAttribute("version");
            if (!(version.equals("1.2") || version.equals("2.0") || version.equals("2.1") || version.equals("2.2") || version.equals("2.3"))) {
                this.err.jspError((Node)n2, "jsp.error.jsproot.version.invalid", version);
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.IncludeDirective n2) throws JasperException {
            JspUtil.checkAttributes("Include directive", n2, includeDirectiveAttrs, this.err);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.TaglibDirective n2) throws JasperException {
            JspUtil.checkAttributes("Taglib directive", n2, taglibDirectiveAttrs, this.err);
            String uri = n2.getAttributeValue("uri");
            String tagdir = n2.getAttributeValue("tagdir");
            if (uri == null && tagdir == null) {
                this.err.jspError((Node)n2, "jsp.error.taglibDirective.missing.location", new String[0]);
            }
            if (uri != null && tagdir != null) {
                this.err.jspError((Node)n2, "jsp.error.taglibDirective.both_uri_and_tagdir", new String[0]);
            }
        }

        @Override
        public void visit(Node.ParamAction n2) throws JasperException {
            JspUtil.checkAttributes("Param action", n2, paramActionAttrs, this.err);
            this.throwErrorIfExpression(n2, "name", "jsp:param");
            n2.setValue(this.getJspAttribute(null, "value", null, null, n2.getAttributeValue("value"), n2, null, false));
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.ParamsAction n2) throws JasperException {
            Node.Nodes subElems = n2.getBody();
            if (subElems == null) {
                this.err.jspError((Node)n2, "jsp.error.params.emptyBody", new String[0]);
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.IncludeAction n2) throws JasperException {
            JspUtil.checkAttributes("Include action", n2, includeActionAttrs, this.err);
            n2.setPage(this.getJspAttribute(null, "page", null, null, n2.getAttributeValue("page"), n2, null, false));
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.ForwardAction n2) throws JasperException {
            JspUtil.checkAttributes("Forward", n2, forwardActionAttrs, this.err);
            n2.setPage(this.getJspAttribute(null, "page", null, null, n2.getAttributeValue("page"), n2, null, false));
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.GetProperty n2) throws JasperException {
            JspUtil.checkAttributes("GetProperty", n2, getPropertyAttrs, this.err);
        }

        @Override
        public void visit(Node.SetProperty n2) throws JasperException {
            boolean valueSpecified;
            JspUtil.checkAttributes("SetProperty", n2, setPropertyAttrs, this.err);
            String property = n2.getTextAttribute("property");
            String param = n2.getTextAttribute("param");
            String value = n2.getAttributeValue("value");
            n2.setValue(this.getJspAttribute(null, "value", null, null, value, n2, null, false));
            boolean bl = valueSpecified = n2.getValue() != null;
            if ("*".equals(property)) {
                if (param != null || valueSpecified) {
                    this.err.jspError((Node)n2, "jsp.error.setProperty.invalid", new String[0]);
                }
            } else if (param != null && valueSpecified) {
                this.err.jspError((Node)n2, "jsp.error.setProperty.invalid", new String[0]);
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.UseBean n2) throws JasperException {
            JspUtil.checkAttributes("UseBean", n2, useBeanAttrs, this.err);
            String name = n2.getTextAttribute("id");
            String scope = n2.getTextAttribute("scope");
            JspUtil.checkScope(scope, n2, this.err);
            String className = n2.getTextAttribute("class");
            String type = n2.getTextAttribute("type");
            BeanRepository beanInfo = this.pageInfo.getBeanRepository();
            if (className == null && type == null) {
                this.err.jspError((Node)n2, "jsp.error.usebean.missingType", new String[0]);
            }
            if (beanInfo.checkVariable(name)) {
                this.err.jspError((Node)n2, "jsp.error.usebean.duplicate", new String[0]);
            }
            if ("session".equals(scope) && !this.pageInfo.isSession()) {
                this.err.jspError((Node)n2, "jsp.error.usebean.noSession", new String[0]);
            }
            Node.JspAttribute jattr = this.getJspAttribute(null, "beanName", null, null, n2.getAttributeValue("beanName"), n2, null, false);
            n2.setBeanName(jattr);
            if (className != null && jattr != null) {
                this.err.jspError((Node)n2, "jsp.error.usebean.notBoth", new String[0]);
            }
            if (className == null) {
                className = type;
            }
            beanInfo.addBean(n2, name, className, scope);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.PlugIn n2) throws JasperException {
            JspUtil.checkAttributes("Plugin", n2, plugInAttrs, this.err);
            this.throwErrorIfExpression(n2, "type", "jsp:plugin");
            this.throwErrorIfExpression(n2, "code", "jsp:plugin");
            this.throwErrorIfExpression(n2, "codebase", "jsp:plugin");
            this.throwErrorIfExpression(n2, "align", "jsp:plugin");
            this.throwErrorIfExpression(n2, "archive", "jsp:plugin");
            this.throwErrorIfExpression(n2, "hspace", "jsp:plugin");
            this.throwErrorIfExpression(n2, "jreversion", "jsp:plugin");
            this.throwErrorIfExpression(n2, "name", "jsp:plugin");
            this.throwErrorIfExpression(n2, "vspace", "jsp:plugin");
            this.throwErrorIfExpression(n2, "nspluginurl", "jsp:plugin");
            this.throwErrorIfExpression(n2, "iepluginurl", "jsp:plugin");
            String type = n2.getTextAttribute("type");
            if (type == null) {
                this.err.jspError((Node)n2, "jsp.error.plugin.notype", new String[0]);
            }
            if (!type.equals("bean") && !type.equals("applet")) {
                this.err.jspError((Node)n2, "jsp.error.plugin.badtype", new String[0]);
            }
            if (n2.getTextAttribute("code") == null) {
                this.err.jspError((Node)n2, "jsp.error.plugin.nocode", new String[0]);
            }
            Node.JspAttribute width = this.getJspAttribute(null, "width", null, null, n2.getAttributeValue("width"), n2, null, false);
            n2.setWidth(width);
            Node.JspAttribute height = this.getJspAttribute(null, "height", null, null, n2.getAttributeValue("height"), n2, null, false);
            n2.setHeight(height);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.NamedAttribute n2) throws JasperException {
            JspUtil.checkAttributes("Attribute", n2, attributeAttrs, this.err);
            n2.setOmit(this.getJspAttribute(null, "omit", null, null, n2.getAttributeValue("omit"), n2, null, false));
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspBody n2) throws JasperException {
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.Declaration n2) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n2.getStart(), "jsp.error.no.scriptlets", new String[0]);
            }
        }

        @Override
        public void visit(Node.Expression n2) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n2.getStart(), "jsp.error.no.scriptlets", new String[0]);
            }
        }

        @Override
        public void visit(Node.Scriptlet n2) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n2.getStart(), "jsp.error.no.scriptlets", new String[0]);
            }
        }

        @Override
        public void visit(Node.ELExpression n2) throws JasperException {
            if (this.pageInfo.isELIgnored()) {
                return;
            }
            if (n2.getType() == '#') {
                if (!this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                    this.err.jspError((Node)n2, "jsp.error.el.template.deferred", new String[0]);
                } else {
                    return;
                }
            }
            StringBuilder expr = this.getBuffer();
            expr.append(n2.getType()).append('{').append(n2.getText()).append('}');
            ELNode.Nodes el = ELParser.parse(expr.toString(), this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
            this.prepareExpression(el, n2, expr.toString());
            n2.setEL(el);
        }

        @Override
        public void visit(Node.UninterpretedTag n2) throws JasperException {
            Attributes attrs;
            if (n2.getNamedAttributeNodes().size() != 0) {
                this.err.jspError((Node)n2, "jsp.error.namedAttribute.invalidUse", new String[0]);
            }
            if ((attrs = n2.getAttributes()) != null) {
                int attrSize = attrs.getLength();
                Node.JspAttribute[] jspAttrs = new Node.JspAttribute[attrSize];
                for (int i2 = 0; i2 < attrSize; ++i2) {
                    String value = attrs.getValue(i2);
                    if (!this.pageInfo.isDeferredSyntaxAllowedAsLiteral() && this.containsDeferredSyntax(value)) {
                        this.err.jspError((Node)n2, "jsp.error.el.template.deferred", new String[0]);
                    }
                    jspAttrs[i2] = this.getJspAttribute(null, attrs.getQName(i2), attrs.getURI(i2), attrs.getLocalName(i2), value, n2, null, false);
                }
                n2.setJspAttributes(jspAttrs);
            }
            this.visitBody(n2);
        }

        private boolean containsDeferredSyntax(String value) {
            if (value == null) {
                return false;
            }
            int len = value.length();
            boolean prevCharIsEscape = false;
            for (int i2 = 0; i2 < value.length(); ++i2) {
                char c2 = value.charAt(i2);
                if (c2 == '#' && i2 + 1 < len && value.charAt(i2 + 1) == '{' && !prevCharIsEscape) {
                    return true;
                }
                prevCharIsEscape = c2 == '\\';
            }
            return false;
        }

        @Override
        public void visit(Node.CustomTag n2) throws JasperException {
            TagInfo tagInfo = n2.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)n2, "jsp.error.missing.tagInfo", n2.getQName());
            }
            if (n2.implementsSimpleTag() && tagInfo.getBodyContent().equalsIgnoreCase("JSP")) {
                this.err.jspError((Node)n2, "jsp.error.simpletag.badbodycontent", tagInfo.getTagClassName());
            }
            if (tagInfo.hasDynamicAttributes() && !n2.implementsDynamicAttributes()) {
                this.err.jspError((Node)n2, "jsp.error.dynamic.attributes.not.implemented", n2.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            String customActionUri = n2.getURI();
            Attributes attrs = n2.getAttributes();
            int attrsSize = attrs == null ? 0 : attrs.getLength();
            for (TagAttributeInfo tldAttr : tldAttrs) {
                String attr = null;
                if (attrs != null && (attr = attrs.getValue(tldAttr.getName())) == null) {
                    attr = attrs.getValue(customActionUri, tldAttr.getName());
                }
                Node.NamedAttribute na = n2.getNamedAttributeNode(tldAttr.getName());
                if (tldAttr.isRequired() && attr == null && na == null) {
                    this.err.jspError((Node)n2, "jsp.error.missing_attribute", tldAttr.getName(), n2.getLocalName());
                }
                if (attr == null || na == null) continue;
                this.err.jspError((Node)n2, "jsp.error.duplicate.name.jspattribute", tldAttr.getName());
            }
            Node.Nodes naNodes = n2.getNamedAttributeNodes();
            int jspAttrsSize = naNodes.size() + attrsSize;
            Node.JspAttribute[] jspAttrs = null;
            if (jspAttrsSize > 0) {
                jspAttrs = new Node.JspAttribute[jspAttrsSize];
            }
            Hashtable<String, Object> tagDataAttrs = new Hashtable<String, Object>(attrsSize);
            this.checkXmlAttributes(n2, jspAttrs, tagDataAttrs);
            this.checkNamedAttributes(n2, jspAttrs, attrsSize, tagDataAttrs);
            TagData tagData = new TagData(tagDataAttrs);
            TagExtraInfo tei = tagInfo.getTagExtraInfo();
            if (tei != null && tei.getVariableInfo(tagData) != null && tei.getVariableInfo(tagData).length > 0 && tagInfo.getTagVariableInfos().length > 0) {
                this.err.jspError("jsp.error.non_null_tei_and_var_subelems", n2.getQName());
            }
            n2.setTagData(tagData);
            n2.setJspAttributes(jspAttrs);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspElement n2) throws JasperException {
            int i2;
            Attributes attrs = n2.getAttributes();
            if (attrs == null) {
                this.err.jspError((Node)n2, "jsp.error.jspelement.missing.name", new String[0]);
            }
            int xmlAttrLen = attrs.getLength();
            Node.Nodes namedAttrs = n2.getNamedAttributeNodes();
            int jspAttrSize = xmlAttrLen - 1 + namedAttrs.size();
            Node.JspAttribute[] jspAttrs = new Node.JspAttribute[jspAttrSize];
            int jspAttrIndex = 0;
            for (i2 = 0; i2 < xmlAttrLen; ++i2) {
                if ("name".equals(attrs.getLocalName(i2))) {
                    n2.setNameAttribute(this.getJspAttribute(null, attrs.getQName(i2), attrs.getURI(i2), attrs.getLocalName(i2), attrs.getValue(i2), n2, null, false));
                    continue;
                }
                if (jspAttrIndex >= jspAttrSize) continue;
                jspAttrs[jspAttrIndex++] = this.getJspAttribute(null, attrs.getQName(i2), attrs.getURI(i2), attrs.getLocalName(i2), attrs.getValue(i2), n2, null, false);
            }
            if (n2.getNameAttribute() == null) {
                this.err.jspError((Node)n2, "jsp.error.jspelement.missing.name", new String[0]);
            }
            for (i2 = 0; i2 < namedAttrs.size(); ++i2) {
                Node.NamedAttribute na = (Node.NamedAttribute)namedAttrs.getNode(i2);
                jspAttrs[jspAttrIndex++] = new Node.JspAttribute(na, null, false);
            }
            n2.setJspAttributes(jspAttrs);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspOutput n2) throws JasperException {
            JspUtil.checkAttributes("jsp:output", n2, jspOutputAttrs, this.err);
            if (n2.getBody() != null) {
                this.err.jspError((Node)n2, "jsp.error.jspoutput.nonemptybody", new String[0]);
            }
            String omitXmlDecl = n2.getAttributeValue("omit-xml-declaration");
            String doctypeName = n2.getAttributeValue("doctype-root-element");
            String doctypePublic = n2.getAttributeValue("doctype-public");
            String doctypeSystem = n2.getAttributeValue("doctype-system");
            String omitXmlDeclOld = this.pageInfo.getOmitXmlDecl();
            String doctypeNameOld = this.pageInfo.getDoctypeName();
            String doctypePublicOld = this.pageInfo.getDoctypePublic();
            String doctypeSystemOld = this.pageInfo.getDoctypeSystem();
            if (omitXmlDecl != null && omitXmlDeclOld != null && !omitXmlDecl.equals(omitXmlDeclOld)) {
                this.err.jspError((Node)n2, "jsp.error.jspoutput.conflict", "omit-xml-declaration", omitXmlDeclOld, omitXmlDecl);
            }
            if (doctypeName != null && doctypeNameOld != null && !doctypeName.equals(doctypeNameOld)) {
                this.err.jspError((Node)n2, "jsp.error.jspoutput.conflict", "doctype-root-element", doctypeNameOld, doctypeName);
            }
            if (doctypePublic != null && doctypePublicOld != null && !doctypePublic.equals(doctypePublicOld)) {
                this.err.jspError((Node)n2, "jsp.error.jspoutput.conflict", "doctype-public", doctypePublicOld, doctypePublic);
            }
            if (doctypeSystem != null && doctypeSystemOld != null && !doctypeSystem.equals(doctypeSystemOld)) {
                this.err.jspError((Node)n2, "jsp.error.jspoutput.conflict", "doctype-system", doctypeSystemOld, doctypeSystem);
            }
            if (doctypeName == null && doctypeSystem != null || doctypeName != null && doctypeSystem == null) {
                this.err.jspError((Node)n2, "jsp.error.jspoutput.doctypenamesystem", new String[0]);
            }
            if (doctypePublic != null && doctypeSystem == null) {
                this.err.jspError((Node)n2, "jsp.error.jspoutput.doctypepublicsystem", new String[0]);
            }
            if (omitXmlDecl != null) {
                this.pageInfo.setOmitXmlDecl(omitXmlDecl);
            }
            if (doctypeName != null) {
                this.pageInfo.setDoctypeName(doctypeName);
            }
            if (doctypeSystem != null) {
                this.pageInfo.setDoctypeSystem(doctypeSystem);
            }
            if (doctypePublic != null) {
                this.pageInfo.setDoctypePublic(doctypePublic);
            }
        }

        @Override
        public void visit(Node.InvokeAction n2) throws JasperException {
            JspUtil.checkAttributes("Invoke", n2, invokeAttrs, this.err);
            String scope = n2.getTextAttribute("scope");
            JspUtil.checkScope(scope, n2, this.err);
            String var = n2.getTextAttribute("var");
            String varReader = n2.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError((Node)n2, "jsp.error.missing_var_or_varReader", new String[0]);
            }
            if (var != null && varReader != null) {
                this.err.jspError((Node)n2, "jsp.error.var_and_varReader", new String[0]);
            }
        }

        @Override
        public void visit(Node.DoBodyAction n2) throws JasperException {
            JspUtil.checkAttributes("DoBody", n2, doBodyAttrs, this.err);
            String scope = n2.getTextAttribute("scope");
            JspUtil.checkScope(scope, n2, this.err);
            String var = n2.getTextAttribute("var");
            String varReader = n2.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError((Node)n2, "jsp.error.missing_var_or_varReader", new String[0]);
            }
            if (var != null && varReader != null) {
                this.err.jspError((Node)n2, "jsp.error.var_and_varReader", new String[0]);
            }
        }

        private void checkXmlAttributes(Node.CustomTag n2, Node.JspAttribute[] jspAttrs, Hashtable<String, Object> tagDataAttrs) throws JasperException {
            TagInfo tagInfo = n2.getTagInfo();
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Attributes attrs = n2.getAttributes();
            for (int i2 = 0; attrs != null && i2 < attrs.getLength(); ++i2) {
                Iterator<ELNode> it;
                boolean expression;
                boolean found = false;
                boolean runtimeExpression = n2.getRoot().isXmlSyntax() && attrs.getValue(i2).startsWith("%=") || !n2.getRoot().isXmlSyntax() && attrs.getValue(i2).startsWith("<%=");
                boolean elExpression = false;
                boolean deferred = false;
                double libraryVersion = Double.parseDouble(tagInfo.getTagLibrary().getRequiredVersion());
                boolean deferredSyntaxAllowedAsLiteral = this.pageInfo.isDeferredSyntaxAllowedAsLiteral() || libraryVersion < 2.1;
                String xmlAttributeValue = attrs.getValue(i2);
                ELNode.Nodes el = null;
                if (!runtimeExpression && !this.pageInfo.isELIgnored()) {
                    el = ELParser.parse(xmlAttributeValue, deferredSyntaxAllowedAsLiteral);
                    Iterator<ELNode> nodes = el.iterator();
                    while (nodes.hasNext()) {
                        ELNode node = nodes.next();
                        if (!(node instanceof ELNode.Root)) continue;
                        if (((ELNode.Root)node).getType() == '$') {
                            if (elExpression && deferred) {
                                this.err.jspError((Node)n2, "jsp.error.attribute.deferredmix", new String[0]);
                            }
                            elExpression = true;
                            continue;
                        }
                        if (((ELNode.Root)node).getType() != '#') continue;
                        if (elExpression && !deferred) {
                            this.err.jspError((Node)n2, "jsp.error.attribute.deferredmix", new String[0]);
                        }
                        elExpression = true;
                        deferred = true;
                    }
                }
                boolean bl = expression = runtimeExpression || elExpression;
                String textAttributeValue = !elExpression && el != null ? ((it = el.iterator()).hasNext() ? ((ELNode.Text)it.next()).getText() : "") : xmlAttributeValue;
                for (int j2 = 0; tldAttrs != null && j2 < tldAttrs.length; ++j2) {
                    if (!attrs.getLocalName(i2).equals(tldAttrs[j2].getName()) || attrs.getURI(i2) != null && attrs.getURI(i2).length() != 0 && !attrs.getURI(i2).equals(n2.getURI())) continue;
                    TagAttributeInfo tldAttr = tldAttrs[j2];
                    if (tldAttr.canBeRequestTime() || tldAttr.isDeferredMethod() || tldAttr.isDeferredValue()) {
                        if (!expression) {
                            String expectedType = null;
                            if (tldAttr.isDeferredMethod()) {
                                String m2 = tldAttr.getMethodSignature();
                                if (m2 != null) {
                                    int rti = (m2 = m2.trim()).indexOf(32);
                                    if (rti > 0) {
                                        expectedType = m2.substring(0, rti).trim();
                                    }
                                } else {
                                    expectedType = "java.lang.Object";
                                }
                                if ("void".equals(expectedType)) {
                                    this.err.jspError((Node)n2, "jsp.error.literal_with_void", tldAttr.getName());
                                }
                            }
                            if (tldAttr.isDeferredValue()) {
                                expectedType = tldAttr.getExpectedTypeName();
                            }
                            if (expectedType != null) {
                                Class expectedClass = String.class;
                                try {
                                    expectedClass = JspUtil.toClass(expectedType, this.loader);
                                }
                                catch (ClassNotFoundException e2) {
                                    this.err.jspError((Node)n2, "jsp.error.unknown_attribute_type", tldAttr.getName(), expectedType);
                                }
                                if (String.class.equals(expectedClass) || expectedClass == Long.TYPE || expectedClass == Double.TYPE || expectedClass == Byte.TYPE || expectedClass == Short.TYPE || expectedClass == Integer.TYPE || expectedClass == Float.TYPE || Number.class.isAssignableFrom(expectedClass) || Character.class.equals(expectedClass) || Character.TYPE == expectedClass || Boolean.class.equals(expectedClass) || Boolean.TYPE == expectedClass || expectedClass.isEnum()) {
                                    try {
                                        this.expressionFactory.coerceToType(textAttributeValue, expectedClass);
                                    }
                                    catch (Exception e3) {
                                        this.err.jspError((Node)n2, "jsp.error.coerce_to_type", tldAttr.getName(), expectedType, textAttributeValue);
                                    }
                                }
                            }
                            jspAttrs[i2] = new Node.JspAttribute(tldAttr, attrs.getQName(i2), attrs.getURI(i2), attrs.getLocalName(i2), textAttributeValue, false, null, false);
                        } else {
                            if (deferred && !tldAttr.isDeferredMethod() && !tldAttr.isDeferredValue()) {
                                this.err.jspError((Node)n2, "jsp.error.attribute.custom.non_rt_with_expr", tldAttr.getName());
                            }
                            if (!deferred && !tldAttr.canBeRequestTime()) {
                                this.err.jspError((Node)n2, "jsp.error.attribute.custom.non_rt_with_expr", tldAttr.getName());
                            }
                            jspAttrs[i2] = this.getJspAttribute(tldAttr, attrs.getQName(i2), attrs.getURI(i2), attrs.getLocalName(i2), xmlAttributeValue, n2, el, false);
                        }
                    } else {
                        if (expression) {
                            this.err.jspError((Node)n2, "jsp.error.attribute.custom.non_rt_with_expr", tldAttr.getName());
                        }
                        jspAttrs[i2] = new Node.JspAttribute(tldAttr, attrs.getQName(i2), attrs.getURI(i2), attrs.getLocalName(i2), textAttributeValue, false, null, false);
                    }
                    if (expression) {
                        tagDataAttrs.put(attrs.getQName(i2), TagData.REQUEST_TIME_VALUE);
                    } else {
                        tagDataAttrs.put(attrs.getQName(i2), textAttributeValue);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttrs[i2] = this.getJspAttribute(null, attrs.getQName(i2), attrs.getURI(i2), attrs.getLocalName(i2), xmlAttributeValue, n2, el, true);
                    continue;
                }
                this.err.jspError((Node)n2, "jsp.error.bad_attribute", attrs.getQName(i2), n2.getLocalName());
            }
        }

        private void checkNamedAttributes(Node.CustomTag n2, Node.JspAttribute[] jspAttrs, int start, Hashtable<String, Object> tagDataAttrs) throws JasperException {
            TagInfo tagInfo = n2.getTagInfo();
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Node.Nodes naNodes = n2.getNamedAttributeNodes();
            for (int i2 = 0; i2 < naNodes.size(); ++i2) {
                Node.NamedAttribute na = (Node.NamedAttribute)naNodes.getNode(i2);
                boolean found = false;
                for (TagAttributeInfo tldAttr : tldAttrs) {
                    String attrPrefix = na.getPrefix();
                    if (!na.getLocalName().equals(tldAttr.getName()) || attrPrefix != null && attrPrefix.length() != 0 && !attrPrefix.equals(n2.getPrefix())) continue;
                    jspAttrs[start + i2] = new Node.JspAttribute(na, tldAttr, false);
                    NamedAttributeVisitor nav = null;
                    if (na.getBody() != null) {
                        nav = new NamedAttributeVisitor();
                        na.getBody().visit(nav);
                    }
                    if (nav != null && nav.hasDynamicContent()) {
                        tagDataAttrs.put(na.getName(), TagData.REQUEST_TIME_VALUE);
                    } else {
                        tagDataAttrs.put(na.getName(), na.getText());
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttrs[start + i2] = new Node.JspAttribute(na, null, true);
                    continue;
                }
                this.err.jspError((Node)n2, "jsp.error.bad_attribute", na.getName(), n2.getLocalName());
            }
        }

        private Node.JspAttribute getJspAttribute(TagAttributeInfo tai, String qName, String uri, String localName, String value, Node n2, ELNode.Nodes el, boolean dynamic) throws JasperException {
            Node.JspAttribute result = null;
            if (value != null) {
                if (n2.getRoot().isXmlSyntax() && value.startsWith("%=")) {
                    result = new Node.JspAttribute(tai, qName, uri, localName, value.substring(2, value.length() - 1), true, null, dynamic);
                } else if (!n2.getRoot().isXmlSyntax() && value.startsWith("<%=")) {
                    result = new Node.JspAttribute(tai, qName, uri, localName, value.substring(3, value.length() - 2), true, null, dynamic);
                } else {
                    if (!this.pageInfo.isELIgnored()) {
                        if (el == null) {
                            el = ELParser.parse(value, this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
                        }
                        if (el.containsEL()) {
                            this.validateFunctions(el, n2);
                        } else {
                            Iterator<ELNode> it = el.iterator();
                            value = it.hasNext() ? ((ELNode.Text)it.next()).getText() : "";
                            el = null;
                        }
                    }
                    if (n2 instanceof Node.UninterpretedTag && n2.getRoot().isXmlSyntax()) {
                        if (el != null) {
                            XmlEscapeNonELVisitor v = new XmlEscapeNonELVisitor(this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
                            el.visit(v);
                            value = v.getText();
                        } else {
                            value = Escape.xml(value);
                        }
                    }
                    result = new Node.JspAttribute(tai, qName, uri, localName, value, false, el, dynamic);
                    if (el != null) {
                        ELContextImpl ctx = new ELContextImpl(this.expressionFactory);
                        ctx.setFunctionMapper(this.getFunctionMapper(el));
                        try {
                            result.validateEL(this.pageInfo.getExpressionFactory(), ctx);
                        }
                        catch (ELException e2) {
                            this.err.jspError(n2.getStart(), "jsp.error.invalid.expression", value, e2.toString());
                        }
                    }
                }
            } else {
                Node.NamedAttribute namedAttributeNode = n2.getNamedAttributeNode(qName);
                if (namedAttributeNode != null) {
                    result = new Node.JspAttribute(namedAttributeNode, tai, dynamic);
                }
            }
            return result;
        }

        private StringBuilder getBuffer() {
            this.buf.setLength(0);
            return this.buf;
        }

        private boolean isExpression(Node n2, String value, boolean checkDeferred) {
            boolean runtimeExpression = n2.getRoot().isXmlSyntax() && value.startsWith("%=") || !n2.getRoot().isXmlSyntax() && value.startsWith("<%=");
            boolean elExpression = false;
            if (!runtimeExpression && !this.pageInfo.isELIgnored()) {
                Iterator<ELNode> nodes = ELParser.parse(value, this.pageInfo.isDeferredSyntaxAllowedAsLiteral()).iterator();
                while (nodes.hasNext()) {
                    ELNode node = nodes.next();
                    if (!(node instanceof ELNode.Root)) continue;
                    if (((ELNode.Root)node).getType() == '$') {
                        elExpression = true;
                        break;
                    }
                    if (!checkDeferred || this.pageInfo.isDeferredSyntaxAllowedAsLiteral() || ((ELNode.Root)node).getType() != '#') continue;
                    elExpression = true;
                    break;
                }
            }
            return runtimeExpression || elExpression;
        }

        private void throwErrorIfExpression(Node n2, String attrName, String actionName) throws JasperException {
            if (n2.getAttributes() != null && n2.getAttributes().getValue(attrName) != null && this.isExpression(n2, n2.getAttributes().getValue(attrName), true)) {
                this.err.jspError(n2, "jsp.error.attribute.standard.non_rt_with_expr", attrName, actionName);
            }
        }

        private String findUri(String prefix, Node n2) {
            for (Node p2 = n2; p2 != null; p2 = p2.getParent()) {
                Attributes attrs = p2.getTaglibAttributes();
                if (attrs == null) continue;
                for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
                    String name = attrs.getQName(i2);
                    int k2 = name.indexOf(58);
                    if (prefix == null && k2 < 0) {
                        return attrs.getValue(i2);
                    }
                    if (prefix == null || k2 < 0 || !prefix.equals(name.substring(k2 + 1))) continue;
                    return attrs.getValue(i2);
                }
            }
            return null;
        }

        private void validateFunctions(ELNode.Nodes el, Node n2) throws JasperException {
            class FVVisitor
            extends ELNode.Visitor {
                private Node n;

                FVVisitor(Node n2) {
                    this.n = n2;
                }

                @Override
                public void visit(ELNode.Function func) throws JasperException {
                    String prefix = func.getPrefix();
                    String function = func.getName();
                    String uri = null;
                    if (this.n.getRoot().isXmlSyntax()) {
                        uri = ValidateVisitor.this.findUri(prefix, this.n);
                    } else if (prefix != null) {
                        uri = ValidateVisitor.this.pageInfo.getURI(prefix);
                    }
                    if (uri == null) {
                        if (prefix == null) {
                            return;
                        }
                        ValidateVisitor.this.err.jspError(this.n, "jsp.error.attribute.invalidPrefix", prefix);
                    }
                    TagLibraryInfo taglib = ValidateVisitor.this.pageInfo.getTaglib(uri);
                    FunctionInfo funcInfo = null;
                    if (taglib != null) {
                        funcInfo = taglib.getFunction(function);
                    }
                    if (funcInfo == null) {
                        ValidateVisitor.this.err.jspError(this.n, "jsp.error.noFunction", function);
                    }
                    func.setUri(uri);
                    func.setFunctionInfo(funcInfo);
                    ValidateVisitor.this.processSignature(func);
                }
            }
            el.visit(new FVVisitor(n2));
        }

        private void prepareExpression(ELNode.Nodes el, Node n2, String expr) throws JasperException {
            this.validateFunctions(el, n2);
            ELContextImpl ctx = new ELContextImpl(this.expressionFactory);
            ctx.setFunctionMapper(this.getFunctionMapper(el));
            ExpressionFactory ef = this.pageInfo.getExpressionFactory();
            try {
                ef.createValueExpression(ctx, expr, Object.class);
            }
            catch (ELException e2) {
                throw new JasperException(e2);
            }
        }

        private void processSignature(ELNode.Function func) throws JasperException {
            func.setMethodName(this.getMethod(func));
            func.setParameters(this.getParameters(func));
        }

        private String getMethod(ELNode.Function func) throws JasperException {
            FunctionInfo funcInfo = func.getFunctionInfo();
            String signature = funcInfo.getFunctionSignature();
            Matcher m2 = METHOD_NAME_PATTERN.matcher(signature);
            if (!m2.matches()) {
                this.err.jspError("jsp.error.tld.fn.invalid.signature", func.getPrefix(), func.getName());
            }
            return m2.group(1);
        }

        private String[] getParameters(ELNode.Function func) throws JasperException {
            FunctionInfo funcInfo = func.getFunctionInfo();
            String signature = funcInfo.getFunctionSignature();
            ArrayList<String> params = new ArrayList<String>();
            int start = signature.indexOf(40) + 1;
            boolean lastArg = false;
            while (true) {
                String arg;
                int p2;
                if ((p2 = signature.indexOf(44, start)) < 0) {
                    p2 = signature.indexOf(41, start);
                    if (p2 < 0) {
                        this.err.jspError("jsp.error.tld.fn.invalid.signature", func.getPrefix(), func.getName());
                    }
                    lastArg = true;
                }
                if (!"".equals(arg = signature.substring(start, p2).trim())) {
                    params.add(arg);
                }
                if (lastArg) break;
                start = p2 + 1;
            }
            return params.toArray(new String[0]);
        }

        private FunctionMapper getFunctionMapper(ELNode.Nodes el) throws JasperException {
            class ValidateFunctionMapper
            extends FunctionMapper {
                private HashMap<String, Method> fnmap = new HashMap();

                ValidateFunctionMapper() {
                }

                @Override
                public void mapFunction(String prefix, String localName, Method method) {
                    this.fnmap.put(prefix + ":" + localName, method);
                }

                @Override
                public Method resolveFunction(String prefix, String localName) {
                    return this.fnmap.get(prefix + ":" + localName);
                }
            }
            ValidateFunctionMapper fmapper = new ValidateFunctionMapper();
            class MapperELVisitor
            extends ELNode.Visitor {
                private ValidateFunctionMapper fmapper;

                MapperELVisitor(ValidateFunctionMapper fmapper) {
                    this.fmapper = fmapper;
                }

                @Override
                public void visit(ELNode.Function n2) throws JasperException {
                    if (n2.getFunctionInfo() == null) {
                        return;
                    }
                    Class<?> c2 = null;
                    Method method = null;
                    try {
                        c2 = ValidateVisitor.this.loader.loadClass(n2.getFunctionInfo().getFunctionClass());
                    }
                    catch (ClassNotFoundException e2) {
                        ValidateVisitor.this.err.jspError("jsp.error.function.classnotfound", n2.getFunctionInfo().getFunctionClass(), n2.getPrefix() + ':' + n2.getName(), e2.getMessage());
                    }
                    String[] paramTypes = n2.getParameters();
                    int size = paramTypes.length;
                    Class[] params = new Class[size];
                    int i2 = 0;
                    try {
                        for (i2 = 0; i2 < size; ++i2) {
                            params[i2] = JspUtil.toClass(paramTypes[i2], ValidateVisitor.this.loader);
                        }
                        method = c2.getDeclaredMethod(n2.getMethodName(), params);
                    }
                    catch (ClassNotFoundException e3) {
                        ValidateVisitor.this.err.jspError("jsp.error.signature.classnotfound", paramTypes[i2], n2.getPrefix() + ':' + n2.getName(), e3.getMessage());
                    }
                    catch (NoSuchMethodException e4) {
                        ValidateVisitor.this.err.jspError("jsp.error.noFunctionMethod", n2.getMethodName(), n2.getName(), c2.getName());
                    }
                    this.fmapper.mapFunction(n2.getPrefix(), n2.getName(), method);
                }
            }
            el.visit(new MapperELVisitor(fmapper));
            return fmapper;
        }

        private static class NamedAttributeVisitor
        extends Node.Visitor {
            private boolean hasDynamicContent;

            private NamedAttributeVisitor() {
            }

            @Override
            public void doVisit(Node n2) throws JasperException {
                if (!(n2 instanceof Node.JspText) && !(n2 instanceof Node.TemplateText)) {
                    this.hasDynamicContent = true;
                }
                this.visitBody(n2);
            }

            public boolean hasDynamicContent() {
                return this.hasDynamicContent;
            }
        }

        private static class XmlEscapeNonELVisitor
        extends ELParser.TextBuilder {
            protected XmlEscapeNonELVisitor(boolean isDeferredSyntaxAllowedAsLiteral) {
                super(isDeferredSyntaxAllowedAsLiteral);
            }

            @Override
            public void visit(ELNode.Text n2) throws JasperException {
                this.output.append(ELParser.escapeLiteralExpression(Escape.xml(n2.getText()), this.isDeferredSyntaxAllowedAsLiteral));
            }
        }
    }

    private static class DirectiveVisitor
    extends Node.Visitor {
        private final PageInfo pageInfo;
        private final ErrorDispatcher err;
        private static final JspUtil.ValidAttribute[] pageDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("isELIgnored"), new JspUtil.ValidAttribute("deferredSyntaxAllowedAsLiteral"), new JspUtil.ValidAttribute("trimDirectiveWhitespaces")};
        private boolean pageEncodingSeen = false;

        DirectiveVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        @Override
        public void visit(Node.IncludeDirective n2) throws JasperException {
            boolean pageEncodingSeenSave = this.pageEncodingSeen;
            this.pageEncodingSeen = false;
            this.visitBody(n2);
            this.pageEncodingSeen = pageEncodingSeenSave;
        }

        @Override
        public void visit(Node.PageDirective n2) throws JasperException {
            JspUtil.checkAttributes("Page directive", n2, pageDirectiveAttrs, this.err);
            Attributes attrs = n2.getAttributes();
            for (int i2 = 0; attrs != null && i2 < attrs.getLength(); ++i2) {
                String attr = attrs.getQName(i2);
                String value = attrs.getValue(i2);
                if ("language".equals(attr)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(value, n2, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.language", this.pageInfo.getLanguage(false), value);
                    continue;
                }
                if ("extends".equals(attr)) {
                    if (this.pageInfo.getExtends(false) == null) {
                        this.pageInfo.setExtends(value);
                        continue;
                    }
                    if (this.pageInfo.getExtends(false).equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.extends", this.pageInfo.getExtends(false), value);
                    continue;
                }
                if ("contentType".equals(attr)) {
                    if (this.pageInfo.getContentType() == null) {
                        this.pageInfo.setContentType(value);
                        continue;
                    }
                    if (this.pageInfo.getContentType().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.contenttype", this.pageInfo.getContentType(), value);
                    continue;
                }
                if ("session".equals(attr)) {
                    if (this.pageInfo.getSession() == null) {
                        this.pageInfo.setSession(value, n2, this.err);
                        continue;
                    }
                    if (this.pageInfo.getSession().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.session", this.pageInfo.getSession(), value);
                    continue;
                }
                if ("buffer".equals(attr)) {
                    if (this.pageInfo.getBufferValue() == null) {
                        this.pageInfo.setBufferValue(value, n2, this.err);
                        continue;
                    }
                    if (this.pageInfo.getBufferValue().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.buffer", this.pageInfo.getBufferValue(), value);
                    continue;
                }
                if ("autoFlush".equals(attr)) {
                    if (this.pageInfo.getAutoFlush() == null) {
                        this.pageInfo.setAutoFlush(value, n2, this.err);
                        continue;
                    }
                    if (this.pageInfo.getAutoFlush().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.autoflush", this.pageInfo.getAutoFlush(), value);
                    continue;
                }
                if ("isThreadSafe".equals(attr)) {
                    if (this.pageInfo.getIsThreadSafe() == null) {
                        this.pageInfo.setIsThreadSafe(value, n2, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsThreadSafe().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.isthreadsafe", this.pageInfo.getIsThreadSafe(), value);
                    continue;
                }
                if ("isELIgnored".equals(attr)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(value, n2, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.iselignored", this.pageInfo.getIsELIgnored(), value);
                    continue;
                }
                if ("isErrorPage".equals(attr)) {
                    if (this.pageInfo.getIsErrorPage() == null) {
                        this.pageInfo.setIsErrorPage(value, n2, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsErrorPage().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.iserrorpage", this.pageInfo.getIsErrorPage(), value);
                    continue;
                }
                if ("errorPage".equals(attr)) {
                    if (this.pageInfo.getErrorPage() == null) {
                        this.pageInfo.setErrorPage(value);
                        continue;
                    }
                    if (this.pageInfo.getErrorPage().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.errorpage", this.pageInfo.getErrorPage(), value);
                    continue;
                }
                if ("info".equals(attr)) {
                    if (this.pageInfo.getInfo() == null) {
                        this.pageInfo.setInfo(value);
                        continue;
                    }
                    if (this.pageInfo.getInfo().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.info", this.pageInfo.getInfo(), value);
                    continue;
                }
                if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError((Node)n2, "jsp.error.page.multi.pageencoding", new String[0]);
                    }
                    this.pageEncodingSeen = true;
                    String actual = this.comparePageEncodings(value, n2);
                    n2.getRoot().setPageEncoding(actual);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(attr)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(value, n2, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.page.conflict.deferredsyntaxallowedasliteral", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), value);
                    continue;
                }
                if (!"trimDirectiveWhitespaces".equals(attr)) continue;
                if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                    this.pageInfo.setTrimDirectiveWhitespaces(value, n2, this.err, true);
                    continue;
                }
                if (this.pageInfo.getTrimDirectiveWhitespaces().equals(value)) continue;
                this.err.jspError((Node)n2, "jsp.error.page.conflict.trimdirectivewhitespaces", this.pageInfo.getTrimDirectiveWhitespaces(), value);
            }
            if (this.pageInfo.getBuffer() == 0 && !this.pageInfo.isAutoFlush()) {
                this.err.jspError((Node)n2, "jsp.error.page.badCombo", new String[0]);
            }
            this.pageInfo.addImports(n2.getImports());
        }

        @Override
        public void visit(Node.TagDirective n2) throws JasperException {
            Attributes attrs = n2.getAttributes();
            for (int i2 = 0; attrs != null && i2 < attrs.getLength(); ++i2) {
                String attr = attrs.getQName(i2);
                String value = attrs.getValue(i2);
                if ("language".equals(attr)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(value, n2, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.tag.conflict.language", this.pageInfo.getLanguage(false), value);
                    continue;
                }
                if ("isELIgnored".equals(attr)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(value, n2, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.tag.conflict.iselignored", this.pageInfo.getIsELIgnored(), value);
                    continue;
                }
                if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError((Node)n2, "jsp.error.tag.multi.pageencoding", new String[0]);
                    }
                    this.pageEncodingSeen = true;
                    this.compareTagEncodings(value, n2);
                    n2.getRoot().setPageEncoding(value);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(attr)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(value, n2, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(value)) continue;
                    this.err.jspError((Node)n2, "jsp.error.tag.conflict.deferredsyntaxallowedasliteral", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), value);
                    continue;
                }
                if (!"trimDirectiveWhitespaces".equals(attr)) continue;
                if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                    this.pageInfo.setTrimDirectiveWhitespaces(value, n2, this.err, false);
                    continue;
                }
                if (this.pageInfo.getTrimDirectiveWhitespaces().equals(value)) continue;
                this.err.jspError((Node)n2, "jsp.error.tag.conflict.trimdirectivewhitespaces", this.pageInfo.getTrimDirectiveWhitespaces(), value);
            }
            this.pageInfo.addImports(n2.getImports());
        }

        @Override
        public void visit(Node.AttributeDirective n2) throws JasperException {
        }

        @Override
        public void visit(Node.VariableDirective n2) throws JasperException {
        }

        private String comparePageEncodings(String thePageDirEnc, Node.PageDirective pageDir) throws JasperException {
            Node.Root root = pageDir.getRoot();
            String configEnc = root.getJspConfigPageEncoding();
            String pageDirEnc = thePageDirEnc.toUpperCase(Locale.ENGLISH);
            if (configEnc != null) {
                if (!(pageDirEnc.equals(configEnc = configEnc.toUpperCase(Locale.ENGLISH)) || pageDirEnc.startsWith("UTF-16") && configEnc.startsWith("UTF-16"))) {
                    this.err.jspError((Node)pageDir, "jsp.error.config_pagedir_encoding_mismatch", configEnc, pageDirEnc);
                } else {
                    return configEnc;
                }
            }
            if (root.isXmlSyntax() && root.isEncodingSpecifiedInProlog() || root.isBomPresent()) {
                String pageEnc = root.getPageEncoding().toUpperCase(Locale.ENGLISH);
                if (!(pageDirEnc.equals(pageEnc) || pageDirEnc.startsWith("UTF-16") && pageEnc.startsWith("UTF-16"))) {
                    this.err.jspError((Node)pageDir, "jsp.error.prolog_pagedir_encoding_mismatch", pageEnc, pageDirEnc);
                } else {
                    return pageEnc;
                }
            }
            return pageDirEnc;
        }

        private void compareTagEncodings(String thePageDirEnc, Node.TagDirective pageDir) throws JasperException {
            String pageEnc;
            Node.Root root = pageDir.getRoot();
            String pageDirEnc = thePageDirEnc.toUpperCase(Locale.ENGLISH);
            if ((root.isXmlSyntax() && root.isEncodingSpecifiedInProlog() || root.isBomPresent()) && !pageDirEnc.equals(pageEnc = root.getPageEncoding().toUpperCase(Locale.ENGLISH)) && (!pageDirEnc.startsWith("UTF-16") || !pageEnc.startsWith("UTF-16"))) {
                this.err.jspError((Node)pageDir, "jsp.error.prolog_pagedir_encoding_mismatch", pageEnc, pageDirEnc);
            }
        }
    }
}

