/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.sampling;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class NordsieckStepInterpolator
extends AbstractStepInterpolator {
    private static final long serialVersionUID = -7179861704951334960L;
    protected double[] stateVariation;
    private double scalingH;
    private double referenceTime;
    private double[] scaled;
    private Array2DRowRealMatrix nordsieck;

    public NordsieckStepInterpolator() {
    }

    public NordsieckStepInterpolator(NordsieckStepInterpolator interpolator) {
        super(interpolator);
        this.scalingH = interpolator.scalingH;
        this.referenceTime = interpolator.referenceTime;
        if (interpolator.scaled != null) {
            this.scaled = (double[])interpolator.scaled.clone();
        }
        if (interpolator.nordsieck != null) {
            this.nordsieck = new Array2DRowRealMatrix(interpolator.nordsieck.getDataRef(), true);
        }
        if (interpolator.stateVariation != null) {
            this.stateVariation = (double[])interpolator.stateVariation.clone();
        }
    }

    protected StepInterpolator doCopy() {
        return new NordsieckStepInterpolator(this);
    }

    public void reinitialize(double[] y, boolean forward, EquationsMapper primaryMapper, EquationsMapper[] secondaryMappers) {
        super.reinitialize(y, forward, primaryMapper, secondaryMappers);
        this.stateVariation = new double[y.length];
    }

    public void reinitialize(double time, double stepSize, double[] scaledDerivative, Array2DRowRealMatrix nordsieckVector) {
        this.referenceTime = time;
        this.scalingH = stepSize;
        this.scaled = scaledDerivative;
        this.nordsieck = nordsieckVector;
        this.setInterpolatedTime(this.getInterpolatedTime());
    }

    public void rescale(double stepSize) {
        double ratio = stepSize / this.scalingH;
        int i2 = 0;
        while (i2 < this.scaled.length) {
            int n2 = i2++;
            this.scaled[n2] = this.scaled[n2] * ratio;
        }
        double[][] nData = this.nordsieck.getDataRef();
        double power = ratio;
        for (int i3 = 0; i3 < nData.length; ++i3) {
            power *= ratio;
            double[] nDataI = nData[i3];
            int j2 = 0;
            while (j2 < nDataI.length) {
                int n3 = j2++;
                nDataI[n3] = nDataI[n3] * power;
            }
        }
        this.scalingH = stepSize;
    }

    public double[] getInterpolatedStateVariation() throws MaxCountExceededException {
        this.getInterpolatedState();
        return this.stateVariation;
    }

    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) {
        double x = this.interpolatedTime - this.referenceTime;
        double normalizedAbscissa = x / this.scalingH;
        Arrays.fill(this.stateVariation, 0.0);
        Arrays.fill(this.interpolatedDerivatives, 0.0);
        double[][] nData = this.nordsieck.getDataRef();
        for (int i2 = nData.length - 1; i2 >= 0; --i2) {
            int order = i2 + 2;
            double[] nDataI = nData[i2];
            double power = FastMath.pow(normalizedAbscissa, order);
            int j2 = 0;
            while (j2 < nDataI.length) {
                double d2 = nDataI[j2] * power;
                int n2 = j2;
                this.stateVariation[n2] = this.stateVariation[n2] + d2;
                int n3 = j2++;
                this.interpolatedDerivatives[n3] = this.interpolatedDerivatives[n3] + (double)order * d2;
            }
        }
        for (int j3 = 0; j3 < this.currentState.length; ++j3) {
            int n4 = j3;
            this.stateVariation[n4] = this.stateVariation[n4] + this.scaled[j3] * normalizedAbscissa;
            this.interpolatedState[j3] = this.currentState[j3] + this.stateVariation[j3];
            this.interpolatedDerivatives[j3] = (this.interpolatedDerivatives[j3] + this.scaled[j3] * normalizedAbscissa) / x;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int n2;
        this.writeBaseExternal(out);
        out.writeDouble(this.scalingH);
        out.writeDouble(this.referenceTime);
        int n3 = n2 = this.currentState == null ? -1 : this.currentState.length;
        if (this.scaled == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            for (int j2 = 0; j2 < n2; ++j2) {
                out.writeDouble(this.scaled[j2]);
            }
        }
        if (this.nordsieck == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.nordsieck);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasNordsieck;
        double t = this.readBaseExternal(in);
        this.scalingH = in.readDouble();
        this.referenceTime = in.readDouble();
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        boolean hasScaled = in.readBoolean();
        if (hasScaled) {
            this.scaled = new double[n2];
            for (int j2 = 0; j2 < n2; ++j2) {
                this.scaled[j2] = in.readDouble();
            }
        } else {
            this.scaled = null;
        }
        this.nordsieck = (hasNordsieck = in.readBoolean()) ? (Array2DRowRealMatrix)in.readObject() : null;
        if (hasScaled && hasNordsieck) {
            this.stateVariation = new double[n2];
            this.setInterpolatedTime(t);
        } else {
            this.stateVariation = null;
        }
    }
}

