/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricGaussIntegrator
extends GaussIntegrator {
    public SymmetricGaussIntegrator(double[] points, double[] weights) throws NonMonotonicSequenceException, DimensionMismatchException {
        super(points, weights);
    }

    public SymmetricGaussIntegrator(Pair<double[], double[]> pointsAndWeights) throws NonMonotonicSequenceException {
        this(pointsAndWeights.getFirst(), pointsAndWeights.getSecond());
    }

    @Override
    public double integrate(UnivariateFunction f2) {
        int ruleLength = this.getNumberOfPoints();
        if (ruleLength == 1) {
            return this.getWeight(0) * f2.value(0.0);
        }
        int iMax = ruleLength / 2;
        double s2 = 0.0;
        double c2 = 0.0;
        for (int i2 = 0; i2 < iMax; ++i2) {
            double p2 = this.getPoint(i2);
            double w = this.getWeight(i2);
            double f1 = f2.value(p2);
            double f22 = f2.value(-p2);
            double y = w * (f1 + f22) - c2;
            double t = s2 + y;
            c2 = t - s2 - y;
            s2 = t;
        }
        if (ruleLength % 2 != 0) {
            double t;
            double w = this.getWeight(iMax);
            double y = w * f2.value(0.0) - c2;
            s2 = t = s2 + y;
        }
        return s2;
    }
}

