/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog(ThreadPoolManager.class);
    private static boolean useBoundary_DEFAULT = true;
    private static int boundarySize_DEFAULT = 2000;
    private static int maximumPoolSize_DEFAULT = 150;
    private static int minimumPoolSize_DEFAULT = 4;
    private static int keepAliveTime_DEFAULT = 300000;
    private static PoolConfiguration.WhenBlockedPolicy whenBlockedPolicy_DEFAULT = PoolConfiguration.WhenBlockedPolicy.RUN;
    private static int startUpSize_DEFAULT = 4;
    private static PoolConfiguration defaultConfig;
    private static final String PROP_NAME_ROOT = "thread_pool";
    private static final String DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
    private static volatile Properties props;
    private static ThreadPoolManager INSTANCE;
    private ConcurrentHashMap<String, ThreadPoolExecutor> pools = new ConcurrentHashMap();

    private ThreadPoolManager() {
        ThreadPoolManager.configure();
    }

    private ThreadPoolExecutor createPool(PoolConfiguration config) {
        LinkedBlockingQueue<Runnable> queue = null;
        if (config.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug("Creating a Bounded Buffer to use for the pool");
            }
            queue = new LinkedBlockingQueue(config.getBoundarySize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Creating a non bounded Linked Queue to use for the pool");
            }
            queue = new LinkedBlockingQueue<Runnable>();
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(config.getStartUpSize(), config.getMaximumPoolSize(), (long)config.getKeepAliveTime(), TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory("JCS-ThreadPoolManager-"));
        switch (config.getWhenBlockedPolicy()) {
            case ABORT: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        pool.prestartAllCoreThreads();
        return pool;
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            for (String poolName : INSTANCE.getPoolNames()) {
                try {
                    INSTANCE.getPool(poolName).shutdownNow();
                }
                catch (Throwable t) {
                    log.warn("Failed to close pool " + poolName, t);
                }
            }
            INSTANCE = null;
        }
    }

    public ThreadPoolExecutor getPool(String name) {
        ThreadPoolExecutor pool = this.pools.get(name);
        if (pool == null) {
            PoolConfiguration config;
            ThreadPoolExecutor _pool;
            if (log.isDebugEnabled()) {
                log.debug("Creating pool for name [" + name + "]");
            }
            if ((_pool = this.pools.putIfAbsent(name, pool = this.createPool(config = ThreadPoolManager.loadConfig("thread_pool." + name)))) != null) {
                pool = _pool;
            }
            if (log.isDebugEnabled()) {
                log.debug("PoolName = " + this.getPoolNames());
            }
        }
        return pool;
    }

    public ArrayList<String> getPoolNames() {
        return new ArrayList<String>(this.pools.keySet());
    }

    public static void setProps(Properties props) {
        ThreadPoolManager.props = props;
    }

    private static void configure() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing ThreadPoolManager");
        }
        if (props == null) {
            log.warn("No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        defaultConfig = new PoolConfiguration(useBoundary_DEFAULT, boundarySize_DEFAULT, maximumPoolSize_DEFAULT, minimumPoolSize_DEFAULT, keepAliveTime_DEFAULT, whenBlockedPolicy_DEFAULT, startUpSize_DEFAULT);
        defaultConfig = ThreadPoolManager.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    private static PoolConfiguration loadConfig(String root) {
        PoolConfiguration config = defaultConfig.clone();
        try {
            config.setUseBoundary(Boolean.parseBoolean(props.getProperty(root + ".useBoundary", "false")));
        }
        catch (NumberFormatException nfe) {
            log.error("useBoundary not a boolean.", nfe);
        }
        try {
            config.setBoundarySize(Integer.parseInt(props.getProperty(root + ".boundarySize", "2000")));
        }
        catch (NumberFormatException nfe) {
            log.error("boundarySize not a number.", nfe);
        }
        try {
            config.setMaximumPoolSize(Integer.parseInt(props.getProperty(root + ".maximumPoolSize", "150")));
        }
        catch (NumberFormatException nfe) {
            log.error("maximumPoolSize not a number.", nfe);
        }
        try {
            config.setMinimumPoolSize(Integer.parseInt(props.getProperty(root + ".minimumPoolSize", "4")));
        }
        catch (NumberFormatException nfe) {
            log.error("minimumPoolSize not a number.", nfe);
        }
        try {
            config.setKeepAliveTime(Integer.parseInt(props.getProperty(root + ".keepAliveTime", "300000")));
        }
        catch (NumberFormatException nfe) {
            log.error("keepAliveTime not a number.", nfe);
        }
        config.setWhenBlockedPolicy(props.getProperty(root + ".whenBlockedPolicy", "RUN"));
        try {
            config.setStartUpSize(Integer.parseInt(props.getProperty(root + ".startUpSize", "4")));
        }
        catch (NumberFormatException nfe) {
            log.error("startUpSize not a number.", nfe);
        }
        if (log.isInfoEnabled()) {
            log.info(root + " PoolConfiguration = " + config);
        }
        return config;
    }

    static {
        props = null;
        INSTANCE = null;
    }
}

