/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;

public class CompositeCacheAttributes
implements ICompositeCacheAttributes {
    private static final long serialVersionUID = 6754049978134196787L;
    private static final boolean DEFAULT_USE_LATERAL = true;
    private static final boolean DEFAULT_USE_REMOTE = true;
    private static final boolean DEFAULT_USE_DISK = true;
    private static final boolean DEFAULT_USE_SHRINKER = false;
    private static final int DEFAULT_MAX_OBJECTS = 100;
    private static final int DEFAULT_MAX_MEMORY_IDLE_TIME_SECONDS = 7200;
    private static final int DEFAULT_SHRINKER_INTERVAL_SECONDS = 30;
    private static final int DEFAULT_MAX_SPOOL_PER_RUN = -1;
    private static final String DEFAULT_MEMORY_CACHE_NAME = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
    private static final int DEFAULT_CHUNK_SIZE = 2;
    private boolean useLateral = true;
    private boolean useRemote = true;
    private boolean useDisk = true;
    private boolean useMemoryShrinker = false;
    private int maxObjs = 100;
    private long maxMemoryIdleTimeSeconds = 7200L;
    private long shrinkerIntervalSeconds = 30L;
    private int maxSpoolPerRun = -1;
    private String cacheName;
    private String memoryCacheName = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
    private ICompositeCacheAttributes.DiskUsagePattern diskUsagePattern = ICompositeCacheAttributes.DiskUsagePattern.SWAP;
    private int spoolChunkSize = 2;

    @Override
    public void setMaxObjects(int maxObjs) {
        this.maxObjs = maxObjs;
    }

    @Override
    public int getMaxObjects() {
        return this.maxObjs;
    }

    @Override
    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    @Override
    public boolean isUseDisk() {
        return this.useDisk;
    }

    @Override
    public void setUseLateral(boolean b2) {
        this.useLateral = b2;
    }

    @Override
    public boolean isUseLateral() {
        return this.useLateral;
    }

    @Override
    public void setUseRemote(boolean useRemote) {
        this.useRemote = useRemote;
    }

    @Override
    public boolean isUseRemote() {
        return this.useRemote;
    }

    @Override
    public void setCacheName(String s2) {
        this.cacheName = s2;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void setMemoryCacheName(String s2) {
        this.memoryCacheName = s2;
    }

    @Override
    public String getMemoryCacheName() {
        return this.memoryCacheName;
    }

    @Override
    public void setUseMemoryShrinker(boolean useShrinker) {
        this.useMemoryShrinker = useShrinker;
    }

    @Override
    public boolean isUseMemoryShrinker() {
        return this.useMemoryShrinker;
    }

    @Override
    public void setMaxMemoryIdleTimeSeconds(long seconds) {
        this.maxMemoryIdleTimeSeconds = seconds;
    }

    @Override
    public long getMaxMemoryIdleTimeSeconds() {
        return this.maxMemoryIdleTimeSeconds;
    }

    @Override
    public void setShrinkerIntervalSeconds(long seconds) {
        this.shrinkerIntervalSeconds = seconds;
    }

    @Override
    public long getShrinkerIntervalSeconds() {
        return this.shrinkerIntervalSeconds;
    }

    @Override
    public void setMaxSpoolPerRun(int maxSpoolPerRun) {
        this.maxSpoolPerRun = maxSpoolPerRun;
    }

    @Override
    public int getMaxSpoolPerRun() {
        return this.maxSpoolPerRun;
    }

    @Override
    public void setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern diskUsagePattern) {
        this.diskUsagePattern = diskUsagePattern;
    }

    @Override
    public void setDiskUsagePatternName(String diskUsagePatternName) {
        if (diskUsagePatternName != null) {
            String name = diskUsagePatternName.toUpperCase().trim();
            if (name.startsWith("SWAP")) {
                this.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.SWAP);
            } else if (name.startsWith("UPDATE")) {
                this.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
            }
        }
    }

    @Override
    public int getSpoolChunkSize() {
        return this.spoolChunkSize;
    }

    @Override
    public void setSpoolChunkSize(int spoolChunkSize) {
        this.spoolChunkSize = spoolChunkSize;
    }

    @Override
    public ICompositeCacheAttributes.DiskUsagePattern getDiskUsagePattern() {
        return this.diskUsagePattern;
    }

    public String toString() {
        StringBuilder dump = new StringBuilder();
        dump.append("[ ");
        dump.append("useLateral = ").append(this.useLateral);
        dump.append(", useRemote = ").append(this.useRemote);
        dump.append(", useDisk = ").append(this.useDisk);
        dump.append(", maxObjs = ").append(this.maxObjs);
        dump.append(", maxSpoolPerRun = ").append(this.maxSpoolPerRun);
        dump.append(", diskUsagePattern = ").append((Object)this.diskUsagePattern);
        dump.append(", spoolChunkSize = ").append(this.spoolChunkSize);
        dump.append(" ]");
        return dump.toString();
    }

    @Override
    public ICompositeCacheAttributes clone() {
        try {
            return (ICompositeCacheAttributes)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException("Clone not supported. This should never happen.", e2);
        }
    }
}

