/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShrinkerThread
implements Runnable {
    private static final Log log = LogFactory.getLog(ShrinkerThread.class);
    private final Set<JDBCDiskCache<?, ?>> shrinkSet = Collections.synchronizedSet(new HashSet());
    private static final long DEFAULT_PAUSE_BETWEEN_REGION_CALLS_MILLIS = 5000L;
    private long pauseBetweenRegionCallsMillis = 5000L;

    protected ShrinkerThread() {
    }

    public void addDiskCacheToShrinkList(JDBCDiskCache<?, ?> diskCache) {
        this.shrinkSet.add(diskCache);
    }

    @Override
    public void run() {
        try {
            this.deleteExpiredFromAllRegisteredRegions();
        }
        catch (Throwable e2) {
            log.error("Caught an expcetion while trying to delete expired items.", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExpiredFromAllRegisteredRegions() {
        if (log.isInfoEnabled()) {
            log.info("Running JDBC disk cache shrinker.  Number of regions [" + this.shrinkSet.size() + "]");
        }
        Object[] caches = null;
        Set<JDBCDiskCache<?, ?>> set = this.shrinkSet;
        synchronized (set) {
            caches = this.shrinkSet.toArray();
        }
        if (caches != null) {
            for (int i2 = 0; i2 < caches.length; ++i2) {
                JDBCDiskCache cache = (JDBCDiskCache)caches[i2];
                long start = System.currentTimeMillis();
                int deleted = cache.deleteExpired();
                long end = System.currentTimeMillis();
                if (log.isInfoEnabled()) {
                    log.info("Deleted [" + deleted + "] expired for region [" + cache.getCacheName() + "] for table [" + cache.getTableName() + "] in " + (end - start) + " ms.");
                }
                if (i2 >= caches.length - 1) continue;
                if (log.isInfoEnabled()) {
                    log.info("Pausing for [" + this.getPauseBetweenRegionCallsMillis() + "] ms. before shrinking the next region.");
                }
                try {
                    Thread.sleep(this.getPauseBetweenRegionCallsMillis());
                    continue;
                }
                catch (InterruptedException e2) {
                    log.warn("Interrupted while waiting to delete expired for the next region.");
                }
            }
        }
    }

    public void setPauseBetweenRegionCallsMillis(long pauseBetweenRegionCallsMillis) {
        this.pauseBetweenRegionCallsMillis = pauseBetweenRegionCallsMillis;
    }

    public long getPauseBetweenRegionCallsMillis() {
        return this.pauseBetweenRegionCallsMillis;
    }
}

