/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.ConfigurationException;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.utils.props.AbstractPropertyContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartitionedCacheAccess<K, V>
extends AbstractPropertyContainer
implements ICacheAccess<K, V> {
    private static final Log log = LogFactory.getLog(PartitionedCacheAccess.class);
    private int numberOfPartitions = 1;
    private String partitionRegionNamePrefix;
    private ICacheAccess<K, V>[] partitions;
    private boolean initialized = false;

    public PartitionedCacheAccess() {
        this.setPropertiesHeading("PartitionedCacheAccess");
        this.setPropertiesGroup("cache");
    }

    @Override
    public void put(K key, V object) throws CacheException {
        if (key == null || object == null) {
            log.warn("Bad input key [" + key + "].  Cannot put null into the cache.");
            return;
        }
        if (!this.ensureInit()) {
            return;
        }
        int partition = this.getPartitionNumberForKey(key);
        try {
            this.partitions[partition].put(key, object);
        }
        catch (CacheException e2) {
            log.error("Problem putting value for key [" + key + "] in cache [" + this.partitions[partition] + "]");
            throw e2;
        }
    }

    @Override
    public void putSafe(K key, V object) throws CacheException {
        if (key == null || object == null) {
            log.warn("Bad input key [" + key + "].  Cannot putSafe null into the cache.");
        }
        if (!this.ensureInit()) {
            return;
        }
        int partition = this.getPartitionNumberForKey(key);
        this.partitions[partition].putSafe(key, object);
    }

    @Override
    public void put(K key, V object, IElementAttributes attr) throws CacheException {
        if (key == null || object == null) {
            log.warn("Bad input key [" + key + "].  Cannot put null into the cache.");
            return;
        }
        if (!this.ensureInit()) {
            return;
        }
        int partition = this.getPartitionNumberForKey(key);
        try {
            this.partitions[partition].put(key, object, attr);
        }
        catch (CacheException e2) {
            log.error("Problem putting value for key [" + key + "] in cache [" + this.partitions[partition] + "]");
            throw e2;
        }
    }

    @Override
    public V get(K key) {
        if (key == null) {
            log.warn("Input key is null.");
            return null;
        }
        if (!this.ensureInit()) {
            return null;
        }
        int partition = this.getPartitionNumberForKey(key);
        return this.partitions[partition].get(key);
    }

    @Override
    public ICacheElement<K, V> getCacheElement(K key) {
        if (key == null) {
            log.warn("Input key is null.");
            return null;
        }
        if (!this.ensureInit()) {
            return null;
        }
        int partition = this.getPartitionNumberForKey(key);
        return this.partitions[partition].getCacheElement(key);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getCacheElements(Set<K> names) {
        if (names == null) {
            log.warn("Bad input names cannot be null.");
            return Collections.emptyMap();
        }
        if (!this.ensureInit()) {
            return Collections.emptyMap();
        }
        Set[] dividedNames = new Set[this.getNumberOfPartitions()];
        for (K key : names) {
            int partition = this.getPartitionNumberForKey(key);
            if (dividedNames[partition] == null) {
                dividedNames[partition] = new HashSet();
            }
            dividedNames[partition].add(key);
        }
        HashMap<K, ICacheElement<K, V>> result = new HashMap<K, ICacheElement<K, V>>();
        for (int i2 = 0; i2 < this.partitions.length; ++i2) {
            if (dividedNames[i2] == null || dividedNames[i2].isEmpty()) continue;
            result.putAll(this.partitions[i2].getCacheElements(dividedNames[i2]));
        }
        return result;
    }

    @Override
    public Map<K, V> getMatching(String pattern) {
        if (pattern == null) {
            log.warn("Input pattern is null.");
            return null;
        }
        if (!this.ensureInit()) {
            return null;
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (ICacheAccess<K, V> partition : this.partitions) {
            result.putAll(partition.getMatching(pattern));
        }
        return result;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatchingCacheElements(String pattern) {
        if (pattern == null) {
            log.warn("Input pattern is null.");
            return null;
        }
        if (!this.ensureInit()) {
            return null;
        }
        HashMap<K, ICacheElement<K, V>> result = new HashMap<K, ICacheElement<K, V>>();
        for (ICacheAccess<K, V> partition : this.partitions) {
            result.putAll(partition.getMatchingCacheElements(pattern));
        }
        return result;
    }

    @Override
    public void remove(K key) throws CacheException {
        if (key == null) {
            log.warn("Input key is null. Cannot remove null from the cache.");
            return;
        }
        if (!this.ensureInit()) {
            return;
        }
        int partition = this.getPartitionNumberForKey(key);
        try {
            this.partitions[partition].remove(key);
        }
        catch (CacheException e2) {
            log.error("Problem removing value for key [" + key + "] in cache [" + this.partitions[partition] + "]");
            throw e2;
        }
    }

    @Override
    public int freeMemoryElements(int numberToFree) throws CacheException {
        if (!this.ensureInit()) {
            return 0;
        }
        int count = 0;
        for (ICacheAccess<K, V> partition : this.partitions) {
            count += partition.freeMemoryElements(numberToFree);
        }
        return count;
    }

    @Override
    public ICompositeCacheAttributes getCacheAttributes() {
        if (!this.ensureInit()) {
            return null;
        }
        if (this.partitions.length == 0) {
            return null;
        }
        return this.partitions[0].getCacheAttributes();
    }

    @Override
    public IElementAttributes getDefaultElementAttributes() throws CacheException {
        if (!this.ensureInit()) {
            return null;
        }
        if (this.partitions.length == 0) {
            return null;
        }
        return this.partitions[0].getDefaultElementAttributes();
    }

    @Override
    public IElementAttributes getElementAttributes(K key) throws CacheException {
        if (key == null) {
            log.warn("Input key is null. Cannot getElementAttributes for null from the cache.");
            return null;
        }
        if (!this.ensureInit()) {
            return null;
        }
        int partition = this.getPartitionNumberForKey(key);
        return this.partitions[partition].getElementAttributes(key);
    }

    @Override
    public void resetElementAttributes(K key, IElementAttributes attributes) throws CacheException {
        if (key == null) {
            log.warn("Input key is null. Cannot resetElementAttributes for null.");
            return;
        }
        if (!this.ensureInit()) {
            return;
        }
        int partition = this.getPartitionNumberForKey(key);
        this.partitions[partition].resetElementAttributes(key, attributes);
    }

    @Override
    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        if (!this.ensureInit()) {
            return;
        }
        for (ICacheAccess<K, V> partition : this.partitions) {
            partition.setCacheAttributes(cattr);
        }
    }

    @Override
    public void clear() throws CacheException {
        if (!this.ensureInit()) {
            return;
        }
        for (ICacheAccess<K, V> partition : this.partitions) {
            partition.clear();
        }
    }

    @Override
    public void setDefaultElementAttributes(IElementAttributes attr) throws CacheException {
        if (!this.ensureInit()) {
            return;
        }
        for (ICacheAccess<K, V> partition : this.partitions) {
            partition.setDefaultElementAttributes(attr);
        }
    }

    @Override
    public ICacheStats getStatistics() {
        if (!this.ensureInit()) {
            return null;
        }
        if (this.partitions.length == 0) {
            return null;
        }
        return this.partitions[0].getStatistics();
    }

    @Override
    public String getStats() {
        if (!this.ensureInit()) {
            return "";
        }
        StringBuilder stats = new StringBuilder();
        for (ICacheAccess<K, V> partition : this.partitions) {
            stats.append(partition.getStats());
            stats.append("\n");
        }
        return stats.toString();
    }

    @Override
    public synchronized void dispose() {
        if (!this.ensureInit()) {
            return;
        }
        for (ICacheAccess<K, V> partition : this.partitions) {
            partition.dispose();
        }
        this.initialized = false;
    }

    protected int getPartitionNumberForKey(K key) {
        if (key == null) {
            return 0;
        }
        long keyNum = this.getNumericValueForKey(key);
        int partition = (int)(keyNum % (long)this.getNumberOfPartitions());
        if (log.isDebugEnabled()) {
            log.debug("Using partition [" + partition + "] for key [" + key + "]");
        }
        return partition;
    }

    public long getNumericValueForKey(K key) {
        String keyString = key.toString();
        long keyNum = -1L;
        try {
            keyNum = Long.parseLong(keyString);
        }
        catch (NumberFormatException e2) {
            keyNum = key.hashCode();
            log.warn("Couldn't convert [" + key + "] into a number.  Will use hashcode [" + keyNum + "]");
        }
        return keyNum;
    }

    protected synchronized boolean ensureInit() {
        if (!this.initialized) {
            try {
                this.initialize();
            }
            catch (ConfigurationException e2) {
                log.error("Couldn't configure partioned access.", e2);
                return false;
            }
        }
        return true;
    }

    protected synchronized void initialize() throws ConfigurationException {
        this.ensureProperties();
        ICacheAccess[] tempPartitions = new ICacheAccess[this.getNumberOfPartitions()];
        for (int i2 = 0; i2 < this.getNumberOfPartitions(); ++i2) {
            String regionName = this.getPartitionRegionNamePrefix() + "_" + i2;
            try {
                tempPartitions[i2] = JCS.getInstance(regionName);
                continue;
            }
            catch (CacheException e2) {
                log.error("Problem getting cache for region [" + regionName + "]");
            }
        }
        this.partitions = tempPartitions;
        this.initialized = true;
    }

    @Override
    protected void handleProperties() throws ConfigurationException {
        String numberOfPartitionsPropertyName = this.getPropertiesHeading() + ".numberOfPartitions";
        String numberOfPartitionsPropertyValue = this.getPropertyForName(numberOfPartitionsPropertyName, true);
        try {
            this.setNumberOfPartitions(Integer.parseInt(numberOfPartitionsPropertyValue));
        }
        catch (NumberFormatException e2) {
            String message = "Could not convert [" + numberOfPartitionsPropertyValue + "] into a number for [" + numberOfPartitionsPropertyName + "]";
            log.error(message);
            throw new ConfigurationException(message);
        }
        String prefixPropertyName = this.getPropertiesHeading() + ".partitionRegionNamePrefix";
        String prefix = this.getPropertyForName(prefixPropertyName, true);
        this.setPartitionRegionNamePrefix(prefix);
    }

    protected String getPropertyForName(String propertyName, boolean required) throws ConfigurationException {
        String propertyValue = null;
        propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            if (log.isInfoEnabled()) {
                log.info("Found system property override: Name [" + propertyName + "] Value [" + propertyValue + "]");
            }
        } else {
            propertyValue = this.getProperties().getProperty(propertyName);
            if (required && propertyValue == null) {
                String message = "Could not find required property [" + propertyName + "] in propertiesGroup [" + this.getPropertiesGroup() + "]";
                log.error(message);
                throw new ConfigurationException(message);
            }
            if (log.isInfoEnabled()) {
                log.info("Name [" + propertyName + "] Value [" + propertyValue + "]");
            }
        }
        return propertyValue;
    }

    protected void setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }

    protected int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    protected void setPartitionRegionNamePrefix(String partitionRegionNamePrefix) {
        this.partitionRegionNamePrefix = partitionRegionNamePrefix;
    }

    protected String getPartitionRegionNamePrefix() {
        return this.partitionRegionNamePrefix;
    }

    protected void setPartitions(ICacheAccess<K, V>[] partitions) {
        this.partitions = partitions;
    }

    protected ICacheAccess<K, V>[] getPartitions() {
        return this.partitions;
    }
}

