/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static final String PRINTWRITER_ENCODING = "UTF8";
    @Deprecated
    protected final PrintWriter out;
    @Deprecated
    protected final boolean canonical;

    public DOMWriter(Writer writer) {
        this(writer, true);
    }

    @Deprecated
    public DOMWriter(Writer writer, boolean canonical) {
        this.out = new PrintWriter(writer);
        this.canonical = canonical;
    }

    @Deprecated
    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                Attr[] attrs;
                this.out.print('<');
                this.out.print(node.getLocalName());
                for (Attr attr : attrs = this.sortAttributes(node.getAttributes())) {
                    this.out.print(' ');
                    this.out.print(attr.getLocalName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                this.printChildren(node);
                break;
            }
            case 5: {
                if (this.canonical) {
                    this.printChildren(node);
                    break;
                }
                this.out.print('&');
                this.out.print(node.getLocalName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getLocalName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getLocalName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private void printChildren(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i2 = 0; i2 < len; ++i2) {
                this.print(children.item(i2));
            }
        }
    }

    @Deprecated
    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int i2;
        if (attrs == null) {
            return new Attr[0];
        }
        int len = attrs.getLength();
        Attr[] array = new Attr[len];
        for (i2 = 0; i2 < len; ++i2) {
            array[i2] = (Attr)attrs.item(i2);
        }
        for (i2 = 0; i2 < len - 1; ++i2) {
            String name = null;
            name = array[i2].getLocalName();
            int index = i2;
            for (int j2 = i2 + 1; j2 < len; ++j2) {
                String curName = null;
                curName = array[j2].getLocalName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j2;
            }
            if (index == i2) continue;
            Attr temp = array[i2];
            array[i2] = array[index];
            array[index] = temp;
        }
        return array;
    }

    @Deprecated
    protected String normalize(String s2) {
        if (s2 == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        int len = s2.length();
        block7: for (int i2 = 0; i2 < len; ++i2) {
            char ch = s2.charAt(i2);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        continue block7;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

