/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.common.Logger;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;
import jxl.read.biff.Record;

public class File {
    private static Logger logger = Logger.getLogger(File.class);
    private byte[] data;
    private int filePos;
    private int oldPos;
    private int initialFileSize;
    private int arrayGrowSize;
    private CompoundFile compoundFile;
    private WorkbookSettings workbookSettings;

    public File(InputStream is, WorkbookSettings ws) throws IOException, BiffException {
        int bytesRead;
        this.workbookSettings = ws;
        this.initialFileSize = this.workbookSettings.getInitialFileSize();
        this.arrayGrowSize = this.workbookSettings.getArrayGrowSize();
        byte[] d2 = new byte[this.initialFileSize];
        int pos = bytesRead = is.read(d2);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException();
        }
        while (bytesRead != -1) {
            if (pos >= d2.length) {
                byte[] newArray = new byte[d2.length + this.arrayGrowSize];
                System.arraycopy(d2, 0, newArray, 0, d2.length);
                d2 = newArray;
            }
            bytesRead = is.read(d2, pos, d2.length - pos);
            pos += bytesRead;
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException();
        }
        bytesRead = pos + 1;
        if (bytesRead == 0) {
            throw new BiffException(BiffException.excelFileNotFound);
        }
        CompoundFile cf = new CompoundFile(d2, ws);
        try {
            this.data = cf.getStream("workbook");
        }
        catch (BiffException e2) {
            this.data = cf.getStream("book");
        }
        if (!this.workbookSettings.getPropertySetsDisabled() && cf.getNumberOfPropertySets() > BaseCompoundFile.STANDARD_PROPERTY_SETS.length) {
            this.compoundFile = cf;
        }
        cf = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public File(byte[] d2) {
        this.data = d2;
    }

    Record next() {
        Record r2 = new Record(this.data, this.filePos, this);
        return r2;
    }

    Record peek() {
        int tempPos = this.filePos;
        Record r2 = new Record(this.data, this.filePos, this);
        this.filePos = tempPos;
        return r2;
    }

    public void skip(int bytes) {
        this.filePos += bytes;
    }

    public byte[] read(int pos, int length) {
        byte[] ret = new byte[length];
        try {
            System.arraycopy(this.data, pos, ret, 0, length);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            logger.error("Array index out of bounds at position " + pos + " record length " + length);
            throw e2;
        }
        return ret;
    }

    public int getPos() {
        return this.filePos;
    }

    public void setPos(int p2) {
        this.oldPos = this.filePos;
        this.filePos = p2;
    }

    public void restorePos() {
        this.filePos = this.oldPos;
    }

    private void moveToFirstBof() {
        boolean bofFound = false;
        while (!bofFound) {
            int code = IntegerHelper.getInt(this.data[this.filePos], this.data[this.filePos + 1]);
            if (code == Type.BOF.value) {
                bofFound = true;
                continue;
            }
            this.skip(128);
        }
    }

    public void close() {
    }

    public void clear() {
        this.data = null;
    }

    public boolean hasNext() {
        return this.filePos < this.data.length - 4;
    }

    CompoundFile getCompoundFile() {
        return this.compoundFile;
    }
}

