/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.biff.formula.ParseContext;
import jxl.common.Logger;

abstract class ParseItem {
    private static Logger logger = Logger.getLogger(ParseItem.class);
    private ParseItem parent;
    private boolean volatileFunction = false;
    private boolean alternateCode = false;
    private ParseContext parseContext = ParseContext.DEFAULT;
    private boolean valid = true;

    protected void setParent(ParseItem p2) {
        this.parent = p2;
    }

    protected void setVolatile() {
        this.volatileFunction = true;
        if (this.parent != null && !this.parent.isVolatile()) {
            this.parent.setVolatile();
        }
    }

    protected final void setInvalid() {
        this.valid = false;
        if (this.parent != null) {
            this.parent.setInvalid();
        }
    }

    final boolean isVolatile() {
        return this.volatileFunction;
    }

    final boolean isValid() {
        return this.valid;
    }

    abstract void getString(StringBuffer var1);

    abstract byte[] getBytes();

    abstract void adjustRelativeCellReferences(int var1, int var2);

    abstract void columnInserted(int var1, int var2, boolean var3);

    abstract void columnRemoved(int var1, int var2, boolean var3);

    abstract void rowInserted(int var1, int var2, boolean var3);

    abstract void rowRemoved(int var1, int var2, boolean var3);

    abstract void handleImportedCellReferences();

    protected void setAlternateCode() {
        this.alternateCode = true;
    }

    protected final boolean useAlternateCode() {
        return this.alternateCode;
    }

    protected void setParseContext(ParseContext pc) {
        this.parseContext = pc;
    }

    protected final ParseContext getParseContext() {
        return this.parseContext;
    }
}

