/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;

class NoBodyOutputStream
extends ServletOutputStream {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    private final HttpServletResponse response;
    private boolean flushed = false;
    private int contentLength = 0;

    NoBodyOutputStream(HttpServletResponse response) {
        this.response = response;
    }

    int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void write(int b2) throws IOException {
        ++this.contentLength;
        this.checkCommit();
    }

    @Override
    public void write(byte[] buf, int offset, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException(lStrings.getString("err.io.nullArray"));
        }
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            String msg = lStrings.getString("err.io.indexOutOfBounds");
            Object[] msgArgs = new Object[]{offset, len, buf.length};
            msg = MessageFormat.format(msg, msgArgs);
            throw new IndexOutOfBoundsException(msg);
        }
        this.contentLength += len;
        this.checkCommit();
    }

    @Override
    public boolean isReady() {
        return false;
    }

    @Override
    public void setWriteListener(WriteListener listener) {
    }

    private void checkCommit() throws IOException {
        if (!this.flushed && this.contentLength > this.response.getBufferSize()) {
            this.response.flushBuffer();
            this.flushed = true;
        }
    }
}

