/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.Response;
import com.sun.mail.pop3.Status;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.MailLogger;
import com.sun.mail.util.PropUtil;
import com.sun.mail.util.SharedByteArrayOutputStream;
import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;

class Protocol {
    private Socket socket;
    private String host;
    private Properties props;
    private String prefix;
    private DataInputStream input;
    private PrintWriter output;
    private TraceInputStream traceInput;
    private TraceOutputStream traceOutput;
    private MailLogger logger;
    private MailLogger traceLogger;
    private String apopChallenge = null;
    private Map capabilities = null;
    private boolean pipelining;
    private boolean noauthdebug = true;
    private boolean traceSuspended;
    private static final int POP3_PORT = 110;
    private static final String CRLF = "\r\n";
    private static final int SLOP = 128;
    private static char[] digits;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Protocol(String host, int port, MailLogger logger, Properties props, String prefix, boolean isSSL) throws IOException {
        Response r2;
        this.host = host;
        this.props = props;
        this.prefix = prefix;
        this.logger = logger;
        this.traceLogger = logger.getSubLogger("protocol", null);
        this.noauthdebug = !PropUtil.getBooleanProperty(props, "mail.debug.auth", false);
        boolean enableAPOP = this.getBoolProp(props, prefix + ".apop.enable");
        boolean disableCapa = this.getBoolProp(props, prefix + ".disablecapa");
        try {
            if (port == -1) {
                port = 110;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("connecting to host \"" + host + "\", port " + port + ", isSSL " + isSSL);
            }
            this.socket = SocketFetcher.getSocket(host, port, props, prefix, isSSL);
            this.initStreams();
            r2 = this.simpleCommand(null);
        }
        catch (IOException ioe) {
            try {
                this.socket.close();
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                throw ioe;
            }
            throw ioe;
        }
        if (!r2.ok) {
            try {
                this.socket.close();
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                throw new IOException("Connect failed");
            }
            throw new IOException("Connect failed");
        }
        if (enableAPOP) {
            int challStart = r2.data.indexOf(60);
            int challEnd = r2.data.indexOf(62, challStart);
            if (challStart != -1 && challEnd != -1) {
                this.apopChallenge = r2.data.substring(challStart, challEnd + 1);
            }
            logger.log(Level.FINE, "APOP challenge: {0}", this.apopChallenge);
        }
        if (!disableCapa) {
            this.setCapabilities(this.capa());
        }
        boolean bl = this.pipelining = this.hasCapability("PIPELINING") || PropUtil.getBooleanProperty(props, prefix + ".pipelining", false);
        if (this.pipelining) {
            logger.config("PIPELINING enabled");
        }
    }

    private final synchronized boolean getBoolProp(Properties props, String prop) {
        boolean val = PropUtil.getBooleanProperty(props, prop, false);
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config(prop + ": " + val);
        }
        return val;
    }

    private void initStreams() throws IOException {
        boolean quote = PropUtil.getBooleanProperty(this.props, "mail.debug.quote", false);
        this.traceInput = new TraceInputStream(this.socket.getInputStream(), this.traceLogger);
        this.traceInput.setQuote(quote);
        this.traceOutput = new TraceOutputStream(this.socket.getOutputStream(), this.traceLogger);
        this.traceOutput.setQuote(quote);
        this.input = new DataInputStream(new BufferedInputStream(this.traceInput));
        this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.traceOutput, "iso-8859-1")));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            this.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    synchronized void setCapabilities(InputStream in) {
        block14: {
            String s2;
            BufferedReader r2;
            block13: {
                if (in == null) {
                    this.capabilities = null;
                    return;
                }
                this.capabilities = new HashMap(10);
                r2 = null;
                try {
                    r2 = new BufferedReader(new InputStreamReader(in, "us-ascii"));
                }
                catch (UnsupportedEncodingException ex) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            while ((s2 = r2.readLine()) != null) {
                String cap = s2;
                int i2 = cap.indexOf(32);
                if (i2 > 0) {
                    cap = cap.substring(0, i2);
                }
                this.capabilities.put(cap.toUpperCase(Locale.ENGLISH), s2);
            }
            Object var7_8 = null;
            try {
                in.close();
            }
            catch (IOException ex2) {}
            break block14;
            {
                catch (IOException ex) {
                    Object var7_9 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    in.close();
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    synchronized boolean hasCapability(String c2) {
        return this.capabilities != null && this.capabilities.containsKey(c2.toUpperCase(Locale.ENGLISH));
    }

    synchronized Map getCapabilities() {
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized String login(String user, String password) throws IOException {
        String string;
        block14: {
            block13: {
                String string2;
                block12: {
                    boolean batch = this.pipelining && this.socket instanceof SSLSocket;
                    try {
                        Response r2;
                        if (this.noauthdebug && this.isTracing()) {
                            this.logger.fine("authentication command trace suppressed");
                            this.suspendTracing();
                        }
                        String dpw = null;
                        if (this.apopChallenge != null) {
                            dpw = this.getDigest(password);
                        }
                        if (this.apopChallenge != null && dpw != null) {
                            r2 = this.simpleCommand("APOP " + user + " " + dpw);
                        } else if (batch) {
                            String cmd = "USER " + user;
                            this.batchCommandStart(cmd);
                            this.issueCommand(cmd);
                            cmd = "PASS " + password;
                            this.batchCommandContinue(cmd);
                            this.issueCommand(cmd);
                            r2 = this.readResponse();
                            if (!r2.ok) {
                                String err = r2.data != null ? r2.data : "USER command failed";
                                r2 = this.readResponse();
                                this.batchCommandEnd();
                                String string3 = err;
                                Object var10_10 = null;
                                this.resumeTracing();
                                return string3;
                            }
                            r2 = this.readResponse();
                            this.batchCommandEnd();
                        } else {
                            r2 = this.simpleCommand("USER " + user);
                            if (!r2.ok) {
                                string2 = r2.data != null ? r2.data : "USER command failed";
                                break block12;
                            }
                            r2 = this.simpleCommand("PASS " + password);
                        }
                        if (this.noauthdebug && this.isTracing()) {
                            this.logger.log(Level.FINE, "authentication command {0}", r2.ok ? "succeeded" : "failed");
                        }
                        if (!r2.ok) {
                            string = r2.data != null ? r2.data : "login failed";
                            break block13;
                        }
                        string = null;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        this.resumeTracing();
                        throw throwable;
                    }
                }
                Object var10_11 = null;
                this.resumeTracing();
                return string2;
            }
            Object var10_12 = null;
            this.resumeTracing();
            return string;
        }
        Object var10_13 = null;
        this.resumeTracing();
        return string;
    }

    private String getDigest(String password) {
        byte[] digest;
        String key = this.apopChallenge + password;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            digest = md.digest(key.getBytes("iso-8859-1"));
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        return Protocol.toHex(digest);
    }

    private static String toHex(byte[] bytes) {
        char[] result = new char[bytes.length * 2];
        int i2 = 0;
        for (int index = 0; index < bytes.length; ++index) {
            int temp = bytes[index] & 0xFF;
            result[i2++] = digits[temp >> 4];
            result[i2++] = digits[temp & 0xF];
        }
        return new String(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean quit() throws IOException {
        Object v1;
        boolean ok;
        block5: {
            ok = false;
            try {
                Response r2 = this.simpleCommand("QUIT");
                ok = r2.ok;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                try {
                    this.socket.close();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var6_8 = v0;
                this.socket = null;
                this.input = null;
                this.output = null;
                throw throwable;
            }
            try {
                this.socket.close();
                v1 = null;
                break block5;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var6_7 = v1;
        this.socket = null;
        this.input = null;
        this.output = null;
        return ok;
    }

    synchronized Status stat() throws IOException {
        Response r2 = this.simpleCommand("STAT");
        Status s2 = new Status();
        if (!r2.ok) {
            throw new IOException("STAT command failed: " + r2.data);
        }
        if (r2.data != null) {
            try {
                StringTokenizer st = new StringTokenizer(r2.data);
                s2.total = Integer.parseInt(st.nextToken());
                s2.size = Integer.parseInt(st.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s2;
    }

    synchronized int list(int msg) throws IOException {
        Response r2 = this.simpleCommand("LIST " + msg);
        int size = -1;
        if (r2.ok && r2.data != null) {
            try {
                StringTokenizer st = new StringTokenizer(r2.data);
                st.nextToken();
                size = Integer.parseInt(st.nextToken());
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return size;
    }

    synchronized InputStream list() throws IOException {
        Response r2 = this.multilineCommand("LIST", 128);
        return r2.bytes;
    }

    synchronized InputStream retr(int msg, int size) throws IOException {
        Response r2;
        boolean batch;
        boolean bl = batch = size == 0 && this.pipelining;
        if (batch) {
            String cmd = "LIST " + msg;
            this.batchCommandStart(cmd);
            this.issueCommand(cmd);
            cmd = "RETR " + msg;
            this.batchCommandContinue(cmd);
            this.issueCommand(cmd);
            r2 = this.readResponse();
            if (r2.ok && r2.data != null) {
                try {
                    StringTokenizer st = new StringTokenizer(r2.data);
                    st.nextToken();
                    size = Integer.parseInt(st.nextToken());
                    if (size > 0x40000000 || size < 0) {
                        size = 0;
                    } else {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("pipeline message size " + size);
                        }
                        size += 128;
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            r2 = this.readResponse();
            if (r2.ok) {
                r2.bytes = this.readMultilineResponse(size + 128);
            }
            this.batchCommandEnd();
        } else {
            String cmd = "RETR " + msg;
            this.multilineCommandStart(cmd);
            this.issueCommand(cmd);
            r2 = this.readResponse();
            if (!r2.ok) {
                this.multilineCommandEnd();
                return null;
            }
            if (size <= 0 && r2.data != null) {
                try {
                    StringTokenizer st = new StringTokenizer(r2.data);
                    String s2 = st.nextToken();
                    String octets = st.nextToken();
                    if (octets.equals("octets")) {
                        size = Integer.parseInt(s2);
                        if (size > 0x40000000 || size < 0) {
                            size = 0;
                        } else {
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.fine("guessing message size: " + size);
                            }
                            size += 128;
                        }
                    }
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            r2.bytes = this.readMultilineResponse(size);
            this.multilineCommandEnd();
        }
        if (r2.ok && size > 0 && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("got message size " + r2.bytes.available());
        }
        return r2.bytes;
    }

    synchronized boolean retr(int msg, OutputStream os) throws IOException {
        int b2;
        String cmd = "RETR " + msg;
        this.multilineCommandStart(cmd);
        this.issueCommand(cmd);
        Response r2 = this.readResponse();
        if (!r2.ok) {
            this.multilineCommandEnd();
            return false;
        }
        Exception terr = null;
        int lastb = 10;
        try {
            while ((b2 = this.input.read()) >= 0) {
                if (lastb == 10 && b2 == 46 && (b2 = this.input.read()) == 13) {
                    b2 = this.input.read();
                    break;
                }
                if (terr == null) {
                    try {
                        os.write(b2);
                    }
                    catch (IOException ex) {
                        this.logger.log(Level.FINE, "exception while streaming", ex);
                        terr = ex;
                    }
                    catch (RuntimeException ex) {
                        this.logger.log(Level.FINE, "exception while streaming", ex);
                        terr = ex;
                    }
                }
                lastb = b2;
            }
        }
        catch (InterruptedIOException iioex) {
            try {
                this.socket.close();
            }
            catch (IOException cex) {
                // empty catch block
            }
            throw iioex;
        }
        if (b2 < 0) {
            throw new EOFException("EOF on socket");
        }
        if (terr != null) {
            if (terr instanceof IOException) {
                throw (IOException)terr;
            }
            if (terr instanceof RuntimeException) {
                throw (RuntimeException)terr;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        this.multilineCommandEnd();
        return true;
    }

    synchronized InputStream top(int msg, int n2) throws IOException {
        Response r2 = this.multilineCommand("TOP " + msg + " " + n2, 0);
        return r2.bytes;
    }

    synchronized boolean dele(int msg) throws IOException {
        Response r2 = this.simpleCommand("DELE " + msg);
        return r2.ok;
    }

    synchronized String uidl(int msg) throws IOException {
        Response r2 = this.simpleCommand("UIDL " + msg);
        if (!r2.ok) {
            return null;
        }
        int i2 = r2.data.indexOf(32);
        if (i2 > 0) {
            return r2.data.substring(i2 + 1);
        }
        return null;
    }

    synchronized boolean uidl(String[] uids) throws IOException {
        Response r2 = this.multilineCommand("UIDL", 15 * uids.length);
        if (!r2.ok) {
            return false;
        }
        LineInputStream lis = new LineInputStream(r2.bytes);
        String line = null;
        while ((line = lis.readLine()) != null) {
            int n2;
            int i2 = line.indexOf(32);
            if (i2 < 1 || i2 >= line.length() || (n2 = Integer.parseInt(line.substring(0, i2))) <= 0 || n2 > uids.length) continue;
            uids[n2 - 1] = line.substring(i2 + 1);
        }
        try {
            r2.bytes.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return true;
    }

    synchronized boolean noop() throws IOException {
        Response r2 = this.simpleCommand("NOOP");
        return r2.ok;
    }

    synchronized boolean rset() throws IOException {
        Response r2 = this.simpleCommand("RSET");
        return r2.ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean stls() throws IOException {
        if (this.socket instanceof SSLSocket) {
            return true;
        }
        Response r2 = this.simpleCommand("STLS");
        if (r2.ok) {
            try {
                this.socket = SocketFetcher.startTLS(this.socket, this.host, this.props, this.prefix);
                this.initStreams();
            }
            catch (IOException ioex) {
                try {
                    this.socket.close();
                    Object var4_3 = null;
                    this.socket = null;
                    this.input = null;
                    this.output = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.socket = null;
                    this.input = null;
                    this.output = null;
                    throw throwable;
                }
                IOException sioex = new IOException("Could not convert socket to TLS");
                sioex.initCause(ioex);
                throw sioex;
            }
        }
        return r2.ok;
    }

    synchronized boolean isSSL() {
        return this.socket instanceof SSLSocket;
    }

    synchronized InputStream capa() throws IOException {
        Response r2 = this.multilineCommand("CAPA", 128);
        if (!r2.ok) {
            return null;
        }
        return r2.bytes;
    }

    private Response simpleCommand(String cmd) throws IOException {
        this.simpleCommandStart(cmd);
        this.issueCommand(cmd);
        Response r2 = this.readResponse();
        this.simpleCommandEnd();
        return r2;
    }

    private void issueCommand(String cmd) throws IOException {
        if (this.socket == null) {
            throw new IOException("Folder is closed");
        }
        if (cmd != null) {
            cmd = cmd + CRLF;
            this.output.print(cmd);
            this.output.flush();
        }
    }

    private Response readResponse() throws IOException {
        String line = null;
        try {
            line = this.input.readLine();
        }
        catch (InterruptedIOException iioex) {
            try {
                this.socket.close();
            }
            catch (IOException cex) {
                // empty catch block
            }
            throw new EOFException(iioex.getMessage());
        }
        catch (SocketException ex) {
            try {
                this.socket.close();
            }
            catch (IOException cex) {
                // empty catch block
            }
            throw new EOFException(ex.getMessage());
        }
        if (line == null) {
            this.traceLogger.finest("<EOF>");
            throw new EOFException("EOF on socket");
        }
        Response r2 = new Response();
        if (line.startsWith("+OK")) {
            r2.ok = true;
        } else if (line.startsWith("-ERR")) {
            r2.ok = false;
        } else {
            throw new IOException("Unexpected response: " + line);
        }
        int i2 = line.indexOf(32);
        if (i2 >= 0) {
            r2.data = line.substring(i2 + 1);
        }
        return r2;
    }

    private Response multilineCommand(String cmd, int size) throws IOException {
        this.multilineCommandStart(cmd);
        this.issueCommand(cmd);
        Response r2 = this.readResponse();
        if (!r2.ok) {
            this.multilineCommandEnd();
            return r2;
        }
        r2.bytes = this.readMultilineResponse(size);
        this.multilineCommandEnd();
        return r2;
    }

    private InputStream readMultilineResponse(int size) throws IOException {
        int b2;
        SharedByteArrayOutputStream buf = new SharedByteArrayOutputStream(size);
        int lastb = 10;
        try {
            while ((b2 = this.input.read()) >= 0) {
                if (lastb == 10 && b2 == 46 && (b2 = this.input.read()) == 13) {
                    b2 = this.input.read();
                    break;
                }
                buf.write(b2);
                lastb = b2;
            }
        }
        catch (InterruptedIOException iioex) {
            try {
                this.socket.close();
            }
            catch (IOException cex) {
                // empty catch block
            }
            throw iioex;
        }
        if (b2 < 0) {
            throw new EOFException("EOF on socket");
        }
        return buf.toStream();
    }

    protected boolean isTracing() {
        return this.traceLogger.isLoggable(Level.FINEST);
    }

    private void suspendTracing() {
        if (this.traceLogger.isLoggable(Level.FINEST)) {
            this.traceInput.setTrace(false);
            this.traceOutput.setTrace(false);
        }
    }

    private void resumeTracing() {
        if (this.traceLogger.isLoggable(Level.FINEST)) {
            this.traceInput.setTrace(true);
            this.traceOutput.setTrace(true);
        }
    }

    private void simpleCommandStart(String command) {
    }

    private void simpleCommandEnd() {
    }

    private void multilineCommandStart(String command) {
    }

    private void multilineCommandEnd() {
    }

    private void batchCommandStart(String command) {
    }

    private void batchCommandContinue(String command) {
    }

    private void batchCommandEnd() {
    }

    static {
        $assertionsDisabled = !Protocol.class.desiredAssertionStatus();
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

