/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Handouts
extends AbstractTool {
    public Handouts() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "pages", "The number of pages you want on one handout page");
        optionArgument.addOption("2 pages on 1", "2");
        optionArgument.addOption("3 pages on 1", "3");
        optionArgument.addOption("4 pages on 1", "4");
        optionArgument.addOption("5 pages on 1", "5");
        optionArgument.addOption("6 pages on 1", "6");
        optionArgument.addOption("7 pages on 1", "7");
        optionArgument.addOption("8 pages on 1", "8");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Handouts", true, true, true);
        this.internalFrame.setSize(300, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(20, 10));
    }

    public void execute() {
        try {
            int n2;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            try {
                n2 = Integer.parseInt((String)this.getValue("pages"));
            }
            catch (Exception exception) {
                n2 = 4;
            }
            float f2 = 30.0f;
            float f3 = 280.0f;
            float f4 = 320.0f;
            float f5 = 565.0f;
            float[] fArray = new float[n2];
            float[] fArray2 = new float[n2];
            float f6 = (778.0f - 20.0f * (float)(n2 - 1)) / (float)n2;
            fArray[0] = 812.0f;
            fArray2[0] = 812.0f - f6;
            for (int i2 = 1; i2 < n2; ++i2) {
                fArray[i2] = fArray2[i2 - 1] - 20.0f;
                fArray2[i2] = fArray[i2] - f6;
            }
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n3 = pdfReader.getNumberOfPages();
            System.out.println("There are " + n3 + " pages in the original file.");
            Document document = new Document(PageSize.A4);
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            int n4 = 0;
            int n5 = 0;
            while (n4 < n3) {
                float f7;
                Rectangle rectangle;
                float f8;
                float f9 = (f8 = (f3 - f2) / (rectangle = pdfReader.getPageSizeWithRotation(++n4)).width()) < (f7 = (fArray[n5] - fArray2[n5]) / rectangle.height()) ? f8 : f7;
                float f10 = f8 == f9 ? 0.0f : (f3 - f2 - rectangle.width() * f9) / 2.0f;
                float f11 = f7 == f9 ? 0.0f : (fArray[n5] - fArray2[n5] - rectangle.height() * f9) / 2.0f;
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n4);
                int n6 = pdfReader.getPageRotation(n4);
                if (n6 == 90 || n6 == 270) {
                    pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -f9, f9, 0.0f, f2 + f10, fArray2[n5] + f11 + rectangle.height() * f9);
                } else {
                    pdfContentByte.addTemplate(pdfImportedPage, f9, 0.0f, 0.0f, f9, f2 + f10, fArray2[n5] + f11);
                }
                pdfContentByte.setRGBColorStroke(192, 192, 192);
                pdfContentByte.rectangle(f4 - 5.0f, fArray2[n5] - 5.0f, f5 - f4 + 10.0f, fArray[n5] - fArray2[n5] + 10.0f);
                for (float f12 = fArray[n5] - 19.0f; f12 > fArray2[n5]; f12 -= 16.0f) {
                    pdfContentByte.moveTo(f4, f12);
                    pdfContentByte.lineTo(f5, f12);
                }
                pdfContentByte.rectangle(f2 + f10, fArray2[n5] + f11, rectangle.width() * f9, rectangle.height() * f9);
                pdfContentByte.stroke();
                System.out.println("Processed page " + n4);
                if (++n5 != n2) continue;
                n5 = 0;
                document.newPage();
            }
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Handouts handouts = new Handouts();
        if (stringArray.length < 2) {
            System.err.println(handouts.getUsage());
        }
        handouts.setArguments(stringArray);
        handouts.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

