/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfColorList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_TABLE = "\\colortbl".getBytes();
    ArrayList colorList = new ArrayList();

    public RtfColorList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.colorList.add(new RtfColor(rtfDocument, 0, 0, 0, 0));
        this.colorList.add(new RtfColor(rtfDocument, 255, 255, 255, 1));
    }

    public int getColorNumber(RtfColor rtfColor) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.colorList.size(); ++i2) {
            if (!this.colorList.get(i2).equals(rtfColor)) continue;
            n2 = i2;
        }
        if (n2 == -1) {
            n2 = this.colorList.size();
            this.colorList.add(rtfColor);
        }
        return n2;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            byteArrayOutputStream.write(COLOR_TABLE);
            for (int i2 = 0; i2 < this.colorList.size(); ++i2) {
                RtfColor rtfColor = (RtfColor)this.colorList.get(i2);
                byteArrayOutputStream.write(rtfColor.writeDefinition());
            }
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

