/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfColor
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_RED = "\\red".getBytes();
    private static final byte[] COLOR_GREEN = "\\green".getBytes();
    private static final byte[] COLOR_BLUE = "\\blue".getBytes();
    private static final byte COLON = 59;
    private static final byte[] COLOR_NUMBER = "\\cf".getBytes();
    private int colorNumber = 0;
    private int red = 0;
    private int green = 0;
    private int blue = 0;

    protected RtfColor(RtfDocument rtfDocument, int n2, int n3, int n4, int n5) {
        super(rtfDocument);
        this.red = n2;
        this.blue = n4;
        this.green = n3;
        this.colorNumber = n5;
    }

    public RtfColor(RtfDocument rtfDocument, RtfColor rtfColor) {
        super(rtfDocument);
        if (rtfColor != null) {
            this.red = rtfColor.getRed();
            this.green = rtfColor.getGreen();
            this.blue = rtfColor.getBlue();
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument rtfDocument, Color color) {
        super(rtfDocument);
        if (color != null) {
            this.red = color.getRed();
            this.blue = color.getBlue();
            this.green = color.getGreen();
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument rtfDocument, int n2, int n3, int n4) {
        super(rtfDocument);
        this.red = n2;
        this.blue = n4;
        this.green = n3;
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(COLOR_RED);
            byteArrayOutputStream.write(this.intToByteArray(this.red));
            byteArrayOutputStream.write(COLOR_GREEN);
            byteArrayOutputStream.write(this.intToByteArray(this.green));
            byteArrayOutputStream.write(COLOR_BLUE);
            byteArrayOutputStream.write(this.intToByteArray(this.blue));
            byteArrayOutputStream.write(59);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeBegin() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(COLOR_NUMBER);
            byteArrayOutputStream.write(this.intToByteArray(this.colorNumber));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeEnd() {
        return new byte[0];
    }

    public boolean equals(Object object) {
        if (!(object instanceof RtfColor)) {
            return false;
        }
        RtfColor rtfColor = (RtfColor)object;
        return this.red == rtfColor.getRed() && this.green == rtfColor.getGreen() && this.blue == rtfColor.getBlue();
    }

    public int hashCode() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRed() {
        return this.red;
    }

    public int getColorNumber() {
        return this.colorNumber;
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }
}

