/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.codec.wmf.MetaBrush;
import com.lowagie.text.pdf.codec.wmf.MetaFont;
import com.lowagie.text.pdf.codec.wmf.MetaObject;
import com.lowagie.text.pdf.codec.wmf.MetaPen;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Stack;

public class MetaState {
    public static final int TA_NOUPDATECP = 0;
    public static final int TA_UPDATECP = 1;
    public static final int TA_LEFT = 0;
    public static final int TA_RIGHT = 2;
    public static final int TA_CENTER = 6;
    public static final int TA_TOP = 0;
    public static final int TA_BOTTOM = 8;
    public static final int TA_BASELINE = 24;
    public static final int TRANSPARENT = 1;
    public static final int OPAQUE = 2;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    public Stack savedStates;
    public ArrayList MetaObjects;
    public Point currentPoint;
    public MetaPen currentPen;
    public MetaBrush currentBrush;
    public MetaFont currentFont;
    public Color currentBackgroundColor = Color.white;
    public Color currentTextColor = Color.black;
    public int backgroundMode = 2;
    public int polyFillMode = 1;
    public int lineJoin = 1;
    public int textAlign;
    public int offsetWx;
    public int offsetWy;
    public int extentWx;
    public int extentWy;
    public float scalingX;
    public float scalingY;

    public MetaState() {
        this.savedStates = new Stack();
        this.MetaObjects = new ArrayList();
        this.currentPoint = new Point(0, 0);
        this.currentPen = new MetaPen();
        this.currentBrush = new MetaBrush();
        this.currentFont = new MetaFont();
    }

    public MetaState(MetaState metaState) {
        this.setMetaState(metaState);
    }

    public void setMetaState(MetaState metaState) {
        this.savedStates = metaState.savedStates;
        this.MetaObjects = metaState.MetaObjects;
        this.currentPoint = metaState.currentPoint;
        this.currentPen = metaState.currentPen;
        this.currentBrush = metaState.currentBrush;
        this.currentFont = metaState.currentFont;
        this.currentBackgroundColor = metaState.currentBackgroundColor;
        this.currentTextColor = metaState.currentTextColor;
        this.backgroundMode = metaState.backgroundMode;
        this.polyFillMode = metaState.polyFillMode;
        this.textAlign = metaState.textAlign;
        this.lineJoin = metaState.lineJoin;
        this.offsetWx = metaState.offsetWx;
        this.offsetWy = metaState.offsetWy;
        this.extentWx = metaState.extentWx;
        this.extentWy = metaState.extentWy;
        this.scalingX = metaState.scalingX;
        this.scalingY = metaState.scalingY;
    }

    public void addMetaObject(MetaObject metaObject) {
        for (int i2 = 0; i2 < this.MetaObjects.size(); ++i2) {
            if (this.MetaObjects.get(i2) != null) continue;
            this.MetaObjects.set(i2, metaObject);
            return;
        }
        this.MetaObjects.add(metaObject);
    }

    public void selectMetaObject(int n2, PdfContentByte pdfContentByte) {
        MetaObject metaObject = (MetaObject)this.MetaObjects.get(n2);
        if (metaObject == null) {
            return;
        }
        block0 : switch (metaObject.getType()) {
            case 2: {
                this.currentBrush = (MetaBrush)metaObject;
                int n3 = this.currentBrush.getStyle();
                if (n3 == 0) {
                    Color color = this.currentBrush.getColor();
                    pdfContentByte.setColorFill(color);
                    break;
                }
                if (n3 != 2) break;
                Color color = this.currentBackgroundColor;
                pdfContentByte.setColorFill(color);
                break;
            }
            case 1: {
                this.currentPen = (MetaPen)metaObject;
                int n4 = this.currentPen.getStyle();
                if (n4 == 5) break;
                Color color = this.currentPen.getColor();
                pdfContentByte.setColorStroke(color);
                pdfContentByte.setLineWidth(Math.abs((float)this.currentPen.getPenWidth() * this.scalingX / (float)this.extentWx));
                switch (n4) {
                    case 1: {
                        pdfContentByte.setLineDash(18.0f, 6.0f, 0.0f);
                        break block0;
                    }
                    case 3: {
                        pdfContentByte.setLiteral("[9 6 3 6]0 d\n");
                        break block0;
                    }
                    case 4: {
                        pdfContentByte.setLiteral("[9 3 3 3 3 3]0 d\n");
                        break block0;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(3.0f, 0.0f);
                        break block0;
                    }
                }
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 3: {
                this.currentFont = (MetaFont)metaObject;
            }
        }
    }

    public void deleteMetaObject(int n2) {
        this.MetaObjects.set(n2, null);
    }

    public void saveState(PdfContentByte pdfContentByte) {
        pdfContentByte.saveState();
        MetaState metaState = new MetaState(this);
        this.savedStates.push(this);
    }

    public void restoreState(int n2, PdfContentByte pdfContentByte) {
        int n3 = n2 < 0 ? Math.min(-n2, this.savedStates.size()) : Math.max(this.savedStates.size() - n2, 0);
        if (n3 == 0) {
            return;
        }
        MetaState metaState = null;
        while (n3-- != 0) {
            pdfContentByte.restoreState();
            metaState = (MetaState)this.savedStates.pop();
        }
        this.setMetaState(metaState);
    }

    public float transformX(int n2) {
        return ((float)n2 - (float)this.offsetWx) * this.scalingX / (float)this.extentWx;
    }

    public float transformY(int n2) {
        return (1.0f - ((float)n2 - (float)this.offsetWy) / (float)this.extentWy) * this.scalingY;
    }

    public void setScalingX(float f2) {
        this.scalingX = f2;
    }

    public void setScalingY(float f2) {
        this.scalingY = f2;
    }

    public void setOffsetWx(int n2) {
        this.offsetWx = n2;
    }

    public void setOffsetWy(int n2) {
        this.offsetWy = n2;
    }

    public void setExtentWx(int n2) {
        this.extentWx = n2;
    }

    public void setExtentWy(int n2) {
        this.extentWy = n2;
    }

    public float transformAngle(float f2) {
        float f3 = this.extentWy < 0 ? -f2 : f2;
        return this.extentWx < 0 ? 180.0f - f3 : f3;
    }

    public void setCurrentPoint(Point point) {
        this.currentPoint = point;
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public MetaBrush getCurrentBrush() {
        return this.currentBrush;
    }

    public MetaPen getCurrentPen() {
        return this.currentPen;
    }

    public MetaFont getCurrentFont() {
        return this.currentFont;
    }

    public Color getCurrentBackgroundColor() {
        return this.currentBackgroundColor;
    }

    public void setCurrentBackgroundColor(Color color) {
        this.currentBackgroundColor = color;
    }

    public Color getCurrentTextColor() {
        return this.currentTextColor;
    }

    public void setCurrentTextColor(Color color) {
        this.currentTextColor = color;
    }

    public int getBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(int n2) {
        this.backgroundMode = n2;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int n2) {
        this.textAlign = n2;
    }

    public int getPolyFillMode() {
        return this.polyFillMode;
    }

    public void setPolyFillMode(int n2) {
        this.polyFillMode = n2;
    }

    public void setLineJoinRectangle(PdfContentByte pdfContentByte) {
        if (this.lineJoin != 0) {
            this.lineJoin = 0;
            pdfContentByte.setLineJoin(0);
        }
    }

    public void setLineJoinPolygon(PdfContentByte pdfContentByte) {
        if (this.lineJoin == 0) {
            this.lineJoin = 1;
            pdfContentByte.setLineJoin(1);
        }
    }

    public boolean getLineNeutral() {
        return this.lineJoin == 0;
    }
}

