/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

class TrueTypeFontSubSet {
    static final String[] tableNamesSimple = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    static final String[] tableNamesCmap = new String[]{"cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    static final int[] entrySelectors = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4};
    static final int TABLE_CHECKSUM = 0;
    static final int TABLE_OFFSET = 1;
    static final int TABLE_LENGTH = 2;
    static final int HEAD_LOCA_FORMAT_OFFSET = 51;
    static final int ARG_1_AND_2_ARE_WORDS = 1;
    static final int WE_HAVE_A_SCALE = 8;
    static final int MORE_COMPONENTS = 32;
    static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    static final int WE_HAVE_A_TWO_BY_TWO = 128;
    protected HashMap tableDirectory;
    protected RandomAccessFileOrArray rf;
    protected String fileName;
    protected boolean includeCmap;
    protected boolean locaShortTable;
    protected int[] locaTable;
    protected HashMap glyphsUsed;
    protected ArrayList glyphsInList;
    protected int tableGlyphOffset;
    protected int[] newLocaTable;
    protected byte[] newLocaTableOut;
    protected byte[] newGlyfTable;
    protected int glyfTableRealSize;
    protected int locaTableRealSize;
    protected byte[] outFont;
    protected int fontPtr;
    protected int directoryOffset;

    TrueTypeFontSubSet(String string, RandomAccessFileOrArray randomAccessFileOrArray, HashMap hashMap, int n2, boolean bl) {
        this.fileName = string;
        this.rf = randomAccessFileOrArray;
        this.glyphsUsed = hashMap;
        this.includeCmap = bl;
        this.directoryOffset = n2;
        this.glyphsInList = new ArrayList(hashMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] process() throws IOException, DocumentException {
        try {
            this.rf.reOpen();
            this.createTableDirectory();
            this.readLoca();
            this.flatGlyphs();
            this.createNewGlyphTables();
            this.locaTobytes();
            this.assembleFont();
            byte[] byArray = this.outFont;
            return byArray;
        }
        finally {
            try {
                this.rf.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void assembleFont() throws IOException, DocumentException {
        String string;
        int n2;
        int[] nArray;
        int n3;
        int n4 = 0;
        String[] stringArray = this.includeCmap ? tableNamesCmap : tableNamesSimple;
        int n5 = 2;
        int n6 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            String string2 = stringArray[n3];
            if (string2.equals("glyf") || string2.equals("loca") || (nArray = (int[])this.tableDirectory.get(string2)) == null) continue;
            ++n5;
            n4 += nArray[2] + 3 & 0xFFFFFFFC;
        }
        n4 += this.newLocaTableOut.length;
        n4 += this.newGlyfTable.length;
        n3 = 16 * n5 + 12;
        this.outFont = new byte[n4 += n3];
        this.fontPtr = 0;
        this.writeFontInt(65536);
        this.writeFontShort(n5);
        int n7 = entrySelectors[n5];
        this.writeFontShort((1 << n7) * 16);
        this.writeFontShort(n7);
        this.writeFontShort((n5 - (1 << n7)) * 16);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string = stringArray[n2];
            nArray = (int[])this.tableDirectory.get(string);
            if (nArray == null) continue;
            this.writeFontString(string);
            if (string.equals("glyf")) {
                this.writeFontInt(this.calculateChecksum(this.newGlyfTable));
                n6 = this.glyfTableRealSize;
            } else if (string.equals("loca")) {
                this.writeFontInt(this.calculateChecksum(this.newLocaTableOut));
                n6 = this.locaTableRealSize;
            } else {
                this.writeFontInt(nArray[0]);
                n6 = nArray[2];
            }
            this.writeFontInt(n3);
            this.writeFontInt(n6);
            n3 += n6 + 3 & 0xFFFFFFFC;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string = stringArray[n2];
            nArray = (int[])this.tableDirectory.get(string);
            if (nArray == null) continue;
            if (string.equals("glyf")) {
                System.arraycopy(this.newGlyfTable, 0, this.outFont, this.fontPtr, this.newGlyfTable.length);
                this.fontPtr += this.newGlyfTable.length;
                this.newGlyfTable = null;
                continue;
            }
            if (string.equals("loca")) {
                System.arraycopy(this.newLocaTableOut, 0, this.outFont, this.fontPtr, this.newLocaTableOut.length);
                this.fontPtr += this.newLocaTableOut.length;
                this.newLocaTableOut = null;
                continue;
            }
            this.rf.seek(nArray[1]);
            this.rf.readFully(this.outFont, this.fontPtr, nArray[2]);
            this.fontPtr += nArray[2] + 3 & 0xFFFFFFFC;
        }
    }

    protected void createTableDirectory() throws IOException, DocumentException {
        this.tableDirectory = new HashMap();
        this.rf.seek(this.directoryOffset);
        int n2 = this.rf.readInt();
        if (n2 != 65536) {
            throw new DocumentException(this.fileName + " is not a true type file.");
        }
        int n3 = this.rf.readUnsignedShort();
        this.rf.skipBytes(6);
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = this.readStandardString(4);
            int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt(), this.rf.readInt()};
            this.tableDirectory.put(string, nArray);
        }
    }

    protected void readLoca() throws IOException, DocumentException {
        int[] nArray = (int[])this.tableDirectory.get("head");
        if (nArray == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[1] + 51);
        this.locaShortTable = this.rf.readUnsignedShort() == 0;
        nArray = (int[])this.tableDirectory.get("loca");
        if (nArray == null) {
            throw new DocumentException("Table 'loca' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[1]);
        if (this.locaShortTable) {
            int n2 = nArray[2] / 2;
            this.locaTable = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.locaTable[i2] = this.rf.readUnsignedShort() * 2;
            }
        } else {
            int n3 = nArray[2] / 4;
            this.locaTable = new int[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                this.locaTable[i3] = this.rf.readInt();
            }
        }
    }

    protected void createNewGlyphTables() throws IOException {
        int n2;
        int n3;
        int n4;
        this.newLocaTable = new int[this.locaTable.length];
        int[] nArray = new int[this.glyphsInList.size()];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            nArray[n4] = (Integer)this.glyphsInList.get(n4);
        }
        Arrays.sort(nArray);
        n4 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            n4 += this.locaTable[n2 + 1] - this.locaTable[n2];
        }
        this.glyfTableRealSize = n4;
        n4 = n4 + 3 & 0xFFFFFFFC;
        this.newGlyfTable = new byte[n4];
        n3 = 0;
        n2 = 0;
        for (int i2 = 0; i2 < this.newLocaTable.length; ++i2) {
            this.newLocaTable[i2] = n3;
            if (n2 >= nArray.length || nArray[n2] != i2) continue;
            ++n2;
            this.newLocaTable[i2] = n3;
            int n5 = this.locaTable[i2];
            int n6 = this.locaTable[i2 + 1] - n5;
            if (n6 <= 0) continue;
            this.rf.seek(this.tableGlyphOffset + n5);
            this.rf.readFully(this.newGlyfTable, n3, n6);
            n3 += n6;
        }
    }

    protected void locaTobytes() {
        this.locaTableRealSize = this.locaShortTable ? this.newLocaTable.length * 2 : this.newLocaTable.length * 4;
        this.newLocaTableOut = new byte[this.locaTableRealSize + 3 & 0xFFFFFFFC];
        this.outFont = this.newLocaTableOut;
        this.fontPtr = 0;
        for (int i2 = 0; i2 < this.newLocaTable.length; ++i2) {
            if (this.locaShortTable) {
                this.writeFontShort(this.newLocaTable[i2] / 2);
                continue;
            }
            this.writeFontInt(this.newLocaTable[i2]);
        }
    }

    protected void flatGlyphs() throws IOException, DocumentException {
        int[] nArray = (int[])this.tableDirectory.get("glyf");
        if (nArray == null) {
            throw new DocumentException("Table 'glyf' does not exist in " + this.fileName);
        }
        Integer n2 = new Integer(0);
        if (!this.glyphsUsed.containsKey(n2)) {
            this.glyphsUsed.put(n2, null);
            this.glyphsInList.add(n2);
        }
        this.tableGlyphOffset = nArray[1];
        for (int i2 = 0; i2 < this.glyphsInList.size(); ++i2) {
            int n3 = (Integer)this.glyphsInList.get(i2);
            this.checkGlyphComposite(n3);
        }
    }

    protected void checkGlyphComposite(int n2) throws IOException {
        int n3 = this.locaTable[n2];
        if (n3 == this.locaTable[n2 + 1]) {
            return;
        }
        this.rf.seek(this.tableGlyphOffset + n3);
        short s2 = this.rf.readShort();
        if (s2 >= 0) {
            return;
        }
        this.rf.skipBytes(8);
        while (true) {
            int n4 = this.rf.readUnsignedShort();
            Integer n5 = new Integer(this.rf.readUnsignedShort());
            if (!this.glyphsUsed.containsKey(n5)) {
                this.glyphsUsed.put(n5, null);
                this.glyphsInList.add(n5);
            }
            if ((n4 & 0x20) == 0) {
                return;
            }
            int n6 = (n4 & 1) != 0 ? 4 : 2;
            if ((n4 & 8) != 0) {
                n6 += 2;
            } else if ((n4 & 0x40) != 0) {
                n6 += 4;
            }
            if ((n4 & 0x80) != 0) {
                n6 += 8;
            }
            this.rf.skipBytes(n6);
        }
    }

    protected String readStandardString(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.rf.readFully(byArray);
        try {
            return new String(byArray, "Cp1252");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected void writeFontShort(int n2) {
        this.outFont[this.fontPtr++] = (byte)(n2 >> 8);
        this.outFont[this.fontPtr++] = (byte)n2;
    }

    protected void writeFontInt(int n2) {
        this.outFont[this.fontPtr++] = (byte)(n2 >> 24);
        this.outFont[this.fontPtr++] = (byte)(n2 >> 16);
        this.outFont[this.fontPtr++] = (byte)(n2 >> 8);
        this.outFont[this.fontPtr++] = (byte)n2;
    }

    protected void writeFontString(String string) {
        byte[] byArray = PdfEncodings.convertToBytes(string, "Cp1252");
        System.arraycopy(byArray, 0, this.outFont, this.fontPtr, byArray.length);
        this.fontPtr += byArray.length;
    }

    protected int calculateChecksum(byte[] byArray) {
        int n2 = byArray.length / 4;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n6 += byArray[n7++] & 0xFF;
            n5 += byArray[n7++] & 0xFF;
            n4 += byArray[n7++] & 0xFF;
            n3 += byArray[n7++] & 0xFF;
        }
        return n3 + (n4 << 8) + (n5 << 16) + (n6 << 24);
    }
}

