/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TrueTypeFontSubSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

class TrueTypeFont
extends BaseFont {
    static final String[] codePages = new String[]{"1252 Latin 1", "1250 Latin 2: Eastern Europe", "1251 Cyrillic", "1253 Greek", "1254 Turkish", "1255 Hebrew", "1256 Arabic", "1257 Windows Baltic", "1258 Vietnamese", null, null, null, null, null, null, null, "874 Thai", "932 JIS/Japan", "936 Chinese: Simplified chars--PRC and Singapore", "949 Korean Wansung", "950 Chinese: Traditional chars--Taiwan and Hong Kong", "1361 Korean Johab", null, null, null, null, null, null, null, "Macintosh Character Set (US Roman)", "OEM Character Set", "Symbol Character Set", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "869 IBM Greek", "866 MS-DOS Russian", "865 MS-DOS Nordic", "864 Arabic", "863 MS-DOS Canadian French", "862 Hebrew", "861 MS-DOS Icelandic", "860 MS-DOS Portuguese", "857 IBM Turkish", "855 IBM Cyrillic; primarily Russian", "852 Latin 2", "775 MS-DOS Baltic", "737 Greek; former 437 G", "708 Arabic; ASMO 708", "850 WE/Latin 1", "437 US"};
    protected boolean justNames = false;
    protected HashMap tables;
    protected RandomAccessFileOrArray rf;
    protected String fileName;
    protected boolean cff = false;
    protected int cffOffset;
    protected int cffLength;
    protected int directoryOffset;
    protected String ttcIndex;
    protected String style = "";
    protected FontHeader head = new FontHeader();
    protected HorizontalHeader hhea = new HorizontalHeader();
    protected WindowsMetrics os_2 = new WindowsMetrics();
    protected int[] GlyphWidths;
    protected int[][] bboxes;
    protected HashMap cmap10;
    protected HashMap cmap31;
    protected IntHashtable kerning = new IntHashtable();
    protected String fontName;
    protected String[][] fullName;
    protected String[][] familyName;
    protected double italicAngle;
    protected boolean isFixedPitch = false;

    protected TrueTypeFont() {
    }

    TrueTypeFont(String string, String string2, boolean bl, byte[] byArray) throws DocumentException, IOException {
        this(string, string2, bl, byArray, false);
    }

    TrueTypeFont(String string, String string2, boolean bl, byte[] byArray, boolean bl2) throws DocumentException, IOException {
        this.justNames = bl2;
        String string3 = TrueTypeFont.getBaseName(string);
        String string4 = TrueTypeFont.getTTCName(string3);
        if (string3.length() < string.length()) {
            this.style = string.substring(string3.length());
        }
        this.encoding = string2;
        this.embedded = bl;
        this.fileName = string4;
        this.fontType = 1;
        this.ttcIndex = "";
        if (string4.length() < string3.length()) {
            this.ttcIndex = string3.substring(string4.length() + 1);
        }
        if (this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc")) {
            this.process(byArray);
            if (!bl2 && this.embedded && this.os_2.fsType == 2) {
                throw new DocumentException(this.fileName + this.style + " cannot be embedded due to licensing restrictions.");
            }
        } else {
            throw new DocumentException(this.fileName + this.style + " is not a TTF, OTF or TTC font file.");
        }
        PdfEncodings.convertToBytes(" ", string2);
        this.createEncoding();
    }

    protected static String getTTCName(String string) {
        int n2 = string.toLowerCase().indexOf(".ttc,");
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2 + 4);
    }

    void fillTables() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("head");
        if (nArray == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 16);
        this.head.flags = this.rf.readUnsignedShort();
        this.head.unitsPerEm = this.rf.readUnsignedShort();
        this.rf.skipBytes(16);
        this.head.xMin = this.rf.readShort();
        this.head.yMin = this.rf.readShort();
        this.head.xMax = this.rf.readShort();
        this.head.yMax = this.rf.readShort();
        this.head.macStyle = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("hhea");
        if (nArray == null) {
            throw new DocumentException("Table 'hhea' does not exist " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 4);
        this.hhea.Ascender = this.rf.readShort();
        this.hhea.Descender = this.rf.readShort();
        this.hhea.LineGap = this.rf.readShort();
        this.hhea.advanceWidthMax = this.rf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.rf.readShort();
        this.hhea.minRightSideBearing = this.rf.readShort();
        this.hhea.xMaxExtent = this.rf.readShort();
        this.hhea.caretSlopeRise = this.rf.readShort();
        this.hhea.caretSlopeRun = this.rf.readShort();
        this.rf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("OS/2");
        if (nArray == null) {
            throw new DocumentException("Table 'OS/2' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        int n2 = this.rf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.rf.readShort();
        this.os_2.usWeightClass = this.rf.readUnsignedShort();
        this.os_2.usWidthClass = this.rf.readUnsignedShort();
        this.os_2.fsType = this.rf.readShort();
        this.os_2.ySubscriptXSize = this.rf.readShort();
        this.os_2.ySubscriptYSize = this.rf.readShort();
        this.os_2.ySubscriptXOffset = this.rf.readShort();
        this.os_2.ySubscriptYOffset = this.rf.readShort();
        this.os_2.ySuperscriptXSize = this.rf.readShort();
        this.os_2.ySuperscriptYSize = this.rf.readShort();
        this.os_2.ySuperscriptXOffset = this.rf.readShort();
        this.os_2.ySuperscriptYOffset = this.rf.readShort();
        this.os_2.yStrikeoutSize = this.rf.readShort();
        this.os_2.yStrikeoutPosition = this.rf.readShort();
        this.os_2.sFamilyClass = this.rf.readShort();
        this.rf.readFully(this.os_2.panose);
        this.rf.skipBytes(16);
        this.rf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.rf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.rf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.rf.readUnsignedShort();
        this.os_2.sTypoAscender = this.rf.readShort();
        this.os_2.sTypoDescender = this.rf.readShort();
        if (this.os_2.sTypoDescender > 0) {
            this.os_2.sTypoDescender = -this.os_2.sTypoDescender;
        }
        this.os_2.sTypoLineGap = this.rf.readShort();
        this.os_2.usWinAscent = this.rf.readUnsignedShort();
        this.os_2.usWinDescent = this.rf.readUnsignedShort();
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (n2 > 0) {
            this.os_2.ulCodePageRange1 = this.rf.readInt();
            this.os_2.ulCodePageRange2 = this.rf.readInt();
        }
        if (n2 > 1) {
            this.rf.skipBytes(2);
            this.os_2.sCapHeight = this.rf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
        nArray = (int[])this.tables.get("post");
        if (nArray == null) {
            this.italicAngle = -Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI;
            return;
        }
        this.rf.seek(nArray[0] + 4);
        short s2 = this.rf.readShort();
        int n3 = this.rf.readUnsignedShort();
        this.italicAngle = (double)s2 + (double)n3 / 16384.0;
        this.rf.skipBytes(4);
        this.isFixedPitch = this.rf.readInt() != 0;
    }

    String getBaseFont() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n2 = this.rf.readUnsignedShort();
        int n3 = this.rf.readUnsignedShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            if (n7 != 6) continue;
            this.rf.seek(nArray[0] + n3 + n9);
            if (n4 == 0 || n4 == 3) {
                return this.readUnicodeString(n8);
            }
            return this.readStandardString(n8);
        }
        File file = new File(this.fileName);
        return file.getName().replace(' ', '-');
    }

    String[][] getNames(int n2) throws DocumentException, IOException {
        int n3;
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n4 = this.rf.readUnsignedShort();
        int n5 = this.rf.readUnsignedShort();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            int n10 = this.rf.readUnsignedShort();
            if (n8 != n2) continue;
            int n11 = this.rf.getFilePointer();
            this.rf.seek(nArray[0] + n5 + n10);
            String string = n3 == 0 || n3 == 3 || n3 == 2 && n6 == 1 ? this.readUnicodeString(n9) : this.readStandardString(n9);
            arrayList.add(new String[]{String.valueOf(n3), String.valueOf(n6), String.valueOf(n7), string});
            this.rf.seek(n11);
        }
        String[][] stringArray = new String[arrayList.size()][];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            stringArray[n3] = (String[])arrayList.get(n3);
        }
        return stringArray;
    }

    void checkCff() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("CFF ");
        if (nArray != null) {
            this.cff = true;
            this.cffOffset = nArray[0];
            this.cffLength = nArray[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(byte[] byArray) throws DocumentException, IOException {
        block12: {
            this.tables = new HashMap();
            try {
                int n2;
                int n3;
                this.rf = byArray == null ? new RandomAccessFileOrArray(this.fileName) : new RandomAccessFileOrArray(byArray);
                if (this.ttcIndex.length() > 0) {
                    n3 = Integer.parseInt(this.ttcIndex);
                    if (n3 < 0) {
                        throw new DocumentException("The font index for " + this.fileName + " must be positive.");
                    }
                    String string = this.readStandardString(4);
                    if (!string.equals("ttcf")) {
                        throw new DocumentException(this.fileName + " is not a valid TTC file.");
                    }
                    this.rf.skipBytes(4);
                    n2 = this.rf.readInt();
                    if (n3 >= n2) {
                        throw new DocumentException("The font index for " + this.fileName + " must be between 0 and " + (n2 - 1) + ". It was " + n3 + ".");
                    }
                    this.rf.skipBytes(n3 * 4);
                    this.directoryOffset = this.rf.readInt();
                }
                this.rf.seek(this.directoryOffset);
                n3 = this.rf.readInt();
                if (n3 != 65536 && n3 != 0x4F54544F) {
                    throw new DocumentException(this.fileName + " is not a valid TTF or OTF file.");
                }
                int n4 = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                for (n2 = 0; n2 < n4; ++n2) {
                    String string = this.readStandardString(4);
                    this.rf.skipBytes(4);
                    int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt()};
                    this.tables.put(string, nArray);
                }
                this.checkCff();
                this.fontName = this.getBaseFont();
                this.fullName = this.getNames(4);
                this.familyName = this.getNames(1);
                if (!this.justNames) {
                    this.fillTables();
                    this.readGlyphWidths();
                    this.readCMaps();
                    this.readKerning();
                    this.readBbox();
                    this.GlyphWidths = null;
                }
                Object var8_8 = null;
                if (this.rf == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (this.rf != null) {
                    this.rf.close();
                    if (!this.embedded) {
                        this.rf = null;
                    }
                }
                throw throwable;
            }
            this.rf.close();
            if (!this.embedded) {
                this.rf = null;
            }
        }
    }

    protected String readStandardString(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.rf.readFully(byArray);
        try {
            return new String(byArray, "Cp1252");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected String readUnicodeString(int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        n2 /= 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.rf.readChar());
        }
        return stringBuffer.toString();
    }

    protected void readGlyphWidths() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("hmtx");
        if (nArray == null) {
            throw new DocumentException("Table 'hmtx' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.GlyphWidths = new int[this.hhea.numberOfHMetrics];
        for (int i2 = 0; i2 < this.hhea.numberOfHMetrics; ++i2) {
            this.GlyphWidths[i2] = this.rf.readUnsignedShort() * 1000 / this.head.unitsPerEm;
            this.rf.readUnsignedShort();
        }
    }

    protected int getGlyphWidth(int n2) {
        if (n2 >= this.GlyphWidths.length) {
            n2 = this.GlyphWidths.length - 1;
        }
        return this.GlyphWidths[n2];
    }

    private void readBbox() throws DocumentException, IOException {
        int n2;
        int[] nArray;
        int n3;
        int[] nArray2 = (int[])this.tables.get("head");
        if (nArray2 == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray2[0] + 51);
        boolean bl = this.rf.readUnsignedShort() == 0;
        nArray2 = (int[])this.tables.get("loca");
        if (nArray2 == null) {
            return;
        }
        this.rf.seek(nArray2[0]);
        if (bl) {
            n3 = nArray2[1] / 2;
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.rf.readUnsignedShort() * 2;
            }
        } else {
            n3 = nArray2[1] / 4;
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.rf.readInt();
            }
        }
        if ((nArray2 = (int[])this.tables.get("glyf")) == null) {
            throw new DocumentException("Table 'glyf' does not exist in " + this.fileName + this.style);
        }
        n3 = nArray2[0];
        this.bboxes = new int[nArray.length - 1][];
        for (n2 = 0; n2 < nArray.length - 1; ++n2) {
            int n4 = nArray[n2];
            if (n4 == nArray[n2 + 1]) continue;
            this.rf.seek(n3 + n4 + 2);
            this.bboxes[n2] = new int[]{this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm};
        }
    }

    void readCMaps() throws DocumentException, IOException {
        int n2;
        int[] nArray = (int[])this.tables.get("cmap");
        if (nArray == null) {
            throw new DocumentException("Table 'cmap' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.rf.skipBytes(2);
        int n3 = this.rf.readUnsignedShort();
        this.fontSpecific = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readInt();
            if (n7 == 3 && n8 == 0) {
                this.fontSpecific = true;
                n6 = n9;
            } else if (n7 == 3 && n8 == 1) {
                n5 = n9;
            }
            if (n7 != 1 || n8 != 0) continue;
            n4 = n9;
        }
        if (n4 > 0) {
            this.rf.seek(nArray[0] + n4);
            n2 = this.rf.readUnsignedShort();
            switch (n2) {
                case 0: {
                    this.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmap10 = this.readFormat4();
                    break;
                }
                case 6: {
                    this.cmap10 = this.readFormat6();
                }
            }
        }
        if (n5 > 0) {
            this.rf.seek(nArray[0] + n5);
            n2 = this.rf.readUnsignedShort();
            if (n2 == 4) {
                this.cmap31 = this.readFormat4();
            }
        }
        if (n6 > 0) {
            this.rf.seek(nArray[0] + n6);
            n2 = this.rf.readUnsignedShort();
            if (n2 == 4) {
                this.cmap10 = this.readFormat4();
            }
        }
    }

    HashMap readFormat0() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        for (int i2 = 0; i2 < 256; ++i2) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedByte(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(i2), nArray);
        }
        return hashMap;
    }

    HashMap readFormat4() throws IOException {
        int n2;
        int n3 = this.fontSpecific ? 255 : 65535;
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        int n4 = this.rf.readUnsignedShort();
        this.rf.skipBytes(2);
        int n5 = this.rf.readUnsignedShort() / 2;
        this.rf.skipBytes(6);
        int[] nArray = new int[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2] = this.rf.readUnsignedShort();
        }
        this.rf.skipBytes(2);
        int[] nArray2 = new int[n5];
        for (int i3 = 0; i3 < n5; ++i3) {
            nArray2[i3] = this.rf.readUnsignedShort();
        }
        int[] nArray3 = new int[n5];
        for (int i4 = 0; i4 < n5; ++i4) {
            nArray3[i4] = this.rf.readUnsignedShort();
        }
        int[] nArray4 = new int[n5];
        for (int i5 = 0; i5 < n5; ++i5) {
            nArray4[i5] = this.rf.readUnsignedShort();
        }
        int[] nArray5 = new int[n4 / 2 - 8 - n5 * 4];
        for (n2 = 0; n2 < nArray5.length; ++n2) {
            nArray5[n2] = this.rf.readUnsignedShort();
        }
        for (n2 = 0; n2 < n5; ++n2) {
            for (int i6 = nArray2[n2]; i6 <= nArray[n2] && i6 != 65535; ++i6) {
                int[] nArray6;
                int n6;
                if (nArray4[n2] == 0) {
                    n6 = i6 + nArray3[n2] & 0xFFFF;
                } else {
                    int n7 = n2 + nArray4[n2] / 2 - n5 + i6 - nArray2[n2];
                    if (n7 >= nArray5.length) continue;
                    n6 = nArray5[n7] + nArray3[n2] & 0xFFFF;
                }
                nArray6 = new int[]{n6, this.getGlyphWidth(nArray6[0])};
                hashMap.put(new Integer(i6 & n3), nArray6);
            }
        }
        return hashMap;
    }

    HashMap readFormat6() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n2 = this.rf.readUnsignedShort();
        int n3 = this.rf.readUnsignedShort();
        for (int i2 = 0; i2 < n3; ++i2) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedShort(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(i2 + n2), nArray);
        }
        return hashMap;
    }

    void readKerning() throws IOException {
        int[] nArray = (int[])this.tables.get("kern");
        if (nArray == null) {
            return;
        }
        this.rf.seek(nArray[0] + 2);
        int n2 = this.rf.readUnsignedShort();
        int n3 = nArray[0] + 4;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.rf.seek(n3 += n4);
            this.rf.skipBytes(2);
            n4 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            if ((n5 & 0xFFF7) != 1) continue;
            int n6 = this.rf.readUnsignedShort();
            this.rf.skipBytes(6);
            for (int i3 = 0; i3 < n6; ++i3) {
                int n7 = this.rf.readInt();
                int n8 = this.rf.readShort() * 1000 / this.head.unitsPerEm;
                this.kerning.put(n7, n8);
            }
        }
    }

    public int getKerning(char c2, char c3) {
        int[] nArray = this.getMetricsTT(c2);
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray[0];
        nArray = this.getMetricsTT(c3);
        if (nArray == null) {
            return 0;
        }
        int n3 = nArray[0];
        return this.kerning.get((n2 << 16) + n3);
    }

    int getRawWidth(int n2, String string) {
        HashMap hashMap = null;
        hashMap = string == null || this.cmap31 == null ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return 0;
        }
        int[] nArray = (int[])hashMap.get(new Integer(n2));
        if (nArray == null) {
            return 0;
        }
        return nArray[1];
    }

    protected PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference, String string) throws DocumentException {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        pdfDictionary.put(PdfName.ASCENT, new PdfNumber(this.os_2.sTypoAscender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(PdfName.CAPHEIGHT, new PdfNumber(this.os_2.sCapHeight * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(PdfName.DESCENT, new PdfNumber(this.os_2.sTypoDescender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(PdfName.FONTBBOX, new PdfRectangle(this.head.xMin * 1000 / this.head.unitsPerEm, this.head.yMin * 1000 / this.head.unitsPerEm, this.head.xMax * 1000 / this.head.unitsPerEm, this.head.yMax * 1000 / this.head.unitsPerEm));
        if (this.cff) {
            if (this.encoding.startsWith("Identity-")) {
                pdfDictionary.put(PdfName.FONTNAME, new PdfName(this.fontName + "-" + this.encoding));
            } else {
                pdfDictionary.put(PdfName.FONTNAME, new PdfName(this.fontName + this.style));
            }
        } else {
            pdfDictionary.put(PdfName.FONTNAME, new PdfName(string + this.fontName + this.style));
        }
        pdfDictionary.put(PdfName.ITALICANGLE, new PdfNumber(this.italicAngle));
        pdfDictionary.put(PdfName.STEMV, new PdfNumber(80));
        if (pdfIndirectReference != null) {
            if (this.cff) {
                pdfDictionary.put(PdfName.FONTFILE3, pdfIndirectReference);
            } else {
                pdfDictionary.put(PdfName.FONTFILE2, pdfIndirectReference);
            }
        }
        int n2 = 0;
        if (this.isFixedPitch) {
            n2 |= 1;
        }
        n2 |= this.fontSpecific ? 4 : 32;
        if ((this.head.macStyle & 2) != 0) {
            n2 |= 0x40;
        }
        if ((this.head.macStyle & 1) != 0) {
            n2 |= 0x40000;
        }
        pdfDictionary.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfDictionary;
    }

    protected PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, String string, int n2, int n3, byte[] byArray) throws DocumentException {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        if (this.cff) {
            pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(this.fontName + this.style));
        } else {
            pdfDictionary.put(PdfName.SUBTYPE, PdfName.TRUETYPE);
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + this.style));
        }
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + this.style));
        if (!this.fontSpecific) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (this.differences[i2].equals(".notdef")) continue;
                n2 = i2;
                break;
            }
            if (this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman")) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.ENCODING);
                PdfArray pdfArray = new PdfArray();
                boolean bl = true;
                for (int i3 = n2; i3 <= n3; ++i3) {
                    if (byArray[i3] != 0) {
                        if (bl) {
                            pdfArray.add(new PdfNumber(i3));
                            bl = false;
                        }
                        pdfArray.add(new PdfName(this.differences[i3]));
                        continue;
                    }
                    bl = true;
                }
                pdfDictionary2.put(PdfName.DIFFERENCES, pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfDictionary2);
            }
        }
        pdfDictionary.put(PdfName.FIRSTCHAR, new PdfNumber(n2));
        pdfDictionary.put(PdfName.LASTCHAR, new PdfNumber(n3));
        PdfArray pdfArray = new PdfArray();
        for (int i4 = n2; i4 <= n3; ++i4) {
            if (byArray[i4] == 0) {
                pdfArray.add(new PdfNumber(0));
                continue;
            }
            pdfArray.add(new PdfNumber(this.widths[i4]));
        }
        pdfDictionary.put(PdfName.WIDTHS, pdfArray);
        if (pdfIndirectReference != null) {
            pdfDictionary.put(PdfName.FONTDESCRIPTOR, pdfIndirectReference);
        }
        return pdfDictionary;
    }

    private byte[] getFullFont() throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(this.rf);
        randomAccessFileOrArray.reOpen();
        byte[] byArray = new byte[randomAccessFileOrArray.length()];
        randomAccessFileOrArray.readFully(byArray);
        randomAccessFileOrArray.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        int n2 = (Integer)objectArray[0];
        int n3 = (Integer)objectArray[1];
        byte[] byArray = (byte[])objectArray[2];
        if (!this.subset) {
            n2 = 0;
            n3 = byArray.length - 1;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = 1;
            }
        }
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = null;
        PdfIndirectObject pdfIndirectObject = null;
        String string = "";
        if (this.embedded) {
            if (this.cff) {
                RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(this.rf);
                byte[] byArray2 = new byte[this.cffLength];
                try {
                    randomAccessFileOrArray.reOpen();
                    randomAccessFileOrArray.seek(this.cffOffset);
                    randomAccessFileOrArray.readFully(byArray2);
                }
                finally {
                    try {
                        randomAccessFileOrArray.close();
                    }
                    catch (Exception exception) {}
                }
                pdfDictionary = new BaseFont.StreamFont(byArray2, "Type1C");
                pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
                pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
            } else {
                Object[] objectArray2;
                if (this.subset) {
                    string = TrueTypeFont.createSubsetPrefix();
                }
                HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                for (int i3 = n2; i3 <= n3; ++i3) {
                    if (byArray[i3] == 0 || (objectArray2 = this.fontSpecific ? this.getMetricsTT(i3) : this.getMetricsTT(this.unicodeDifferences[i3])) == null) continue;
                    hashMap.put(new Integer(objectArray2[0]), null);
                }
                TrueTypeFontSubSet trueTypeFontSubSet = new TrueTypeFontSubSet(this.fileName, new RandomAccessFileOrArray(this.rf), hashMap, this.directoryOffset, true);
                objectArray2 = trueTypeFontSubSet.process();
                int[] nArray = new int[]{objectArray2.length};
                pdfDictionary = new BaseFont.StreamFont((byte[])objectArray2, nArray);
                pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
                pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
            }
        }
        if ((pdfDictionary = this.getFontDescriptor(pdfIndirectReference2, string)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2, string, n2, n3, byArray);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    public float getFontDescriptor(int n2, float f2) {
        switch (n2) {
            case 1: {
                return (float)this.os_2.sTypoAscender * f2 / (float)this.head.unitsPerEm;
            }
            case 2: {
                return (float)this.os_2.sCapHeight * f2 / (float)this.head.unitsPerEm;
            }
            case 3: {
                return (float)this.os_2.sTypoDescender * f2 / (float)this.head.unitsPerEm;
            }
            case 4: {
                return (float)this.italicAngle;
            }
            case 5: {
                return f2 * (float)this.head.xMin / (float)this.head.unitsPerEm;
            }
            case 6: {
                return f2 * (float)this.head.yMin / (float)this.head.unitsPerEm;
            }
            case 7: {
                return f2 * (float)this.head.xMax / (float)this.head.unitsPerEm;
            }
            case 8: {
                return f2 * (float)this.head.yMax / (float)this.head.unitsPerEm;
            }
            case 9: {
                return f2 * (float)this.hhea.Ascender / (float)this.head.unitsPerEm;
            }
            case 10: {
                return f2 * (float)this.hhea.Descender / (float)this.head.unitsPerEm;
            }
            case 11: {
                return f2 * (float)this.hhea.LineGap / (float)this.head.unitsPerEm;
            }
            case 12: {
                return f2 * (float)this.hhea.advanceWidthMax / (float)this.head.unitsPerEm;
            }
        }
        return 0.0f;
    }

    public int[] getMetricsTT(int n2) {
        if (!this.fontSpecific && this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(n2));
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(n2));
        }
        if (this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(n2));
        }
        if (this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(n2));
        }
        return null;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    public String[] getCodePagesSupported() {
        long l2 = ((long)this.os_2.ulCodePageRange2 << 32) + ((long)this.os_2.ulCodePageRange1 & 0xFFFFFFFFL);
        int n2 = 0;
        long l3 = 1L;
        for (int i2 = 0; i2 < 64; ++i2) {
            if ((l2 & l3) != 0L && codePages[i2] != null) {
                ++n2;
            }
            l3 <<= 1;
        }
        String[] stringArray = new String[n2];
        n2 = 0;
        l3 = 1L;
        for (int i3 = 0; i3 < 64; ++i3) {
            if ((l2 & l3) != 0L && codePages[i3] != null) {
                stringArray[n2++] = codePages[i3];
            }
            l3 <<= 1;
        }
        return stringArray;
    }

    public String[][] getFullFontName() {
        return this.fullName;
    }

    public String[][] getFamilyFontName() {
        return this.familyName;
    }

    public boolean hasKernPairs() {
        return this.kerning.size() > 0;
    }

    public void setPostscriptFontName(String string) {
        this.fontName = string;
    }

    public boolean setKerning(char c2, char c3, int n2) {
        int[] nArray = this.getMetricsTT(c2);
        if (nArray == null) {
            return false;
        }
        int n3 = nArray[0];
        nArray = this.getMetricsTT(c3);
        if (nArray == null) {
            return false;
        }
        int n4 = nArray[0];
        this.kerning.put((n3 << 16) + n4, n2);
        return true;
    }

    protected int[] getRawCharBBox(int n2, String string) {
        HashMap hashMap = null;
        hashMap = string == null || this.cmap31 == null ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return null;
        }
        int[] nArray = (int[])hashMap.get(new Integer(n2));
        if (nArray == null || this.bboxes == null) {
            return null;
        }
        return this.bboxes[nArray[0]];
    }

    protected static class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;
        int ulCodePageRange1;
        int ulCodePageRange2;
        int sCapHeight;

        protected WindowsMetrics() {
        }
    }

    protected static class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    protected static class FontHeader {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;

        protected FontHeader() {
        }
    }
}

