/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class PdfStamperImp
extends PdfWriter {
    HashMap readers2intrefs = new HashMap();
    HashMap readers2file = new HashMap();
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected int[] namePtr = new int[]{0};
    protected boolean namedAsNames;
    protected List newBookmarks;
    protected HashSet partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected int vp = 0;
    protected HashMap fieldTemplates = new HashMap();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;
    protected boolean append;
    protected IntHashtable marked;
    protected int initialXrefSize;
    protected PdfAction openAction;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c2, boolean bl) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        this.append = bl;
        if (bl) {
            int n2;
            if (pdfReader.isRebuilt()) {
                throw new DocumentException("Append mode requires a document without errors even if recovery was possible.");
            }
            if (pdfReader.isEncrypted()) {
                throw new DocumentException("Append mode requires a document without encryption.");
            }
            this.HEADER = PdfStamperImp.getISOBytes("\n");
            this.file.reOpen();
            byte[] byArray = new byte[8192];
            while ((n2 = this.file.read(byArray)) > 0) {
                this.os.write(byArray, 0, n2);
            }
            this.file.close();
            this.prevxref = pdfReader.getLastXref();
            pdfReader.setAppendable(true);
        } else if (c2 == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c2);
        }
        super.open();
        this.pdf.addWriter(this);
        if (bl) {
            this.body.setRefnum(pdfReader.getXrefSize());
            this.marked = new IntHashtable();
            if (pdfReader.isNewXrefType()) {
                this.fullCompression = true;
            }
            if (pdfReader.isHybridXref()) {
                this.fullCompression = false;
            }
        }
        this.initialXrefSize = pdfReader.xrefObj.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap hashMap) throws DocumentException, IOException {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PdfObject pdfObject2;
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.vp);
            this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
        }
        if (this.flat) {
            this.flatFields();
        }
        this.addFieldResources();
        if (this.sigFlags != 0 && (pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog())) != null) {
            ((PdfDictionary)pdfObject2).put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(pdfObject2);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        if (this.openAction != null) {
            this.reader.getCatalog().put(PdfName.OPENACTION, this.openAction);
        }
        pdfObject2 = null;
        try {
            this.file.reOpen();
            this.alterContents();
            object4 = this.reader.xrefObj;
            boolean bl = true;
            pdfObject2 = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
            int n2 = -1;
            if (pdfObject2 != null) {
                n2 = ((PdfIndirectReference)pdfObject2).getNumber();
            }
            int n3 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
            if (this.append) {
                int n4;
                object3 = this.marked.getKeys();
                for (n4 = 0; n4 < ((int[])object3).length; ++n4) {
                    int n5 = object3[n4];
                    if (((ArrayList)object4).get(n5) == null || n2 == n5 || n5 >= this.initialXrefSize) continue;
                    this.addToBody((PdfObject)((ArrayList)object4).get(n5), n5, n5 != n3);
                }
                for (n4 = this.initialXrefSize; n4 < ((ArrayList)object4).size(); ++n4) {
                    if (((ArrayList)object4).get(n4) == null) continue;
                    this.addToBody((PdfObject)((ArrayList)object4).get(n4), this.getNewObjectNumber(this.reader, n4, 0));
                }
            } else {
                for (int i2 = 1; i2 < ((ArrayList)object4).size(); ++i2) {
                    if (((ArrayList)object4).get(i2) == null || n2 == i2) continue;
                    this.addToBody((PdfObject)((ArrayList)object4).get(i2), this.getNewObjectNumber(this.reader, i2, 0), i2 != n3);
                }
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
        object4 = null;
        PdfObject pdfObject3 = null;
        if (this.crypto != null) {
            PdfIndirectObject pdfIndirectObject = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
            object4 = pdfIndirectObject.getIndirectReference();
            pdfObject3 = this.crypto.getFileID();
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, pRIndirectReference.getNumber(), 0));
        object3 = null;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (pdfDictionary != null) {
            object2 = pdfDictionary.getKeys().iterator();
            while (object2.hasNext()) {
                object = (PdfName)object2.next();
                pdfObject = PdfReader.getPdfObject(pdfDictionary.get((PdfName)object));
                pdfDictionary2.put((PdfName)object, pdfObject);
            }
        }
        if (hashMap != null) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                pdfObject = new PdfName((String)object);
                String string = (String)hashMap.get(object);
                if (string == null) {
                    pdfDictionary2.remove((PdfName)pdfObject);
                    continue;
                }
                pdfDictionary2.put((PdfName)pdfObject, new PdfString(string, "UnicodeBig"));
            }
        }
        if (this.append) {
            object3 = pdfObject2 == null ? (Object)this.addToBody((PdfObject)pdfDictionary2, false).getIndirectReference() : (Object)this.addToBody((PdfObject)pdfDictionary2, ((PdfIndirectReference)pdfObject2).getNumber(), false).getIndirectReference();
        } else if (!pdfDictionary2.getKeys().isEmpty()) {
            object3 = this.addToBody((PdfObject)pdfDictionary2, false).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os, pdfIndirectReference, (PdfIndirectReference)object3, (PdfIndirectReference)object4, pdfObject3, this.prevxref);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            object2 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference, (PdfIndirectReference)object3, (PdfIndirectReference)object4, pdfObject3, this.prevxref);
            ((PdfWriter.PdfTrailer)object2).toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
    }

    void applyRotation(PdfDictionary pdfDictionary, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
        int n2 = rectangle.getRotation();
        switch (n2) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.top());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.right());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.top());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.right());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator iterator = this.pagesToContent.values().iterator();
        while (iterator.hasNext()) {
            PageStamp pageStamp = (PageStamp)iterator.next();
            PdfDictionary pdfDictionary = pageStamp.pageN;
            this.markUsed(pdfDictionary);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS), pdfDictionary);
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                this.markUsed(pdfArray);
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            try {
                pdfStream.flateCompress();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                try {
                    pdfStream.flateCompress();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        pageStamp.pageN.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n2, int n3) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n4 = intHashtable.get(n2);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                intHashtable.put(n2, n4);
            }
            return n4;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && n2 < this.initialXrefSize) {
                return n2;
            }
            int n5 = this.myXref.get(n2);
            if (n5 == 0) {
                n5 = this.getIndirectReferenceNumber();
                this.myXref.put(n2, n5);
            }
            return n5;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n2, n3);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    public void registerReader(PdfReader pdfReader, boolean bl) throws IOException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        if (bl) {
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            this.readers2file.put(pdfReader, randomAccessFileOrArray);
            randomAccessFileOrArray.reOpen();
        }
    }

    public void unRegisterReader(PdfReader pdfReader) {
        if (!this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.remove(pdfReader);
        RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
        if (randomAccessFileOrArray == null) {
            return;
        }
        this.readers2file.remove(pdfReader);
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void findAllObjects(PdfReader pdfReader, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                if (pdfReader != pRIndirectReference.getReader()) {
                    return;
                }
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    return;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
                PdfStamperImp.findAllObjects(pdfReader, PdfReader.getPdfObject(pdfObject), intHashtable);
                return;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    PdfStamperImp.findAllObjects(pdfReader, (PdfObject)arrayList.get(i2), intHashtable);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName = (PdfName)iterator.next();
                    PdfStamperImp.findAllObjects(pdfReader, pdfDictionary.get(pdfName), intHashtable);
                }
                return;
            }
        }
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        PdfObject pdfObject;
        PdfObject pdfObject2;
        int n2;
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        if (this.readers2intrefs.containsKey(fdfReader)) {
            return;
        }
        PdfDictionary pdfDictionary = fdfReader.getCatalog();
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FDF))) == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        this.registerReader(fdfReader, false);
        IntHashtable intHashtable = new IntHashtable();
        HashMap<String, PdfObject> hashMap = new HashMap<String, PdfObject>();
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList arrayList2 = pdfArray.getArrayList();
        for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
            PdfObject pdfObject5 = (PdfObject)arrayList2.get(i2);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfObject5);
            pdfObject4 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.PAGE));
            if (pdfObject4 == null || ((PdfNumber)pdfObject4).intValue() >= this.reader.getNumberOfPages()) continue;
            PdfStamperImp.findAllObjects(fdfReader, pdfObject5, intHashtable);
            arrayList.add(pdfObject5);
            if (pdfObject5.type() != 10 || (pdfObject3 = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.NM))) == null || pdfObject3.type() != 3) continue;
            hashMap.put(pdfObject3.toString(), pdfObject5);
        }
        int[] nArray = intHashtable.getKeys();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3 = nArray[n2];
            pdfObject4 = (PdfObject)fdfReader.xrefObj.get(n3);
            if (pdfObject4.type() == 6 && (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.IRT))) != null && pdfObject3.type() == 3 && (pdfObject2 = (PdfObject)hashMap.get(pdfObject3.toString())) != null) {
                pdfObject = new PdfDictionary();
                ((PdfDictionary)pdfObject).merge((PdfDictionary)pdfObject4);
                ((PdfDictionary)pdfObject).put(PdfName.IRT, pdfObject2);
                pdfObject4 = pdfObject;
            }
            this.addToBody(pdfObject4, this.getNewObjectNumber(fdfReader, n3, 0));
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            PdfObject pdfObject6 = (PdfObject)arrayList.get(n2);
            pdfObject4 = (PdfDictionary)PdfReader.getPdfObject(pdfObject6);
            pdfObject3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.PAGE));
            pdfObject2 = this.reader.getPageN(((PdfNumber)pdfObject3).intValue() + 1);
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS), pdfObject2);
            if (pdfObject == null) {
                pdfObject = new PdfArray();
                ((PdfDictionary)pdfObject2).put(PdfName.ANNOTS, pdfObject);
                this.markUsed(pdfObject2);
            }
            this.markUsed(pdfObject);
            ((PdfArray)pdfObject).add(pdfObject6);
        }
    }

    PageStamp getPageStamp(int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(pdfDictionary);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, pdfDictionary);
            this.pagesToContent.put(pdfDictionary, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n2) {
        if (n2 < 1 || n2 > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n2);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, pageStamp);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n2) {
        if (n2 < 1 || n2 > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n2);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, pageStamp);
        }
        return pageStamp.over;
    }

    void insertPage(int n2, Rectangle rectangle) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary;
        PRIndirectReference pRIndirectReference;
        PdfObject pdfObject;
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n3 = rectangle2.getRotation() % 360;
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.PAGE);
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        PdfArray pdfArray2 = new PdfArray();
        pdfArray2.add(PdfName.PDF);
        pdfArray2.add(PdfName.TEXT);
        pdfArray2.add(PdfName.IMAGEB);
        pdfArray2.add(PdfName.IMAGEC);
        pdfArray2.add(PdfName.IMAGEI);
        pdfDictionary3.put(PdfName.PROCSET, pdfArray2);
        pdfDictionary2.put(PdfName.RESOURCES, pdfDictionary3);
        pdfDictionary2.put(PdfName.ROTATE, new PdfNumber(n3));
        pdfDictionary2.put(PdfName.MEDIABOX, new PdfRectangle(rectangle2, n3));
        this.reader.xrefObj.add(pdfDictionary2);
        PRIndirectReference pRIndirectReference2 = new PRIndirectReference(this.reader, this.reader.xrefObj.size() - 1);
        if (n2 > this.reader.getNumberOfPages()) {
            int n4 = this.reader.pages.size() - 1;
            pdfObject = (PdfDictionary)this.reader.pages.get(n4);
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            pdfArray.add(pRIndirectReference2);
            this.markUsed(pdfArray);
            this.reader.pages.add(pdfDictionary2);
            this.reader.pageRefs.add(pRIndirectReference2);
        } else {
            if (--n2 < 0) {
                n2 = 0;
            }
            PdfDictionary pdfDictionary4 = (PdfDictionary)this.reader.pages.get(n2);
            pdfObject = (PRIndirectReference)this.reader.pageRefs.get(n2);
            pRIndirectReference = (PRIndirectReference)pdfDictionary4.get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ArrayList arrayList = pdfArray.getArrayList();
            int n5 = arrayList.size();
            int n6 = ((PdfIndirectReference)pdfObject).getNumber();
            for (int i2 = 0; i2 < n5; ++i2) {
                PRIndirectReference pRIndirectReference3 = (PRIndirectReference)arrayList.get(i2);
                if (n6 != pRIndirectReference3.getNumber()) continue;
                arrayList.add(i2, pRIndirectReference2);
                break;
            }
            if (n5 == arrayList.size()) {
                throw new RuntimeException("Internal inconsistence.");
            }
            this.markUsed(pdfArray);
            this.reader.pages.add(n2, pdfDictionary2);
            this.reader.pageRefs.add(n2, pRIndirectReference2);
        }
        pdfDictionary2.put(PdfName.PARENT, pRIndirectReference);
        while (pdfDictionary != null) {
            this.markUsed(pdfDictionary);
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.COUNT));
            pdfDictionary.put(PdfName.COUNT, new PdfNumber(pdfNumber.intValue() + 1));
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PARENT));
        }
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.append) {
            throw new IllegalArgumentException("Field flattening is not supported in append mode.");
        }
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object4 = hashMap.keySet().iterator();
            while (object4.hasNext()) {
                this.partialFlattening.add(object4.next());
            }
        }
        object4 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList arrayList = null;
        if (object4 != null && (object3 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.FIELDS), (PdfObject)object4)) != null) {
            arrayList = ((PdfArray)object3).getArrayList();
        }
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object2)) continue;
            object = (AcroFields.Item)hashMap.get(object2);
            for (int i2 = 0; i2 < ((AcroFields.Item)object).merged.size(); ++i2) {
                Object object5;
                Object object6;
                Object object7;
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary = (PdfDictionary)((AcroFields.Item)object).merged.get(i2);
                pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                int n2 = 0;
                if (pdfObject != null) {
                    n2 = ((PdfNumber)pdfObject).intValue();
                }
                int n3 = (Integer)((AcroFields.Item)object).page.get(i2);
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
                if (pdfDictionary2 != null && (n2 & 4) != 0 && (n2 & 2) == 0) {
                    Object object8;
                    pdfObject2 = pdfDictionary2.get(PdfName.N);
                    object7 = null;
                    object6 = PdfReader.getPdfObject(pdfObject2);
                    if (pdfObject2 instanceof PdfIndirectReference && !pdfObject2.isIndirect()) {
                        object7 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                    } else if (object6 instanceof PdfStream) {
                        ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                        object7 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                    } else if (((PdfObject)object6).isDictionary() && (object8 = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AS))) != null && (object5 = (PdfIndirectReference)((PdfDictionary)object6).get((PdfName)object8)) != null) {
                        object7 = new PdfAppearance((PdfIndirectReference)object5);
                        if (((PdfObject)object5).isIndirect()) {
                            object6 = PdfReader.getPdfObject((PdfObject)object5);
                            ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                        }
                    }
                    if (object7 != null) {
                        object8 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                        object5 = this.getOverContent(n3);
                        ((PdfContentByte)object5).setLiteral("Q ");
                        ((PdfContentByte)object5).addTemplate((PdfTemplate)object7, ((Rectangle)object8).left(), ((Rectangle)object8).bottom());
                        ((PdfContentByte)object5).setLiteral("q ");
                    }
                }
                if (this.partialFlattening.isEmpty() || (object7 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)(pdfObject2 = this.reader.getPageN(n3))).get(PdfName.ANNOTS))) == null) continue;
                object6 = ((PdfArray)object7).getArrayList();
                block3: for (int i3 = 0; i3 < ((ArrayList)object6).size(); ++i3) {
                    PdfObject pdfObject3;
                    object5 = (PdfObject)((ArrayList)object6).get(i3);
                    if (!((PdfObject)object5).isIndirect() || !(pdfObject3 = (PdfObject)((AcroFields.Item)object).widget_refs.get(i2)).isIndirect() || ((PRIndirectReference)object5).getNumber() != ((PRIndirectReference)pdfObject3).getNumber()) continue;
                    ((ArrayList)object6).remove(i3--);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject3;
                    while (true) {
                        PdfObject pdfObject4;
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary3.get(PdfName.PARENT);
                        PdfReader.killIndirect(pRIndirectReference);
                        if (pRIndirectReference2 == null) {
                            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                                pdfObject4 = (PdfObject)arrayList.get(i4);
                                if (!pdfObject4.isIndirect() || ((PRIndirectReference)pdfObject4).getNumber() != pRIndirectReference.getNumber()) continue;
                                arrayList.remove(i4);
                                --i4;
                            }
                            continue block3;
                        }
                        PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                        pdfObject4 = (PdfArray)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.KIDS));
                        ArrayList arrayList2 = ((PdfArray)pdfObject4).getArrayList();
                        for (int i5 = 0; i5 < arrayList2.size(); ++i5) {
                            PdfObject pdfObject5 = (PdfObject)arrayList2.get(i5);
                            if (!pdfObject5.isIndirect() || ((PRIndirectReference)pdfObject5).getNumber() != pRIndirectReference.getNumber()) continue;
                            arrayList2.remove(i5);
                            --i5;
                        }
                        if (!arrayList2.isEmpty()) continue block3;
                        pRIndirectReference = pRIndirectReference2;
                    }
                }
                if (((ArrayList)object6).size() != 0) continue;
                PdfReader.killIndirect(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS));
                ((PdfDictionary)pdfObject2).remove(PdfName.ANNOTS);
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (int i6 = 1; i6 <= this.reader.getNumberOfPages(); ++i6) {
                object2 = this.reader.getPageN(i6);
                object = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.ANNOTS));
                if (object == null) continue;
                ArrayList arrayList3 = ((PdfArray)object).getArrayList();
                for (int i7 = 0; i7 < arrayList3.size(); ++i7) {
                    PdfDictionary pdfDictionary;
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList3.get(i7));
                    if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !PdfName.WIDGET.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                    arrayList3.remove(i7);
                    --i7;
                }
                if (arrayList3.size() != 0) continue;
                PdfReader.killIndirect(((PdfDictionary)object2).get(PdfName.ANNOTS));
                ((PdfDictionary)object2).remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
        }
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (!pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            this.sweepKids((PdfObject)arrayList.get(i2));
        }
    }

    public PdfIndirectReference getPageReference(int n2) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n2);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n2);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    void addFieldResources() {
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM), pdfDictionary2);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
            this.markUsed(pdfDictionary2);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR), pdfDictionary3)) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
            this.markUsed(pdfDictionary3);
        }
        this.markUsed(pdfDictionary);
        Object object = this.fieldTemplates.keySet().iterator();
        while (object.hasNext()) {
            PdfTemplate pdfTemplate = (PdfTemplate)object.next();
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)pdfTemplate.getResources(), this);
        }
        object = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT));
        if (object != null && pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary3);
        }
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                this.expandFields((PdfFormField)arrayList2.get(i2), arrayList);
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, PdfDictionary pdfDictionary) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(i2);
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    pdfDictionary = this.reader.getPageN(pdfAnnotation.getPlaceInPage());
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS), pdfDictionary);
                    if (object == null) {
                        object = new PdfArray();
                        pdfDictionary.put(PdfName.ANNOTS, (PdfObject)object);
                        this.markUsed(pdfDictionary);
                    }
                    ((PdfArray)object).add(pdfAnnotation.getIndirectReference());
                    this.markUsed((PdfObject)object);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)).left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n2 = this.reader.getPageRotation(pdfDictionary);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
                        switch (n2) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.top() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.top() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.right() - pdfRectangle.left(), rectangle.top() - pdfRectangle.bottom(), rectangle.right() - pdfRectangle.right(), rectangle.top() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.right() - pdfRectangle.left(), pdfRectangle.top(), rectangle.right() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (pdfAnnotation.isUsed()) continue;
                pdfAnnotation.setUsed();
                this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n2) {
        this.addAnnotation(pdfAnnotation, this.reader.getPageN(n2));
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
        this.markUsed(pdfDictionary);
    }

    void setJavaScript() throws IOException {
        ArrayList arrayList = this.pdf.getDocumentJavaScript();
        if (arrayList.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        String string = String.valueOf(arrayList.size() - 1);
        int n2 = string.length();
        String string2 = "000000000000000";
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            string = String.valueOf(i2);
            string = string2.substring(0, n2 - string.length()) + string;
            hashMap.put(string, arrayList.get(i2));
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.size() == 0) {
            return;
        }
        this.namedAsNames = this.reader.getCatalog().get(PdfName.DESTS) != null;
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, this.namedAsNames);
        pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
        this.reader.getCatalog().put(PdfName.OUTLINES, pdfIndirectReference);
        this.markUsed(this.reader.getCatalog());
    }

    void setOutlines(List list) {
        this.newBookmarks = list;
    }

    public void setViewerPreferences(int n2) {
        this.useVp = true;
        this.vp |= n2;
    }

    public void setSigFlags(int n2) {
        this.sigFlags |= n2;
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction, int n2) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AA), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.AA, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        pdfDictionary2.put(pdfName, pdfAction);
        this.markUsed(pdfDictionary2);
    }

    public void setDuration(int n2) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setDuration(int n2, int n3) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n3);
        if (n2 < 0) {
            pdfDictionary.remove(PdfName.DUR);
        } else {
            pdfDictionary.put(PdfName.DUR, new PdfNumber(n2));
        }
        this.markUsed(pdfDictionary);
    }

    void setTransition(PdfTransition pdfTransition, int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        if (pdfTransition == null) {
            pdfDictionary.remove(PdfName.TRANS);
        } else {
            pdfDictionary.put(PdfName.TRANS, pdfTransition.getTransitionDictionary());
        }
        this.markUsed(pdfDictionary);
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    protected void markUsed(int n2) {
        if (this.append) {
            this.marked.put(n2, 1);
        }
    }

    boolean isAppend() {
        return this.append;
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.AA));
        if (pdfDictionary == null) {
            if (pdfAction == null) {
                return;
            }
            pdfDictionary = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, pdfDictionary);
        }
        this.markUsed(pdfDictionary);
        if (pdfAction == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, pdfAction);
        }
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.openAction = pdfAction;
    }

    public void setOpenAction(String string) {
        throw new UnsupportedOperationException("Open actions by name are not supported.");
    }

    static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, PdfDictionary pdfDictionary) {
            this.pageN = pdfDictionary;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

