/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;

public class PdfPatternPainter
extends PdfTemplate {
    protected float xstep;
    protected float ystep;
    protected boolean stencil = false;
    protected Color defaultColor;

    private PdfPatternPainter() {
        super(null);
        this.type = 3;
    }

    PdfPatternPainter(PdfWriter pdfWriter) {
        super(pdfWriter);
        this.type = 3;
    }

    PdfPatternPainter(PdfWriter pdfWriter, Color color) {
        this(pdfWriter);
        this.stencil = true;
        this.defaultColor = color == null ? Color.gray : color;
    }

    public void setXStep(float f2) {
        this.xstep = f2;
    }

    public void setYStep(float f2) {
        this.ystep = f2;
    }

    public float getXStep() {
        return this.xstep;
    }

    public float getYStep() {
        return this.ystep;
    }

    public boolean isStencil() {
        return this.stencil;
    }

    public void setPatternMatrix(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.setMatrix(f2, f3, f4, f5, f6, f7);
    }

    PdfPattern getPattern() {
        return new PdfPattern(this);
    }

    public PdfContentByte getDuplicate() {
        PdfPatternPainter pdfPatternPainter = new PdfPatternPainter();
        pdfPatternPainter.writer = this.writer;
        pdfPatternPainter.pdf = this.pdf;
        pdfPatternPainter.thisReference = this.thisReference;
        pdfPatternPainter.pageResources = this.pageResources;
        pdfPatternPainter.bBox = new Rectangle(this.bBox);
        pdfPatternPainter.xstep = this.xstep;
        pdfPatternPainter.ystep = this.ystep;
        pdfPatternPainter.matrix = this.matrix;
        pdfPatternPainter.stencil = this.stencil;
        pdfPatternPainter.defaultColor = this.defaultColor;
        return pdfPatternPainter;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setGrayFill(float f2) {
        this.checkNoColor();
        super.setGrayFill(f2);
    }

    public void resetGrayFill() {
        this.checkNoColor();
        super.resetGrayFill();
    }

    public void setGrayStroke(float f2) {
        this.checkNoColor();
        super.setGrayStroke(f2);
    }

    public void resetGrayStroke() {
        this.checkNoColor();
        super.resetGrayStroke();
    }

    public void setRGBColorFillF(float f2, float f3, float f4) {
        this.checkNoColor();
        super.setRGBColorFillF(f2, f3, f4);
    }

    public void resetRGBColorFill() {
        this.checkNoColor();
        super.resetRGBColorFill();
    }

    public void setRGBColorStrokeF(float f2, float f3, float f4) {
        this.checkNoColor();
        super.setRGBColorStrokeF(f2, f3, f4);
    }

    public void resetRGBColorStroke() {
        this.checkNoColor();
        super.resetRGBColorStroke();
    }

    public void setCMYKColorFillF(float f2, float f3, float f4, float f5) {
        this.checkNoColor();
        super.setCMYKColorFillF(f2, f3, f4, f5);
    }

    public void resetCMYKColorFill() {
        this.checkNoColor();
        super.resetCMYKColorFill();
    }

    public void setCMYKColorStrokeF(float f2, float f3, float f4, float f5) {
        this.checkNoColor();
        super.setCMYKColorStrokeF(f2, f3, f4, f5);
    }

    public void resetCMYKColorStroke() {
        this.checkNoColor();
        super.resetCMYKColorStroke();
    }

    public void addImage(Image image, float f2, float f3, float f4, float f5, float f6, float f7) throws DocumentException {
        if (this.stencil && !image.isMask()) {
            this.checkNoColor();
        }
        super.addImage(image, f2, f3, f4, f5, f6, f7);
    }

    public void setCMYKColorFill(int n2, int n3, int n4, int n5) {
        this.checkNoColor();
        super.setCMYKColorFill(n2, n3, n4, n5);
    }

    public void setCMYKColorStroke(int n2, int n3, int n4, int n5) {
        this.checkNoColor();
        super.setCMYKColorStroke(n2, n3, n4, n5);
    }

    public void setRGBColorFill(int n2, int n3, int n4) {
        this.checkNoColor();
        super.setRGBColorFill(n2, n3, n4);
    }

    public void setRGBColorStroke(int n2, int n3, int n4) {
        this.checkNoColor();
        super.setRGBColorStroke(n2, n3, n4);
    }

    public void setColorStroke(Color color) {
        this.checkNoColor();
        super.setColorStroke(color);
    }

    public void setColorFill(Color color) {
        this.checkNoColor();
        super.setColorFill(color);
    }

    public void setColorFill(PdfSpotColor pdfSpotColor, float f2) {
        this.checkNoColor();
        super.setColorFill(pdfSpotColor, f2);
    }

    public void setColorStroke(PdfSpotColor pdfSpotColor, float f2) {
        this.checkNoColor();
        super.setColorStroke(pdfSpotColor, f2);
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter) {
        this.checkNoColor();
        super.setPatternFill(pdfPatternPainter);
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter, Color color, float f2) {
        this.checkNoColor();
        super.setPatternFill(pdfPatternPainter, color, f2);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter, Color color, float f2) {
        this.checkNoColor();
        super.setPatternStroke(pdfPatternPainter, color, f2);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter) {
        this.checkNoColor();
        super.setPatternStroke(pdfPatternPainter);
    }

    void checkNoColor() {
        if (this.stencil) {
            throw new RuntimeException("Colors are not allowed in uncolored tile patterns.");
        }
    }
}

