/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;

public class PdfChunk
implements SplitCharacter {
    private static final char[] singleSpace = new char[]{' '};
    private static final PdfChunk[] thisChunk = new PdfChunk[1];
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    protected String value = "";
    protected String encoding = "Cp1252";
    protected PdfFont font;
    protected BaseFont baseFont;
    protected SplitCharacter splitCharacter;
    protected HashMap attributes = new HashMap();
    protected HashMap noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;

    PdfChunk(String string, PdfChunk pdfChunk) {
        PdfChunk.thisChunk[0] = this;
        this.value = string;
        this.font = pdfChunk.font;
        this.attributes = pdfChunk.attributes;
        this.noStroke = pdfChunk.noStroke;
        this.baseFont = pdfChunk.baseFont;
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        Object object;
        Object[] objectArray;
        PdfChunk.thisChunk[0] = this;
        this.value = chunk.content();
        Font font = chunk.font();
        float f2 = font.size();
        if (f2 == -1.0f) {
            f2 = 12.0f;
        }
        this.baseFont = font.getBaseFont();
        int n2 = font.style();
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.baseFont == null) {
            this.baseFont = font.getCalculatedBaseFont(false);
        } else {
            if ((n2 & 1) != 0) {
                this.attributes.put("TEXTRENDERMODE", new Object[]{new Integer(2), new Float(f2 / 30.0f), null});
            }
            if ((n2 & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new PdfFont(this.baseFont, f2);
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            objectArray = hashMap.keySet().iterator();
            while (objectArray.hasNext()) {
                object = objectArray.next();
                if (keysAttributes.containsKey(object)) {
                    this.attributes.put(object, hashMap.get(object));
                    continue;
                }
                if (!keysNoStroke.containsKey(object)) continue;
                this.noStroke.put(object, hashMap.get(object));
            }
            if ("".equals(hashMap.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.content());
            }
        }
        if (font.isUnderlined()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f}};
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (font.isStrikethru()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f}};
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.color());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.attributes.remove("HSCALE");
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.setImage(this.image);
        object = (Float)this.attributes.get("HSCALE");
        if (object != null) {
            this.font.setHorizontalScaling(((Float)object).floatValue());
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    public char getUnicodeEquivalent(char c2) {
        return this.baseFont.getUnicodeEquivalent(c2);
    }

    protected int getWord(String string, int n2) {
        int n3 = string.length();
        while (n2 < n3 && Character.isLetter(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    PdfChunk split(float f2) {
        Object object;
        char c2;
        int n2;
        this.newlineSplit = false;
        if (this.image != null) {
            if (this.image.scaledWidth() > f2) {
                PdfChunk pdfChunk = new PdfChunk("\ufffc", this);
                this.value = "";
                this.attributes = new HashMap();
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pdfChunk;
            }
            return null;
        }
        HyphenationEvent hyphenationEvent = (HyphenationEvent)this.noStroke.get("HYPHENATION");
        int n3 = -1;
        float f3 = 0.0f;
        int n4 = -1;
        float f4 = 0.0f;
        int n5 = this.value.length();
        char[] cArray = this.value.toCharArray();
        char c3 = '\u0000';
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            for (n2 = 0; n2 < n5; ++n2) {
                c2 = cArray[n2];
                c3 = baseFont.getUnicodeEquivalent(c2);
                if (c3 == '\n') {
                    this.newlineSplit = true;
                    String string = this.value.substring(n2 + 1);
                    this.value = this.value.substring(0, n2);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                f3 += this.font.width(c2);
                if (c3 == ' ') {
                    n4 = n2 + 1;
                    f4 = f3;
                }
                if (!(f3 > f2)) {
                    if (!this.splitCharacter.isSplitCharacter(0, n2, n5, cArray, thisChunk)) continue;
                    n3 = n2 + 1;
                    continue;
                }
                break;
            }
        } else {
            while (n2 < n5) {
                c3 = cArray[n2];
                if (c3 == '\r' || c3 == '\n') {
                    this.newlineSplit = true;
                    int n6 = 1;
                    if (c3 == '\r' && n2 + 1 < n5 && cArray[n2 + 1] == '\n') {
                        n6 = 2;
                    }
                    String string = this.value.substring(n2 + n6);
                    this.value = this.value.substring(0, n2);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                f3 += this.font.width(c3);
                if (c3 == ' ') {
                    n4 = n2 + 1;
                    f4 = f3;
                }
                if (!(f3 > f2)) {
                    if (this.splitCharacter.isSplitCharacter(0, n2, n5, cArray, null)) {
                        n3 = n2 + 1;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        if (n2 == n5) {
            return null;
        }
        if (n3 < 0) {
            String string = this.value;
            this.value = "";
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        if (n4 > n3 && this.splitCharacter.isSplitCharacter(0, 0, 1, singleSpace, null)) {
            n3 = n4;
        }
        if (hyphenationEvent != null && n4 < n2 && (c2 = this.getWord(this.value, n4)) > n4) {
            object = hyphenationEvent.getHyphenatedWordPre(this.value.substring(n4, c2), this.font.getFont(), this.font.size(), f2 - f4);
            String string = hyphenationEvent.getHyphenatedWordPost();
            if (((String)object).length() > 0) {
                String string2 = string + this.value.substring(c2);
                this.value = this.trim(this.value.substring(0, n4) + (String)object);
                PdfChunk pdfChunk = new PdfChunk(string2, this);
                return pdfChunk;
            }
        }
        String string = this.value.substring(n3);
        this.value = this.trim(this.value.substring(0, n3));
        object = new PdfChunk(string, this);
        return object;
    }

    PdfChunk truncate(float f2) {
        char c2;
        int n2;
        if (this.image != null) {
            if (this.image.scaledWidth() > f2) {
                PdfChunk pdfChunk = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pdfChunk;
            }
            return null;
        }
        float f3 = 0.0f;
        if (f2 < this.font.width()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        int n3 = this.value.length();
        for (n2 = 0; n2 < n3 && !((f3 += this.font.width(c2 = this.value.charAt(n2))) > f2); ++n2) {
        }
        if (n2 == n3) {
            return null;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        String string = this.value.substring(n2);
        this.value = this.value.substring(0, n2);
        PdfChunk pdfChunk = new PdfChunk(string, this);
        return pdfChunk;
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    float width() {
        return this.font.width(this.value);
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f2, float f3) {
        if (this.image != null) {
            return this.image.scaledWidth() + f2;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = this.value.indexOf(32, n3 + 1)) >= 0) {
            ++n2;
        }
        return this.width() + ((float)this.value.length() * f2 + (float)n2 * f3);
    }

    public float getTextRise() {
        Float f2 = (Float)this.getAttribute("SUBSUPSCRIPT");
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width('\u0001');
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(' ');
        }
        return 0.0f;
    }

    Object getAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    boolean isAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    boolean isStroked() {
        return this.attributes.size() > 0;
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    void setImageOffsetX(float f2) {
        this.offsetX = f2;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    void setImageOffsetY(float f2) {
        this.offsetY = f2;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }

    int length() {
        return this.value.length();
    }

    public boolean isSplitCharacter(int n2, int n3, int n4, char[] cArray, PdfChunk[] pdfChunkArray) {
        char c2 = pdfChunkArray == null ? cArray[n3] : pdfChunkArray[Math.min(n3, pdfChunkArray.length - 1)].getUnicodeEquivalent(cArray[n3]);
        if (c2 <= ' ' || c2 == '-') {
            return true;
        }
        if (c2 < '\u2e80') {
            return false;
        }
        return c2 >= '\u2e80' && c2 < '\ud7a0' || c2 >= '\uf900' && c2 < '\ufb00' || c2 >= '\ufe30' && c2 < '\ufe50' || c2 >= '\uff61' && c2 < '\uffa0';
    }

    boolean isExtSplitCharacter(int n2, int n3, int n4, char[] cArray, PdfChunk[] pdfChunkArray) {
        return this.splitCharacter.isSplitCharacter(n2, n3, n4, cArray, pdfChunkArray);
    }

    String trim(String string) {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            while (string.endsWith("\u0001")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            while (string.endsWith(" ") || string.endsWith("\t")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    float getCharWidth(char c2) {
        if (PdfChunk.noPrint(c2)) {
            return 0.0f;
        }
        return this.font.width(c2);
    }

    public static boolean noPrint(char c2) {
        return c2 >= '\u200b' && c2 <= '\u200f' || c2 >= '\u202a' && c2 <= '\u202e';
    }

    static {
        keysAttributes.put("ACTION", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysAttributes.put("SKEW", null);
        keysAttributes.put("HSCALE", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
        keysNoStroke.put("TEXTRENDERMODE", null);
    }
}

