/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeCodabar
extends Barcode {
    static byte[][] BARS = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 1}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 1, 1, 0}};
    static String CHARS = "0123456789-$:/.+ABCD";
    static final int START_STOP_IDX = 16;

    public BarcodeCodabar() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = false;
            this.codeType = 12;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getBarsCodabar(String string) {
        int n2 = (string = string.toUpperCase()).length();
        if (n2 < 2) {
            throw new IllegalArgumentException("Codabar must have at least a start and stop character.");
        }
        if (CHARS.indexOf(string.charAt(0)) < 16 || CHARS.indexOf(string.charAt(n2 - 1)) < 16) {
            throw new IllegalArgumentException("Codabar must have one of 'ABCD' as start/stop character.");
        }
        byte[] byArray = new byte[string.length() * 8 - 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = CHARS.indexOf(string.charAt(i2));
            if (n3 >= 16 && i2 > 0 && i2 < n2 - 1) {
                throw new IllegalArgumentException("In codabar, start/stop characters are only allowed at the extremes.");
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(i2) + "' is illegal in codabar.");
            }
            System.arraycopy(BARS[n3], 0, byArray, i2 * 8, 7);
        }
        return byArray;
    }

    public static String calculateChecksum(String string) {
        if (string.length() < 2) {
            return string;
        }
        String string2 = string.toUpperCase();
        int n2 = 0;
        int n3 = string2.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += CHARS.indexOf(string2.charAt(i2));
        }
        n2 = (n2 + 15) / 16 * 16 - n2;
        return string.substring(0, n3 - 1) + CHARS.charAt(n2) + string.substring(n3 - 1);
    }

    public Rectangle getBarcodeSize() {
        int n2;
        float f2 = 0.0f;
        float f3 = 0.0f;
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        string = this.code;
        if (this.generateChecksum) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(string);
        int n3 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n3 += byArray[n2];
        }
        n2 = byArray.length - n3;
        float f4 = this.x * ((float)n2 + (float)n3 * this.n);
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        int n2;
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.font.getWidthPoint(string, this.size);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int n3 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n3 += byArray[n2];
        }
        n2 = byArray.length - n3;
        float f3 = this.x * ((float)n2 + (float)n3 * this.n);
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            float f8;
            float f9 = f8 = byArray[i2] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f4, f6, f8 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f4 += f8;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3;
        int n4 = color.getRGB();
        int n5 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int n6 = 0;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n6 += byArray[n3];
        }
        n3 = byArray.length - n6;
        int n7 = n3 + n6 * (int)this.n;
        boolean bl = true;
        int n8 = 0;
        int n9 = (int)this.barHeight;
        int[] nArray = new int[n7 * n9];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n10 = byArray[n2] == 0 ? 1 : (int)this.n;
            int n11 = n5;
            if (bl) {
                n11 = n4;
            }
            bl = !bl;
            for (int i2 = 0; i2 < n10; ++i2) {
                nArray[n8++] = n11;
            }
        }
        for (n2 = n7; n2 < nArray.length; n2 += n7) {
            System.arraycopy(nArray, 0, nArray, n2, n7);
        }
        Image image = canvas.createImage(new MemoryImageSource(n7, n9, nArray, 0, n7));
        return image;
    }
}

