/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Graphic;
import com.lowagie.text.List;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.SpecialSymbol;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class Phrase
extends ArrayList
implements TextElementArray,
MarkupAttributes {
    protected float leading = Float.NaN;
    protected Font font = new Font();
    protected Properties markupAttributes;

    private Phrase(boolean bl) {
    }

    public Phrase() {
        this(16.0f);
    }

    public Phrase(float f2) {
        this.leading = f2;
    }

    public Phrase(Chunk chunk) {
        super.add(chunk);
    }

    public Phrase(float f2, Chunk chunk) {
        this(f2);
        super.add(chunk);
    }

    public Phrase(String string) {
        this(Float.NaN, string, new Font());
    }

    public Phrase(String string, Font font) {
        this(Float.NaN, string, font);
        this.font = font;
    }

    public Phrase(float f2, String string) {
        this(f2, string, new Font());
    }

    public Phrase(float f2, String string, Font font) {
        this(f2);
        this.font = font;
        if (string != null && string.length() != 0) {
            super.add(new Chunk(string, font));
        }
    }

    public static final Phrase getInstance(String string) {
        return Phrase.getInstance(16, string, new Font());
    }

    public static final Phrase getInstance(int n2, String string) {
        return Phrase.getInstance(n2, string, new Font());
    }

    public static final Phrase getInstance(int n2, String string, Font font) {
        Phrase phrase = new Phrase(true);
        phrase.setLeading(n2);
        phrase.font = font;
        if (font.family() != 3 && font.family() != 4 && font.getBaseFont() == null) {
            int n3;
            while ((n3 = SpecialSymbol.index(string)) > -1) {
                Object object;
                if (n3 > 0) {
                    object = string.substring(0, n3);
                    ((ArrayList)phrase).add(new Chunk((String)object, font));
                    string = string.substring(n3);
                }
                object = new Font(3, font.size(), font.style(), font.color());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                string = string.substring(1);
                while (SpecialSymbol.index(string) == 0) {
                    stringBuffer.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                    string = string.substring(1);
                }
                ((ArrayList)phrase).add(new Chunk(stringBuffer.toString(), (Font)object));
            }
        }
        if (string != null && string.length() != 0) {
            ((ArrayList)phrase).add(new Chunk(string, font));
        }
        return phrase;
    }

    public Phrase(Properties properties) {
        this("", FontFactory.getFont(properties));
        this.clear();
        String string = (String)properties.remove("leading");
        if (string != null) {
            this.setLeading(Float.valueOf(string + "f").floatValue());
        } else {
            string = (String)properties.remove("line-height");
            if (string != null) {
                this.setLeading(MarkupParser.parseLength(string));
            }
        }
        string = (String)properties.remove("itext");
        if (string != null) {
            Chunk chunk = new Chunk(string);
            string = (String)properties.remove(ElementTags.GENERICTAG);
            if (string != null) {
                chunk.setGenericTag(string);
            }
            this.add(chunk);
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 11;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void add(int n2, Object object) {
        block5: {
            try {
                Element element = (Element)object;
                if (element.type() == 10) {
                    Chunk chunk = (Chunk)element;
                    if (!this.font.isStandardFont()) {
                        chunk.setFont(this.font.difference(chunk.font()));
                    }
                    super.add(n2, chunk);
                    break block5;
                }
                if (element.type() == 11 || element.type() == 17 || element.type() == 29 || element.type() == 22 || element.type() == 39) {
                    super.add(n2, element);
                    break block5;
                }
                throw new ClassCastException(String.valueOf(element.type()));
            }
            catch (ClassCastException classCastException) {
                throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
            }
        }
    }

    public boolean add(Object object) {
        if (object instanceof String) {
            return super.add(new Chunk((String)object, this.font));
        }
        try {
            Element element = (Element)object;
            switch (element.type()) {
                case 10: {
                    return this.addChunk((Chunk)object);
                }
                case 11: 
                case 12: {
                    Phrase phrase = (Phrase)object;
                    boolean bl = true;
                    Iterator iterator = phrase.iterator();
                    while (iterator.hasNext()) {
                        Element element2 = (Element)iterator.next();
                        if (element2 instanceof Chunk) {
                            bl &= this.addChunk((Chunk)element2);
                            continue;
                        }
                        bl &= this.add(element2);
                    }
                    return bl;
                }
                case 17: {
                    return super.add((Anchor)object);
                }
                case 29: {
                    return super.add((Annotation)object);
                }
                case 22: {
                    return super.add((Table)object);
                }
                case 14: {
                    return super.add((List)object);
                }
                case 39: {
                    return super.add((Graphic)object);
                }
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    private synchronized boolean addChunk(Chunk chunk) {
        if (!this.font.isStandardFont()) {
            chunk.setFont(this.font.difference(chunk.font()));
        }
        if (this.size() > 0 && !chunk.hasAttributes()) {
            try {
                Chunk chunk2 = (Chunk)this.get(this.size() - 1);
                if (!(chunk2.hasAttributes() || chunk2.font().compareTo(chunk.font()) != 0 || "".equals(chunk2.content().trim()) || "".equals(chunk.content().trim()))) {
                    chunk2.append(chunk.content());
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return super.add(chunk);
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    protected void addSpecial(Object object) {
        super.add(object);
    }

    public void setLeading(float f2) {
        this.leading = f2;
    }

    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.get(0);
                return element.type() == 10 && ((Chunk)element).isEmpty();
            }
        }
        return false;
    }

    public boolean leadingDefined() {
        return !Float.isNaN(this.leading);
    }

    public float leading() {
        if (Float.isNaN(this.leading)) {
            return this.font.leading(1.5f);
        }
        return this.leading;
    }

    public Font font() {
        return this.font;
    }

    public static boolean isTag(String string) {
        return "phrase".equals(string);
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

