/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.util.Properties;

public class Paragraph
extends Phrase
implements TextElementArray,
MarkupAttributes {
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    protected float spacingBefore;
    protected float spacingAfter;
    protected boolean keeptogether = false;
    protected float multipliedLeading = 0.0f;
    private float firstLineIndent = 0.0f;
    private float extraParagraphSpace = 0.0f;

    public Paragraph() {
    }

    public Paragraph(float f2) {
        super(f2);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float f2, Chunk chunk) {
        super(f2, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float f2, String string) {
        super(f2, string);
    }

    public Paragraph(float f2, String string, Font font) {
        super(f2, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase.leading, "", phrase.font());
        super.add(phrase);
    }

    public Paragraph(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string = (String)properties.remove("itext");
        if (string != null) {
            Chunk chunk = new Chunk(string);
            string = (String)properties.remove(ElementTags.GENERICTAG);
            if (string != null) {
                chunk.setGenericTag(string);
            }
            this.add(chunk);
        }
        if ((string = (String)properties.remove("align")) != null) {
            this.setAlignment(string);
        }
        if ((string = (String)properties.remove("leading")) != null) {
            this.setLeading(Float.valueOf(string + "f").floatValue());
        } else {
            string = (String)properties.remove("line-height");
            if (string != null) {
                this.setLeading(MarkupParser.parseLength(string));
            } else {
                this.setLeading(16.0f);
            }
        }
        string = (String)properties.remove("indentationleft");
        if (string != null) {
            this.setIndentationLeft(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("keeptogether")) != null) {
            this.keeptogether = new Boolean(string);
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public int type() {
        return 12;
    }

    public boolean add(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            list.setIndentationLeft(list.indentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (object instanceof Image) {
            super.addSpecial((Image)object);
            return true;
        }
        if (object instanceof Paragraph) {
            super.add(object);
            super.add(Chunk.NEWLINE);
            return true;
        }
        return super.add(object);
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public void setAlignment(String string) {
        if ("Center".equalsIgnoreCase(string)) {
            this.alignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(string)) {
            this.alignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(string)) {
            this.alignment = 3;
            return;
        }
        if ("JustifyAll".equalsIgnoreCase(string)) {
            this.alignment = 8;
            return;
        }
        this.alignment = 0;
    }

    public void setIndentationLeft(float f2) {
        this.indentationLeft = f2;
    }

    public void setIndentationRight(float f2) {
        this.indentationRight = f2;
    }

    public void setSpacingBefore(float f2) {
        this.spacingBefore = f2;
    }

    public void setSpacingAfter(float f2) {
        this.spacingAfter = f2;
    }

    public void setKeepTogether(boolean bl) {
        this.keeptogether = bl;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int alignment() {
        return this.alignment;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public static boolean isTag(String string) {
        return "paragraph".equals(string);
    }

    public void setLeading(float f2, float f3) {
        this.leading = f2;
        this.multipliedLeading = f3;
    }

    public void setLeading(float f2) {
        this.leading = f2;
        this.multipliedLeading = 0.0f;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public void setFirstLineIndent(float f2) {
        this.firstLineIndent = f2;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f2) {
        this.extraParagraphSpace = f2;
    }
}

