/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.FontFactory;
import com.lowagie.text.ListItem;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class List
implements TextElementArray,
MarkupAttributes {
    protected ArrayList list = new ArrayList();
    protected boolean numbered;
    protected boolean lettered;
    protected int first = 1;
    protected char firstCh = (char)65;
    protected char lastCh = (char)90;
    protected Chunk symbol = new Chunk("-");
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected float symbolIndent;
    protected Properties markupAttributes;

    public List(boolean bl, float f2) {
        this.numbered = bl;
        this.lettered = false;
        this.symbolIndent = f2;
    }

    public List(boolean bl, boolean bl2, float f2) {
        this.numbered = bl;
        this.lettered = bl2;
        this.symbolIndent = f2;
    }

    public List(Properties properties) {
        String string = (String)properties.remove("listsymbol");
        if (string == null) {
            string = "-";
        }
        this.symbol = new Chunk(string, FontFactory.getFont(properties));
        this.numbered = false;
        string = (String)properties.remove("numbered");
        if (string != null) {
            this.numbered = new Boolean(string);
            if (this.lettered && this.numbered) {
                this.lettered = false;
            }
        }
        if ((string = (String)properties.remove("lettered")) != null) {
            this.lettered = new Boolean(string);
            if (this.numbered && this.lettered) {
                this.numbered = false;
            }
        }
        this.symbolIndent = 0.0f;
        string = (String)properties.remove("symbolindent");
        if (string != null) {
            this.symbolIndent = Integer.parseInt(string);
        }
        if ((string = (String)properties.remove("first")) != null) {
            char c2 = string.charAt(0);
            if (Character.isLetter(c2)) {
                this.setFirst(c2);
            } else {
                this.setFirst(Integer.parseInt(string));
            }
        }
        if ((string = (String)properties.remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(string + "f").floatValue());
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 14;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public boolean add(Object object) {
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            if (this.numbered || this.lettered) {
                Chunk chunk = this.numbered ? new Chunk(String.valueOf(this.first + this.list.size()), this.symbol.font()) : new Chunk(this.nextLetter(), this.symbol.font());
                chunk.append(".");
                listItem.setListSymbol(chunk);
            } else {
                listItem.setListSymbol(this.symbol);
            }
            listItem.setIndentationLeft(this.symbolIndent);
            listItem.setIndentationRight(0.0f);
            this.list.add(listItem);
        } else {
            if (object instanceof List) {
                List list = (List)object;
                list.setIndentationLeft(list.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(list);
            }
            if (object instanceof String) {
                return this.add(new ListItem((String)object));
            }
        }
        return false;
    }

    public void setIndentationLeft(float f2) {
        this.indentationLeft = f2;
    }

    public void setIndentationRight(float f2) {
        this.indentationRight = f2;
    }

    public void setFirst(int n2) {
        this.first = n2;
    }

    public void setFirst(char c2) {
        this.firstCh = c2;
        this.lastCh = Character.isLowerCase(this.firstCh) ? (char)122 : (char)90;
    }

    public void setListSymbol(Chunk chunk) {
        this.symbol = chunk;
    }

    public void setListSymbol(String string) {
        this.symbol = new Chunk(string);
    }

    public ArrayList getItems() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public float leading() {
        if (this.list.size() < 1) {
            return -1.0f;
        }
        ListItem listItem = (ListItem)this.list.get(0);
        return listItem.leading();
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public float symbolIndent() {
        return this.symbolIndent;
    }

    public Chunk symbol() {
        return this.symbol;
    }

    public int first() {
        return this.first;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public static boolean isSymbol(String string) {
        return "listsymbol".equals(string);
    }

    public static boolean isTag(String string) {
        return "list".equals(string);
    }

    private String nextLetter() {
        int n2;
        int n3 = this.listItemsInList();
        int n4 = this.lastCh + '\u0000';
        for (n2 = this.firstCh + n3; n2 > n4; n2 -= 26) {
        }
        char[] cArray = new char[]{(char)n2};
        String string = new String(cArray);
        return string;
    }

    private int listItemsInList() {
        int n2 = 0;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof List) continue;
            ++n2;
        }
        return n2;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

