/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.ImgCCITT;
import com.lowagie.text.ImgPostscript;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Jpeg;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.BmpImage;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import com.lowagie.text.pdf.codec.GifImage;
import com.lowagie.text.pdf.codec.PngImage;
import com.lowagie.text.pdf.codec.TiffImage;
import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;

public abstract class Image
extends Rectangle
implements Element,
MarkupAttributes {
    public static final int DEFAULT = 0;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int TEXTWRAP = 4;
    public static final int UNDERLYING = 8;
    public static final int AX = 0;
    public static final int AY = 1;
    public static final int BX = 2;
    public static final int BY = 3;
    public static final int CX = 4;
    public static final int CY = 5;
    public static final int DX = 6;
    public static final int DY = 7;
    public static final int ORIGINAL_NONE = 0;
    public static final int ORIGINAL_JPEG = 1;
    public static final int ORIGINAL_PNG = 2;
    public static final int ORIGINAL_GIF = 3;
    public static final int ORIGINAL_BMP = 4;
    public static final int ORIGINAL_TIFF = 5;
    public static final int ORIGINAL_WMF = 6;
    public static final int ORIGINAL_PS = 7;
    protected boolean invert = false;
    protected int type;
    protected URL url;
    protected byte[] rawData;
    protected PdfTemplate[] template = new PdfTemplate[1];
    protected int alignment;
    protected String alt;
    protected float absoluteX = Float.NaN;
    protected float absoluteY = Float.NaN;
    protected float plainWidth;
    protected float plainHeight;
    protected float scaledWidth;
    protected float scaledHeight;
    protected float rotation;
    protected int colorspace = -1;
    protected int bpc = 1;
    protected int[] transparency;
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected Long mySerialId = Image.getSerialId();
    static long serialId = 0L;
    protected int dpiX = 0;
    protected int dpiY = 0;
    protected boolean mask = false;
    protected Image imageMask;
    protected boolean interpolation;
    protected Annotation annotation = null;
    protected Properties markupAttributes;
    protected ICC_Profile profile = null;
    protected boolean deflated = false;
    private PdfDictionary additional = null;
    private boolean smask;
    private float XYRatio = 0.0f;
    protected int originalType = 0;
    protected byte[] originalData;
    protected float spacingBefore;
    protected float spacingAfter;
    private float widthPercentage = 100.0f;
    protected PdfOCG layer;
    static /* synthetic */ Class class$com$lowagie$text$Image;

    public Image(URL uRL) {
        super(0.0f, 0.0f);
        this.url = uRL;
        this.alignment = 0;
        this.rotation = 0.0f;
    }

    protected Image(Image image) {
        super(image);
        this.type = image.type;
        this.url = image.url;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.absoluteX = image.absoluteX;
        this.absoluteY = image.absoluteY;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.scaledWidth = image.scaledWidth;
        this.scaledHeight = image.scaledHeight;
        this.rotation = image.rotation;
        this.colorspace = image.colorspace;
        this.rawData = image.rawData;
        this.template = image.template;
        this.bpc = image.bpc;
        this.transparency = image.transparency;
        this.mySerialId = image.mySerialId;
        this.invert = image.invert;
        this.dpiX = image.dpiX;
        this.dpiY = image.dpiY;
        this.mask = image.mask;
        this.imageMask = image.imageMask;
        this.interpolation = image.interpolation;
        this.annotation = image.annotation;
        this.markupAttributes = image.markupAttributes;
        this.profile = image.profile;
        this.deflated = image.deflated;
        this.additional = image.additional;
        this.smask = image.smask;
        this.XYRatio = image.XYRatio;
        this.originalData = image.originalData;
        this.originalType = image.originalType;
        this.spacingAfter = image.spacingAfter;
        this.spacingBefore = image.spacingBefore;
        this.widthPercentage = image.widthPercentage;
        this.layer = image.layer;
    }

    public static Image getInstance(Image image) {
        if (image == null) {
            return null;
        }
        try {
            Class<?> clazz = image.getClass();
            Constructor<?> constructor = clazz.getDeclaredConstructor(class$com$lowagie$text$Image == null ? (class$com$lowagie$text$Image = Image.class$("com.lowagie.text.Image")) : class$com$lowagie$text$Image);
            return (Image)constructor.newInstance(image);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getInstance(URL uRL) throws BadElementException, MalformedURLException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            inputStream.close();
            inputStream = null;
            if (n2 == 71 && n3 == 73 && n4 == 70) {
                Image image;
                GifImage gifImage = new GifImage(uRL);
                Image image2 = image = gifImage.getImage(1);
                return image2;
            }
            if (n2 == 255 && n3 == 216) {
                Jpeg jpeg = new Jpeg(uRL);
                return jpeg;
            }
            if (n2 == PngImage.PNGID[0] && n3 == PngImage.PNGID[1] && n4 == PngImage.PNGID[2] && n5 == PngImage.PNGID[3]) {
                Image image = PngImage.getImage(uRL);
                return image;
            }
            if (n2 == 37 && n3 == 33 && n4 == 80 && n5 == 83) {
                ImgPostscript imgPostscript = new ImgPostscript(uRL);
                return imgPostscript;
            }
            if (n2 == 215 && n3 == 205) {
                ImgWMF imgWMF = new ImgWMF(uRL);
                return imgWMF;
            }
            if (n2 == 66 && n3 == 77) {
                Image image = BmpImage.getImage(uRL);
                return image;
            }
            if (n2 == 77 && n3 == 77 && n4 == 0 && n5 == 42 || n2 == 73 && n3 == 73 && n4 == 42 && n5 == 0) {
                RandomAccessFileOrArray randomAccessFileOrArray = null;
                try {
                    Object object;
                    if (uRL.getProtocol().equals("file")) {
                        object = uRL.getFile();
                        randomAccessFileOrArray = new RandomAccessFileOrArray((String)object);
                    } else {
                        randomAccessFileOrArray = new RandomAccessFileOrArray(uRL);
                    }
                    object = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
                    ((Image)object).url = uRL;
                    Object object2 = object;
                    return object2;
                }
                finally {
                    if (randomAccessFileOrArray != null) {
                        randomAccessFileOrArray.close();
                    }
                }
            }
            throw new IOException(uRL.toString() + " is not a recognized imageformat.");
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getInstance(byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n2 = ((InputStream)byteArrayInputStream).read();
            int n3 = ((InputStream)byteArrayInputStream).read();
            int n4 = ((InputStream)byteArrayInputStream).read();
            int n5 = ((InputStream)byteArrayInputStream).read();
            ((InputStream)byteArrayInputStream).close();
            byteArrayInputStream = null;
            if (n2 == 71 && n3 == 73 && n4 == 70) {
                GifImage gifImage = new GifImage(byArray);
                Image image = gifImage.getImage(1);
                return image;
            }
            if (n2 == 255 && n3 == 216) {
                Jpeg jpeg = new Jpeg(byArray);
                return jpeg;
            }
            if (n2 == PngImage.PNGID[0] && n3 == PngImage.PNGID[1] && n4 == PngImage.PNGID[2] && n5 == PngImage.PNGID[3]) {
                Image image = PngImage.getImage(byArray);
                return image;
            }
            if (n2 == 37 && n3 == 33 && n4 == 80 && n5 == 83) {
                ImgPostscript imgPostscript = new ImgPostscript(byArray);
                return imgPostscript;
            }
            if (n2 == 215 && n3 == 205) {
                ImgWMF imgWMF = new ImgWMF(byArray);
                return imgWMF;
            }
            if (n2 == 66 && n3 == 77) {
                Image image = BmpImage.getImage(byArray);
                return image;
            }
            if (n2 == 77 && n3 == 77 && n4 == 0 && n5 == 42 || n2 == 73 && n3 == 73 && n4 == 42 && n5 == 0) {
                RandomAccessFileOrArray randomAccessFileOrArray = null;
                try {
                    randomAccessFileOrArray = new RandomAccessFileOrArray(byArray);
                    Image image = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
                    image.setOriginalData(byArray);
                    Image image2 = image;
                    return image2;
                }
                finally {
                    if (randomAccessFileOrArray != null) {
                        randomAccessFileOrArray.close();
                    }
                }
            }
            throw new IOException("The byte array is not a recognized imageformat.");
        }
        finally {
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
    }

    public static Image getInstance(java.awt.Image image, Color color, boolean bl) throws BadElementException, IOException {
        int n2;
        int n3;
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("java.awt.Image Interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("java.awt.Image fetch aborted or errored");
        }
        int n4 = pixelGrabber.getWidth();
        int n5 = pixelGrabber.getHeight();
        int[] nArray = (int[])pixelGrabber.getPixels();
        if (bl) {
            int n6 = n4 / 8 + ((n4 & 7) != 0 ? 1 : 0);
            byte[] byArray = new byte[n6 * n5];
            int n7 = 0;
            int n8 = n5 * n4;
            boolean bl2 = true;
            if (color != null) {
                bl2 = color.getRed() + color.getGreen() + color.getBlue() >= 384;
            }
            int[] nArray2 = null;
            int n9 = 128;
            int n10 = 0;
            int n11 = 0;
            if (color != null) {
                for (int i2 = 0; i2 < n8; ++i2) {
                    int n12 = nArray[i2] >> 24 & 0xFF;
                    if (n12 < 250) {
                        if (bl2) {
                            n11 |= n9;
                        }
                    } else if ((nArray[i2] & 0x888) != 0) {
                        n11 |= n9;
                    }
                    if ((n9 >>= 1) == 0 || n10 + 1 >= n4) {
                        byArray[n7++] = (byte)n11;
                        n9 = 128;
                        n11 = 0;
                    }
                    if (++n10 < n4) continue;
                    n10 = 0;
                }
            } else {
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n13;
                    if (nArray2 == null && (n13 = nArray[i3] >> 24 & 0xFF) == 0) {
                        nArray2 = new int[2];
                        nArray2[1] = (nArray[i3] & 0x888) != 0 ? 1 : 0;
                        nArray2[0] = nArray2[1];
                    }
                    if ((nArray[i3] & 0x888) != 0) {
                        n11 |= n9;
                    }
                    if ((n9 >>= 1) == 0 || n10 + 1 >= n4) {
                        byArray[n7++] = (byte)n11;
                        n9 = 128;
                        n11 = 0;
                    }
                    if (++n10 < n4) continue;
                    n10 = 0;
                }
            }
            return Image.getInstance(n4, n5, 1, 1, byArray, nArray2);
        }
        byte[] byArray = new byte[n4 * n5 * 3];
        byte[] byArray2 = null;
        int n14 = 0;
        int n15 = n5 * n4;
        int n16 = 255;
        int n17 = 255;
        int n18 = 255;
        if (color != null) {
            n16 = color.getRed();
            n17 = color.getGreen();
            n18 = color.getBlue();
        }
        int[] nArray3 = null;
        if (color != null) {
            for (n3 = 0; n3 < n15; ++n3) {
                n2 = nArray[n3] >> 24 & 0xFF;
                if (n2 < 250) {
                    byArray[n14++] = (byte)n16;
                    byArray[n14++] = (byte)n17;
                    byArray[n14++] = (byte)n18;
                    continue;
                }
                byArray[n14++] = (byte)(nArray[n3] >> 16 & 0xFF);
                byArray[n14++] = (byte)(nArray[n3] >> 8 & 0xFF);
                byArray[n14++] = (byte)(nArray[n3] & 0xFF);
            }
        } else {
            n3 = 0;
            byArray2 = new byte[n4 * n5];
            n2 = 0;
            for (int i4 = 0; i4 < n15; ++i4) {
                byte by = byArray2[i4] = (byte)(nArray[i4] >> 24 & 0xFF);
                if (n2 == 0) {
                    if (by != 0 && by != -1) {
                        n2 = 1;
                    } else if (nArray3 == null) {
                        if (by == 0) {
                            n3 = nArray[i4] & 0xFFFFFF;
                            nArray3 = new int[6];
                            nArray3[0] = nArray3[1] = n3 >> 16 & 0xFF;
                            nArray3[2] = nArray3[3] = n3 >> 8 & 0xFF;
                            nArray3[4] = nArray3[5] = n3 & 0xFF;
                        }
                    } else if ((nArray[i4] & 0xFFFFFF) != n3) {
                        n2 = 1;
                    }
                }
                byArray[n14++] = (byte)(nArray[i4] >> 16 & 0xFF);
                byArray[n14++] = (byte)(nArray[i4] >> 8 & 0xFF);
                byArray[n14++] = (byte)(nArray[i4] & 0xFF);
            }
            if (n2 != 0) {
                nArray3 = null;
            } else {
                byArray2 = null;
            }
        }
        Image image2 = Image.getInstance(n4, n5, 3, 8, byArray, nArray3);
        if (byArray2 != null) {
            Image image3 = Image.getInstance(n4, n5, 1, 8, byArray2);
            try {
                image3.makeMask();
                image2.setImageMask(image3);
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        return image2;
    }

    public static Image getInstance(java.awt.Image image, Color color) throws BadElementException, IOException {
        return Image.getInstance(image, color, false);
    }

    public static Image getInstance(String string) throws BadElementException, MalformedURLException, IOException {
        return Image.getInstance(Image.toURL(string));
    }

    public static Image getInstance(int n2, int n3, int n4, int n5, byte[] byArray) throws BadElementException {
        return Image.getInstance(n2, n3, n4, n5, byArray, null);
    }

    public static Image getInstance(PdfTemplate pdfTemplate) throws BadElementException {
        return new ImgTemplate(pdfTemplate);
    }

    public static Image getInstance(int n2, int n3, boolean bl, int n4, int n5, byte[] byArray) throws BadElementException {
        return Image.getInstance(n2, n3, bl, n4, n5, byArray, null);
    }

    public static Image getInstance(int n2, int n3, boolean bl, int n4, int n5, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != 2) {
            throw new BadElementException("Transparency length must be equal to 2 with CCITT images");
        }
        ImgCCITT imgCCITT = new ImgCCITT(n2, n3, bl, n4, n5, byArray);
        imgCCITT.transparency = nArray;
        return imgCCITT;
    }

    public static Image getInstance(int n2, int n3, int n4, int n5, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != n4 * 2) {
            throw new BadElementException("Transparency length must be equal to (componentes * 2)");
        }
        if (n4 == 1 && n5 == 1) {
            byte[] byArray2 = CCITTG4Encoder.compress(byArray, n2, n3);
            return Image.getInstance(n2, n3, false, 256, 1, byArray2, nArray);
        }
        ImgRaw imgRaw = new ImgRaw(n2, n3, n4, n5, byArray);
        imgRaw.transparency = nArray;
        return imgRaw;
    }

    public static Image getInstance(Properties properties) throws BadElementException, MalformedURLException, IOException {
        String string;
        String string2;
        String string3 = (String)properties.remove("url");
        if (string3 == null) {
            throw new MalformedURLException("The URL of the image is missing.");
        }
        Image image = Image.getInstance(string3);
        int n2 = 0;
        string3 = (String)properties.remove("align");
        if (string3 != null) {
            if ("Left".equalsIgnoreCase(string3)) {
                n2 |= 0;
            } else if ("Right".equalsIgnoreCase(string3)) {
                n2 |= 2;
            } else if ("Middle".equalsIgnoreCase(string3)) {
                n2 |= 1;
            }
        }
        if ((string3 = (String)properties.remove("underlying")) != null && new Boolean(string3).booleanValue()) {
            n2 |= 8;
        }
        if ((string3 = (String)properties.remove("textwrap")) != null && new Boolean(string3).booleanValue()) {
            n2 |= 4;
        }
        image.setAlignment(n2);
        string3 = (String)properties.remove("alt");
        if (string3 != null) {
            image.setAlt(string3);
        }
        if ((string2 = (String)properties.remove("absolutex")) != null && (string = (String)properties.remove("absolutey")) != null) {
            image.setAbsolutePosition(Float.valueOf(string2 + "f").floatValue(), Float.valueOf(string + "f").floatValue());
        }
        if ((string3 = (String)properties.remove("plainwidth")) != null) {
            image.scaleAbsoluteWidth(Float.valueOf(string3 + "f").floatValue());
        }
        if ((string3 = (String)properties.remove("plainheight")) != null) {
            image.scaleAbsoluteHeight(Float.valueOf(string3 + "f").floatValue());
        }
        if ((string3 = (String)properties.remove("rotation")) != null) {
            image.setRotation(Float.valueOf(string3 + "f").floatValue());
        }
        if (properties.size() > 0) {
            image.setMarkupAttributes(properties);
        }
        return image;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public void setAbsolutePosition(float f2, float f3) {
        this.absoluteX = f2;
        this.absoluteY = f3;
    }

    public void scaleAbsolute(float f2, float f3) {
        this.plainWidth = f2;
        this.plainHeight = f3;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteWidth(float f2) {
        this.plainWidth = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteHeight(float f2) {
        this.plainHeight = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scalePercent(float f2) {
        this.scalePercent(f2, f2);
    }

    public void scalePercent(float f2, float f3) {
        this.plainWidth = this.width() * f2 / 100.0f;
        this.plainHeight = this.height() * f3 / 100.0f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleToFit(float f2, float f3) {
        float f4;
        float f5 = f2 * 100.0f / this.width();
        this.scalePercent(f5 < (f4 = f3 * 100.0f / this.height()) ? f5 : f4);
    }

    public void setRotation(float f2) {
        double d2 = Math.PI;
        this.rotation = (float)((double)f2 % (2.0 * d2));
        if (this.rotation < 0.0f) {
            this.rotation = (float)((double)this.rotation + 2.0 * d2);
        }
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void setRotationDegrees(float f2) {
        double d2 = Math.PI;
        this.setRotation(f2 / 180.0f * (float)d2);
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public Annotation annotation() {
        return this.annotation;
    }

    public int bpc() {
        return this.bpc;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public PdfTemplate templateData() {
        return this.template[0];
    }

    public void setTemplateData(PdfTemplate pdfTemplate) {
        this.template[0] = pdfTemplate;
    }

    public boolean hasAbsolutePosition() {
        return !Float.isNaN(this.absoluteY);
    }

    public boolean hasAbsoluteX() {
        return !Float.isNaN(this.absoluteX);
    }

    public float absoluteX() {
        return this.absoluteX;
    }

    public float absoluteY() {
        return this.absoluteY;
    }

    public int type() {
        return this.type;
    }

    public boolean isJpeg() {
        return this.type == 32;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public boolean isImgTemplate() {
        return this.type == 35;
    }

    public URL url() {
        return this.url;
    }

    public int alignment() {
        return this.alignment;
    }

    public String alt() {
        return this.alt;
    }

    public float scaledWidth() {
        return this.scaledWidth;
    }

    public float scaledHeight() {
        return this.scaledHeight;
    }

    public int colorspace() {
        return this.colorspace;
    }

    public float[] matrix() {
        float[] fArray = new float[8];
        float f2 = (float)Math.cos(this.rotation);
        float f3 = (float)Math.sin(this.rotation);
        fArray[0] = this.plainWidth * f2;
        fArray[1] = this.plainWidth * f3;
        fArray[2] = -this.plainHeight * f3;
        fArray[3] = this.plainHeight * f2;
        if ((double)this.rotation < 1.5707963267948966) {
            fArray[4] = fArray[2];
            fArray[5] = 0.0f;
            fArray[6] = fArray[0];
            fArray[7] = fArray[1] + fArray[3];
        } else if ((double)this.rotation < Math.PI) {
            fArray[4] = fArray[0] + fArray[2];
            fArray[5] = fArray[3];
            fArray[6] = 0.0f;
            fArray[7] = fArray[1];
        } else if ((double)this.rotation < 4.71238898038469) {
            fArray[4] = fArray[0];
            fArray[5] = fArray[1] + fArray[3];
            fArray[6] = fArray[2];
            fArray[7] = 0.0f;
        } else {
            fArray[4] = 0.0f;
            fArray[5] = fArray[1];
            fArray[6] = fArray[0] + fArray[2];
            fArray[7] = fArray[3];
        }
        return fArray;
    }

    public static void skip(InputStream inputStream, int n2) throws IOException {
        while (n2 > 0) {
            n2 = (int)((long)n2 - inputStream.skip(n2));
        }
    }

    public static URL toURL(String string) throws MalformedURLException {
        if (string.startsWith("file:/") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("jar:")) {
            return new URL(string);
        }
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        return new URL("file", "", string2);
    }

    public int[] getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int[] nArray) {
        this.transparency = nArray;
    }

    public static boolean isTag(String string) {
        return "image".equals(string);
    }

    public float plainWidth() {
        return this.plainWidth;
    }

    public float plainHeight() {
        return this.plainHeight;
    }

    protected static synchronized Long getSerialId() {
        return new Long(++serialId);
    }

    public Long getMySerialId() {
        return this.mySerialId;
    }

    public int getDpiX() {
        return this.dpiX;
    }

    public int getDpiY() {
        return this.dpiY;
    }

    public void setDpi(int n2, int n3) {
        this.dpiX = n2;
        this.dpiY = n3;
    }

    public boolean isMaskCandidate() {
        if (this.type == 34 && this.bpc > 255) {
            return true;
        }
        return this.colorspace == 1;
    }

    public void makeMask() throws DocumentException {
        if (!this.isMaskCandidate()) {
            throw new DocumentException("This image can not be an image mask.");
        }
        this.mask = true;
    }

    public void setImageMask(Image image) throws DocumentException {
        if (this.mask) {
            throw new DocumentException("An image mask cannot contain another image mask.");
        }
        if (!image.mask) {
            throw new DocumentException("The image mask is not a mask. Did you do makeMask()?");
        }
        this.imageMask = image;
        this.smask = image.bpc > 1 && image.bpc <= 8;
    }

    public Image getImageMask() {
        return this.imageMask;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setInvertMask(boolean bl) {
        this.invert = bl;
    }

    public boolean isInvertMask() {
        return this.invert;
    }

    public boolean isInverted() {
        return this.invert;
    }

    public void setInverted(boolean bl) {
        this.invert = bl;
    }

    public boolean isInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(boolean bl) {
        this.interpolation = bl;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public void tagICC(ICC_Profile iCC_Profile) {
        this.profile = iCC_Profile;
    }

    public boolean hasICCProfile() {
        return this.profile != null;
    }

    public ICC_Profile getICCProfile() {
        return this.profile;
    }

    public boolean isDeflated() {
        return this.deflated;
    }

    public void setDeflated(boolean bl) {
        this.deflated = bl;
    }

    public PdfDictionary getAdditional() {
        return this.additional;
    }

    public void setAdditional(PdfDictionary pdfDictionary) {
        this.additional = pdfDictionary;
    }

    public boolean isSmask() {
        return this.smask;
    }

    public void setSmask(boolean bl) {
        this.smask = bl;
    }

    public float getXYRatio() {
        return this.XYRatio;
    }

    public void setXYRatio(float f2) {
        this.XYRatio = f2;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public void setIndentationLeft(float f2) {
        this.indentationLeft = f2;
    }

    public void setIndentationRight(float f2) {
        this.indentationRight = f2;
    }

    public int getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(int n2) {
        this.originalType = n2;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    public void setOriginalData(byte[] byArray) {
        this.originalData = byArray;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public void setSpacingBefore(float f2) {
        this.spacingBefore = f2;
    }

    public void setSpacingAfter(float f2) {
        this.spacingAfter = f2;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f2) {
        this.widthPercentage = f2;
    }

    public PdfOCG getLayer() {
        return this.layer;
    }

    public void setLayer(PdfOCG pdfOCG) {
        this.layer = pdfOCG;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

