/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Chunk
implements Element,
MarkupAttributes {
    public static final String OBJECT_REPLACEMENT_CHARACTER = "\ufffc";
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final Chunk NEXTPAGE = new Chunk("");
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String IMAGE = "IMAGE";
    public static final String GENERICTAG = "GENERICTAG";
    public static final String NEWPAGE = "NEWPAGE";
    public static final String SPLITCHARACTER = "SPLITCHARACTER";
    public static final String ACTION = "ACTION";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String PDFANNOTATION = "PDFANNOTATION";
    public static final String HYPHENATION = "HYPHENATION";
    public static final String TEXTRENDERMODE = "TEXTRENDERMODE";
    public static final String SKEW = "SKEW";
    public static final String HSCALE = "HSCALE";
    protected StringBuffer content = null;
    protected Font font = null;
    protected HashMap attributes = null;
    protected Properties markupAttributes = null;

    protected Chunk() {
    }

    public Chunk(String string, Font font) {
        this.content = new StringBuffer(string);
        this.font = font;
    }

    public Chunk(String string) {
        this(string, new Font());
    }

    public Chunk(char c2, Font font) {
        this.content = new StringBuffer();
        this.content.append(c2);
        this.font = font;
    }

    public Chunk(char c2) {
        this(c2, new Font());
    }

    public Chunk(Image image, float f2, float f3) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        Image image2 = Image.getInstance(image);
        image2.setAbsolutePosition(Float.NaN, Float.NaN);
        this.setAttribute(IMAGE, new Object[]{image2, new Float(f2), new Float(f3), new Boolean(false)});
    }

    public Chunk(Image image, float f2, float f3, boolean bl) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.setAttribute(IMAGE, new Object[]{image, new Float(f2), new Float(f3), new Boolean(bl)});
    }

    public Chunk(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string = (String)properties.remove("itext");
        if (string != null) {
            this.append(string);
        }
        if ((string = (String)properties.remove(ElementTags.LOCALGOTO)) != null) {
            this.setLocalGoto(string);
        }
        if ((string = (String)properties.remove(ElementTags.REMOTEGOTO)) != null) {
            String string2 = (String)properties.remove(ElementTags.DESTINATION);
            String string3 = (String)properties.remove(ElementTags.PAGE);
            if (string3 != null) {
                this.setRemoteGoto(string, Integer.valueOf(string3));
            } else if (string2 != null) {
                this.setRemoteGoto(string, string2);
            }
        }
        if ((string = (String)properties.remove(ElementTags.LOCALDESTINATION)) != null) {
            this.setLocalDestination(string);
        }
        if ((string = (String)properties.remove(ElementTags.SUBSUPSCRIPT)) != null) {
            this.setTextRise(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("vertical-align")) != null && string.endsWith("%")) {
            float f2 = Float.valueOf(string.substring(0, string.length() - 1) + "f").floatValue() / 100.0f;
            this.setTextRise(f2 * this.font.size());
        }
        if ((string = (String)properties.remove(ElementTags.GENERICTAG)) != null) {
            this.setGenericTag(string);
        }
        if ((string = (String)properties.remove("backgroundcolor")) != null) {
            this.setBackground(MarkupParser.decodeColor(string));
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 10;
    }

    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        arrayList.add(this);
        return arrayList;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public Font font() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String content() {
        return this.content.toString();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf("\n") == -1 && this.attributes == null;
    }

    public float getWidthPoint() {
        if (this.getImage() != null) {
            return this.getImage().scaledWidth();
        }
        return this.font.getCalculatedBaseFont(true).getWidthPoint(this.content(), this.font.getCalculatedSize()) * this.getHorizontalScaling();
    }

    public Chunk setTextRise(float f2) {
        return this.setAttribute(SUBSUPSCRIPT, new Float(f2));
    }

    public float getTextRise() {
        if (this.attributes.containsKey(SUBSUPSCRIPT)) {
            Float f2 = (Float)this.attributes.get(SUBSUPSCRIPT);
            return f2.floatValue();
        }
        return 0.0f;
    }

    public Chunk setTextRenderMode(int n2, float f2, Color color) {
        return this.setAttribute(TEXTRENDERMODE, new Object[]{new Integer(n2), new Float(f2), color});
    }

    public Chunk setSkew(float f2, float f3) {
        f2 = (float)Math.tan((double)f2 * Math.PI / 180.0);
        f3 = (float)Math.tan((double)f3 * Math.PI / 180.0);
        return this.setAttribute(SKEW, new float[]{f2, f3});
    }

    public Chunk setHorizontalScaling(float f2) {
        return this.setAttribute(HSCALE, new Float(f2));
    }

    public float getHorizontalScaling() {
        if (this.attributes == null) {
            return 1.0f;
        }
        Float f2 = (Float)this.attributes.get(HSCALE);
        if (f2 == null) {
            return 1.0f;
        }
        return f2.floatValue();
    }

    public Chunk setAction(PdfAction pdfAction) {
        return this.setAttribute(ACTION, pdfAction);
    }

    public Chunk setAnchor(URL uRL) {
        return this.setAttribute(ACTION, new PdfAction(uRL.toExternalForm()));
    }

    public Chunk setAnchor(String string) {
        return this.setAttribute(ACTION, new PdfAction(string));
    }

    public Chunk setLocalGoto(String string) {
        return this.setAttribute(LOCALGOTO, string);
    }

    public Chunk setBackground(Color color) {
        return this.setBackground(color, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Chunk setBackground(Color color, float f2, float f3, float f4, float f5) {
        return this.setAttribute(BACKGROUND, new Object[]{color, new float[]{f2, f3, f4, f5}});
    }

    public Chunk setUnderline(float f2, float f3) {
        return this.setUnderline(null, f2, 0.0f, f3, 0.0f, 0);
    }

    public Chunk setUnderline(Color color, float f2, float f3, float f4, float f5, int n2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        Object[] objectArray = new Object[]{color, new float[]{f2, f3, f4, f5, n2}};
        Object[][] objectArray2 = Chunk.addToArray((Object[][])this.attributes.get(UNDERLINE), objectArray);
        return this.setAttribute(UNDERLINE, objectArray2);
    }

    public static Object[][] addToArray(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            objectArray = new Object[][]{objectArray2};
            return objectArray;
        }
        Object[][] objectArray3 = new Object[objectArray.length + 1][];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        objectArray3[objectArray.length] = objectArray2;
        return objectArray3;
    }

    public Chunk setAnnotation(PdfAnnotation pdfAnnotation) {
        return this.setAttribute(PDFANNOTATION, pdfAnnotation);
    }

    public Chunk setHyphenation(HyphenationEvent hyphenationEvent) {
        return this.setAttribute(HYPHENATION, hyphenationEvent);
    }

    public Chunk setRemoteGoto(String string, String string2) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, string2});
    }

    public Chunk setRemoteGoto(String string, int n2) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, new Integer(n2)});
    }

    public Chunk setLocalDestination(String string) {
        return this.setAttribute(LOCALDESTINATION, string);
    }

    public Chunk setGenericTag(String string) {
        return this.setAttribute(GENERICTAG, string);
    }

    public Chunk setSplitCharacter(SplitCharacter splitCharacter) {
        return this.setAttribute(SPLITCHARACTER, splitCharacter);
    }

    public Chunk setNewPage() {
        return this.setAttribute(NEWPAGE, null);
    }

    private Chunk setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
        return this;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public Image getImage() {
        if (this.attributes == null) {
            return null;
        }
        Object[] objectArray = (Object[])this.attributes.get(IMAGE);
        if (objectArray == null) {
            return null;
        }
        return (Image)objectArray[0];
    }

    public static boolean isTag(String string) {
        return "chunk".equals(string);
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public static Set getKeySet(Hashtable hashtable) {
        return hashtable == null ? Collections.EMPTY_SET : hashtable.keySet();
    }

    static {
        NEXTPAGE.setNewPage();
    }
}

