/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class Anchor
extends Phrase
implements TextElementArray,
MarkupAttributes {
    public static final String ANCHOR = "anchor";
    protected String name = null;
    protected String reference = null;

    public Anchor() {
        super(16.0f);
    }

    public Anchor(float f2) {
        super(f2);
    }

    public Anchor(Chunk chunk) {
        super(chunk);
    }

    public Anchor(String string) {
        super(string);
    }

    public Anchor(String string, Font font) {
        super(string, font);
    }

    public Anchor(float f2, Chunk chunk) {
        super(f2, chunk);
    }

    public Anchor(float f2, String string) {
        super(f2, string);
    }

    public Anchor(float f2, String string, Font font) {
        super(f2, string, font);
    }

    public Anchor(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string = (String)properties.remove("itext");
        if (string != null) {
            Chunk chunk = new Chunk(string);
            string = (String)properties.remove(ElementTags.GENERICTAG);
            if (string != null) {
                chunk.setGenericTag(string);
            }
            this.add(chunk);
        }
        if ((string = (String)properties.remove("leading")) != null) {
            this.setLeading(Float.valueOf(string + "f").floatValue());
        } else {
            string = (String)properties.remove("line-height");
            if (string != null) {
                this.setLeading(MarkupParser.parseLength(string));
            }
        }
        string = (String)properties.remove("name");
        if (string != null) {
            this.setName(string);
        }
        if ((string = (String)properties.remove("reference")) != null) {
            this.setReference(string);
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.getChunks().iterator();
            boolean bl = this.reference != null && this.reference.startsWith("#");
            boolean bl2 = true;
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                if (this.name != null && bl2 && !chunk.isEmpty()) {
                    chunk.setLocalDestination(this.name);
                    bl2 = false;
                }
                if (bl) {
                    chunk.setLocalGoto(this.reference.substring(1));
                }
                elementListener.add(chunk);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        Iterator iterator = this.iterator();
        boolean bl = this.reference != null && this.reference.startsWith("#");
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            if (this.name != null && bl2 && !chunk.isEmpty()) {
                chunk.setLocalDestination(this.name);
                bl2 = false;
            }
            if (bl) {
                chunk.setLocalGoto(this.reference.substring(1));
            } else if (this.reference != null) {
                chunk.setAnchor(this.reference);
            }
            arrayList.add(chunk);
        }
        return arrayList;
    }

    public int type() {
        return 17;
    }

    public Iterator getElements() {
        return this.iterator();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String name() {
        return this.name;
    }

    public String reference() {
        return this.reference;
    }

    public URL url() {
        try {
            return new URL(this.reference);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean isTag(String string) {
        return ANCHOR.equals(string);
    }
}

