/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.OIDTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DERObjectIdentifier
extends DERObject {
    String identifier;

    public static DERObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERObjectIdentifier.getInstance(aSN1TaggedObject.getObject());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl = true;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            n2 = n2 * 128 + (n3 & 0x7F);
            if ((n3 & 0x80) != 0) continue;
            if (bl) {
                switch (n2 / 40) {
                    case 0: {
                        stringBuffer.append('0');
                        break;
                    }
                    case 1: {
                        stringBuffer.append('1');
                        n2 -= 40;
                        break;
                    }
                    default: {
                        stringBuffer.append('2');
                        n2 -= 80;
                    }
                }
                bl = false;
            }
            stringBuffer.append('.');
            stringBuffer.append(Integer.toString(n2));
            n2 = 0;
        }
        this.identifier = stringBuffer.toString();
    }

    public DERObjectIdentifier(String string) {
        this.identifier = string;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream outputStream, int n2) throws IOException {
        if (n2 >= 128) {
            if (n2 >= 16384) {
                if (n2 >= 0x200000) {
                    if (n2 >= 0x10000000) {
                        outputStream.write(n2 >> 28 | 0x80);
                    }
                    outputStream.write(n2 >> 21 | 0x80);
                }
                outputStream.write(n2 >> 14 | 0x80);
            }
            outputStream.write(n2 >> 7 | 0x80);
        }
        outputStream.write(n2 & 0x7F);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        this.writeField(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            this.writeField(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()));
        }
        dEROutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dEROutputStream.writeEncoded(6, byArray);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)object).identifier);
    }
}

