/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends DERObject {
    byte[] bytes;

    public static DERInteger getInstance(Object object) {
        if (object == null || object instanceof DERInteger) {
            return (DERInteger)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERInteger.getInstance(aSN1TaggedObject.getObject());
    }

    public DERInteger(int n2) {
        this.bytes = BigInteger.valueOf(n2).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.bytes = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(2, this.bytes);
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 != this.bytes.length; ++i2) {
            n2 ^= (this.bytes[i2] & 0xFF) << i2 % 4;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERInteger)) {
            return false;
        }
        DERInteger dERInteger = (DERInteger)object;
        if (this.bytes.length != dERInteger.bytes.length) {
            return false;
        }
        for (int i2 = 0; i2 != this.bytes.length; ++i2) {
            if (this.bytes[i2] == dERInteger.bytes[i2]) continue;
            return false;
        }
        return true;
    }
}

