/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DEREnumerated
extends DERObject {
    byte[] bytes;

    public static DEREnumerated getInstance(Object object) {
        if (object == null || object instanceof DEREnumerated) {
            return (DEREnumerated)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DEREnumerated(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DEREnumerated.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DEREnumerated getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DEREnumerated.getInstance(aSN1TaggedObject.getObject());
    }

    public DEREnumerated(int n2) {
        this.bytes = BigInteger.valueOf(n2).toByteArray();
    }

    public DEREnumerated(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DEREnumerated(byte[] byArray) {
        this.bytes = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(10, this.bytes);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DEREnumerated)) {
            return false;
        }
        DEREnumerated dEREnumerated = (DEREnumerated)object;
        if (this.bytes.length != dEREnumerated.bytes.length) {
            return false;
        }
        for (int i2 = 0; i2 != this.bytes.length; ++i2) {
            if (this.bytes[i2] == dEREnumerated.bytes[i2]) continue;
            return false;
        }
        return true;
    }
}

