/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1OutputStream;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DEREncodable;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERBitString
extends DERObject
implements DERString {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected byte[] data;
    protected int padBits;

    protected static int getPadBits(int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 3; n3 >= 0; --n3) {
            if (n3 != 0) {
                if (n2 >> n3 * 8 == 0) continue;
                n4 = n2 >> n3 * 8 & 0xFF;
                break;
            }
            if (n2 == 0) continue;
            n4 = n2 & 0xFF;
            break;
        }
        if (n4 == 0) {
            return 7;
        }
        n3 = 1;
        while (((n4 <<= 1) & 0xFF) != 0) {
            ++n3;
        }
        return 8 - n3;
    }

    protected static byte[] getBytes(int n2) {
        int n3 = 4;
        for (int i2 = 3; i2 >= 1 && (n2 & 255 << i2 * 8) == 0; --i2) {
            --n3;
        }
        byte[] byArray = new byte[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            byArray[i3] = (byte)(n2 >> i3 * 8 & 0xFF);
        }
        return byArray;
    }

    public static DERBitString getInstance(Object object) {
        if (object == null || object instanceof DERBitString) {
            return (DERBitString)object;
        }
        if (object instanceof ASN1OctetString) {
            byte[] byArray = ((ASN1OctetString)object).getOctets();
            byte by = byArray[0];
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return new DERBitString(byArray2, (int)by);
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBitString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBitString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERBitString.getInstance(aSN1TaggedObject.getObject());
    }

    protected DERBitString(byte by, int n2) {
        this.data = new byte[1];
        this.data[0] = by;
        this.padBits = n2;
    }

    public DERBitString(byte[] byArray, int n2) {
        this.data = byArray;
        this.padBits = n2;
    }

    public DERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public DERBitString(DEREncodable dEREncodable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dEREncodable);
            dEROutputStream.close();
            this.data = byteArrayOutputStream.toByteArray();
            this.padBits = 0;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getPadBits() {
        return this.padBits;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        byte[] byArray = new byte[this.getBytes().length + 1];
        byArray[0] = (byte)this.getPadBits();
        System.arraycopy(this.getBytes(), 0, byArray, 1, byArray.length - 1);
        dEROutputStream.writeEncoded(3, byArray);
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 != this.data.length; ++i2) {
            n2 ^= (this.data[i2] & 0xFF) << i2 % 4;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERBitString)) {
            return false;
        }
        DERBitString dERBitString = (DERBitString)object;
        if (this.data.length != dERBitString.data.length) {
            return false;
        }
        for (int i2 = 0; i2 != this.data.length; ++i2) {
            if (this.data[i2] == dERBitString.data[i2]) continue;
            return false;
        }
        return this.padBits == dERBitString.padBits;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            stringBuffer.append(table[(byArray[i2] >>> 4) % 15]);
            stringBuffer.append(table[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }
}

