/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDeveloperExtension;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.security.CrlClient;
import com.itextpdf.text.pdf.security.OcspClient;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LtvVerification {
    private Logger LOGGER = LoggerFactory.getLogger(LtvVerification.class);
    private PdfStamper stp;
    private PdfWriter writer;
    private PdfReader reader;
    private AcroFields acroFields;
    private Map<PdfName, ValidationData> validated = new HashMap<PdfName, ValidationData>();
    private boolean used = false;

    public LtvVerification(PdfStamper stp) {
        this.stp = stp;
        this.writer = stp.getWriter();
        this.reader = stp.getReader();
        this.acroFields = stp.getAcroFields();
    }

    public boolean addVerification(String signatureName, OcspClient ocsp, CrlClient crl, CertificateOption certOption, Level level, CertificateInclusion certInclude) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("verification.already.output", new Object[0]));
        }
        PdfPKCS7 pk = this.acroFields.verifySignature(signatureName);
        this.LOGGER.info("Adding verification for " + signatureName);
        Certificate[] xc = pk.getCertificates();
        X509Certificate signingCert = pk.getSigningCertificate();
        ValidationData vd = new ValidationData();
        for (int k2 = 0; k2 < xc.length; ++k2) {
            Collection<byte[]> cims;
            X509Certificate cert = (X509Certificate)xc[k2];
            this.LOGGER.info("Certificate: " + cert.getSubjectDN());
            if (certOption == CertificateOption.SIGNING_CERTIFICATE && !cert.equals(signingCert)) continue;
            byte[] ocspEnc = null;
            if (ocsp != null && level != Level.CRL && (ocspEnc = ocsp.getEncoded(cert, this.getParent(cert, xc), null)) != null) {
                vd.ocsps.add(LtvVerification.buildOCSPResponse(ocspEnc));
                this.LOGGER.info("OCSP added");
            }
            if (crl != null && (level == Level.CRL || level == Level.OCSP_CRL || level == Level.OCSP_OPTIONAL_CRL && ocspEnc == null) && (cims = crl.getEncoded(cert, null)) != null) {
                for (byte[] cim : cims) {
                    boolean dup = false;
                    for (byte[] b2 : vd.crls) {
                        if (!Arrays.equals(b2, cim)) continue;
                        dup = true;
                        break;
                    }
                    if (dup) continue;
                    vd.crls.add(cim);
                    this.LOGGER.info("CRL added");
                }
            }
            if (certInclude != CertificateInclusion.YES) continue;
            vd.certs.add(cert.getEncoded());
        }
        if (vd.crls.isEmpty() && vd.ocsps.isEmpty()) {
            return false;
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    private X509Certificate getParent(X509Certificate cert, Certificate[] certs) {
        for (int i2 = 0; i2 < certs.length; ++i2) {
            X509Certificate parent = (X509Certificate)certs[i2];
            if (!((Object)cert.getIssuerDN()).equals(parent.getSubjectDN())) continue;
            try {
                cert.verify(parent.getPublicKey());
                return parent;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean addVerification(String signatureName, Collection<byte[]> ocsps, Collection<byte[]> crls, Collection<byte[]> certs) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("verification.already.output", new Object[0]));
        }
        ValidationData vd = new ValidationData();
        if (ocsps != null) {
            for (byte[] ocsp : ocsps) {
                vd.ocsps.add(LtvVerification.buildOCSPResponse(ocsp));
            }
        }
        if (crls != null) {
            for (byte[] crl : crls) {
                vd.crls.add(crl);
            }
        }
        if (certs != null) {
            for (byte[] cert : certs) {
                vd.certs.add(cert);
            }
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    private static byte[] buildOCSPResponse(byte[] BasicOCSPResponse) throws IOException {
        DEROctetString doctet = new DEROctetString(BasicOCSPResponse);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        v2.add((ASN1Encodable)doctet);
        ASN1Enumerated den = new ASN1Enumerated(0);
        ASN1EncodableVector v3 = new ASN1EncodableVector();
        v3.add((ASN1Encodable)den);
        v3.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(v2)));
        DERSequence seq = new DERSequence(v3);
        return seq.getEncoded();
    }

    private PdfName getSignatureHashKey(String signatureName) throws NoSuchAlgorithmException, IOException {
        PdfDictionary dic = this.acroFields.getSignatureDictionary(signatureName);
        PdfString contents = dic.getAsString(PdfName.CONTENTS);
        byte[] bc = contents.getOriginalBytes();
        byte[] bt = null;
        if (PdfName.ETSI_RFC3161.equals(PdfReader.getPdfObject(dic.get(PdfName.SUBFILTER)))) {
            ASN1InputStream din = new ASN1InputStream((InputStream)new ByteArrayInputStream(bc));
            ASN1Primitive pkcs = din.readObject();
            bc = pkcs.getEncoded();
        }
        bt = LtvVerification.hashBytesSha1(bc);
        return new PdfName(Utilities.convertToHex(bt));
    }

    private static byte[] hashBytesSha1(byte[] b2) throws NoSuchAlgorithmException {
        MessageDigest sh = MessageDigest.getInstance("SHA1");
        return sh.digest(b2);
    }

    public void merge() throws IOException {
        if (this.used || this.validated.isEmpty()) {
            return;
        }
        this.used = true;
        PdfDictionary catalog = this.reader.getCatalog();
        PdfObject dss = catalog.get(PdfName.DSS);
        if (dss == null) {
            this.createDss();
        } else {
            this.updateDss();
        }
    }

    private void updateDss() throws IOException {
        PdfDictionary catalog = this.reader.getCatalog();
        this.stp.markUsed(catalog);
        PdfDictionary dss = catalog.getAsDict(PdfName.DSS);
        PdfArray ocsps = dss.getAsArray(PdfName.OCSPS);
        PdfArray crls = dss.getAsArray(PdfName.CRLS);
        PdfArray certs = dss.getAsArray(PdfName.CERTS);
        dss.remove(PdfName.OCSPS);
        dss.remove(PdfName.CRLS);
        dss.remove(PdfName.CERTS);
        PdfDictionary vrim = dss.getAsDict(PdfName.VRI);
        if (vrim != null) {
            for (PdfName n2 : vrim.getKeys()) {
                PdfDictionary vri;
                if (!this.validated.containsKey(n2) || (vri = vrim.getAsDict(n2)) == null) continue;
                LtvVerification.deleteOldReferences(ocsps, vri.getAsArray(PdfName.OCSP));
                LtvVerification.deleteOldReferences(crls, vri.getAsArray(PdfName.CRL));
                LtvVerification.deleteOldReferences(certs, vri.getAsArray(PdfName.CERT));
            }
        }
        if (ocsps == null) {
            ocsps = new PdfArray();
        }
        if (crls == null) {
            crls = new PdfArray();
        }
        if (certs == null) {
            certs = new PdfArray();
        }
        this.outputDss(dss, vrim, ocsps, crls, certs);
    }

    private static void deleteOldReferences(PdfArray all, PdfArray toDelete) {
        if (all == null || toDelete == null) {
            return;
        }
        for (PdfObject pi : toDelete) {
            if (!pi.isIndirect()) continue;
            PRIndirectReference pir = (PRIndirectReference)pi;
            for (int k2 = 0; k2 < all.size(); ++k2) {
                PdfObject po = all.getPdfObject(k2);
                if (!po.isIndirect()) continue;
                PRIndirectReference pod = (PRIndirectReference)po;
                if (pir.getNumber() != pod.getNumber()) continue;
                all.remove(k2);
                --k2;
            }
        }
    }

    private void createDss() throws IOException {
        this.outputDss(new PdfDictionary(), new PdfDictionary(), new PdfArray(), new PdfArray(), new PdfArray());
    }

    private void outputDss(PdfDictionary dss, PdfDictionary vrim, PdfArray ocsps, PdfArray crls, PdfArray certs) throws IOException {
        this.writer.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL5);
        PdfDictionary catalog = this.reader.getCatalog();
        this.stp.markUsed(catalog);
        for (PdfName vkey : this.validated.keySet()) {
            PdfIndirectReference iref;
            PdfStream ps;
            PdfArray ocsp = new PdfArray();
            PdfArray crl = new PdfArray();
            PdfArray cert = new PdfArray();
            PdfDictionary vri = new PdfDictionary();
            for (byte[] b2 : this.validated.get((Object)vkey).crls) {
                ps = new PdfStream(b2);
                ps.flateCompress();
                iref = this.writer.addToBody((PdfObject)ps, false).getIndirectReference();
                crl.add(iref);
                crls.add(iref);
            }
            for (byte[] b2 : this.validated.get((Object)vkey).ocsps) {
                ps = new PdfStream(b2);
                ps.flateCompress();
                iref = this.writer.addToBody((PdfObject)ps, false).getIndirectReference();
                ocsp.add(iref);
                ocsps.add(iref);
            }
            for (byte[] b2 : this.validated.get((Object)vkey).certs) {
                ps = new PdfStream(b2);
                ps.flateCompress();
                iref = this.writer.addToBody((PdfObject)ps, false).getIndirectReference();
                cert.add(iref);
                certs.add(iref);
            }
            if (ocsp.size() > 0) {
                vri.put(PdfName.OCSP, this.writer.addToBody((PdfObject)ocsp, false).getIndirectReference());
            }
            if (crl.size() > 0) {
                vri.put(PdfName.CRL, this.writer.addToBody((PdfObject)crl, false).getIndirectReference());
            }
            if (cert.size() > 0) {
                vri.put(PdfName.CERT, this.writer.addToBody((PdfObject)cert, false).getIndirectReference());
            }
            vrim.put(vkey, this.writer.addToBody((PdfObject)vri, false).getIndirectReference());
        }
        dss.put(PdfName.VRI, this.writer.addToBody((PdfObject)vrim, false).getIndirectReference());
        if (ocsps.size() > 0) {
            dss.put(PdfName.OCSPS, this.writer.addToBody((PdfObject)ocsps, false).getIndirectReference());
        }
        if (crls.size() > 0) {
            dss.put(PdfName.CRLS, this.writer.addToBody((PdfObject)crls, false).getIndirectReference());
        }
        if (certs.size() > 0) {
            dss.put(PdfName.CERTS, this.writer.addToBody((PdfObject)certs, false).getIndirectReference());
        }
        catalog.put(PdfName.DSS, this.writer.addToBody((PdfObject)dss, false).getIndirectReference());
    }

    private static class ValidationData {
        public List<byte[]> crls = new ArrayList<byte[]>();
        public List<byte[]> ocsps = new ArrayList<byte[]>();
        public List<byte[]> certs = new ArrayList<byte[]>();

        private ValidationData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateInclusion {
        YES,
        NO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateOption {
        SIGNING_CERTIFICATE,
        WHOLE_CHAIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OCSP,
        CRL,
        OCSP_CRL,
        OCSP_OPTIONAL_CRL;

    }
}

