/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.LongRect;
import com.itextpdf.text.pdf.parser.clipper.Path;
import com.itextpdf.text.pdf.parser.clipper.Point;
import com.itextpdf.text.pdf.parser.clipper.PolyNode;
import com.itextpdf.text.pdf.parser.clipper.PolyTree;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paths
extends ArrayList<Path> {
    private static final long serialVersionUID = 1910552127810480852L;

    public static Paths closedPathsFromPolyTree(PolyTree polytree) {
        Paths result = new Paths();
        result.addPolyNode(polytree, PolyNode.NodeType.CLOSED);
        return result;
    }

    public static Paths makePolyTreeToPaths(PolyTree polytree) {
        Paths result = new Paths();
        result.addPolyNode(polytree, PolyNode.NodeType.ANY);
        return result;
    }

    public static Paths openPathsFromPolyTree(PolyTree polytree) {
        Paths result = new Paths();
        for (PolyNode c2 : polytree.getChilds()) {
            if (!c2.isOpen()) continue;
            result.add(c2.getPolygon());
        }
        return result;
    }

    public Paths() {
    }

    public Paths(int initialCapacity) {
        super(initialCapacity);
    }

    public void addPolyNode(PolyNode polynode, PolyNode.NodeType nt) {
        boolean match = true;
        switch (nt) {
            case OPEN: {
                return;
            }
            case CLOSED: {
                match = !polynode.isOpen();
                break;
            }
        }
        if (polynode.getPolygon().size() > 0 && match) {
            this.add(polynode.getPolygon());
        }
        for (PolyNode pn : polynode.getChilds()) {
            this.addPolyNode(pn, nt);
        }
    }

    public Paths cleanPolygons() {
        return this.cleanPolygons(1.415);
    }

    public Paths cleanPolygons(double distance) {
        Paths result = new Paths(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            result.add(((Path)this.get(i2)).cleanPolygon(distance));
        }
        return result;
    }

    public LongRect getBounds() {
        int i2;
        int cnt = this.size();
        LongRect result = new LongRect();
        for (i2 = 0; i2 < cnt && ((Path)this.get(i2)).isEmpty(); ++i2) {
        }
        if (i2 == cnt) {
            return result;
        }
        result.right = result.left = ((Point.LongPoint)((Path)this.get(i2)).get(0)).getX();
        result.bottom = result.top = ((Point.LongPoint)((Path)this.get(i2)).get(0)).getY();
        while (i2 < cnt) {
            for (int j2 = 0; j2 < ((Path)this.get(i2)).size(); ++j2) {
                if (((Point.LongPoint)((Path)this.get(i2)).get(j2)).getX() < result.left) {
                    result.left = ((Point.LongPoint)((Path)this.get(i2)).get(j2)).getX();
                } else if (((Point.LongPoint)((Path)this.get(i2)).get(j2)).getX() > result.right) {
                    result.right = ((Point.LongPoint)((Path)this.get(i2)).get(j2)).getX();
                }
                if (((Point.LongPoint)((Path)this.get(i2)).get(j2)).getY() < result.top) {
                    result.top = ((Point.LongPoint)((Path)this.get(i2)).get(j2)).getY();
                    continue;
                }
                if (((Point.LongPoint)((Path)this.get(i2)).get(j2)).getY() <= result.bottom) continue;
                result.bottom = ((Point.LongPoint)((Path)this.get(i2)).get(j2)).getY();
            }
            ++i2;
        }
        return result;
    }

    public void reversePaths() {
        for (Path poly : this) {
            poly.reverse();
        }
    }
}

