/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.Clipper;
import com.itextpdf.text.pdf.parser.clipper.Edge;
import com.itextpdf.text.pdf.parser.clipper.Path;
import com.itextpdf.text.pdf.parser.clipper.Paths;
import com.itextpdf.text.pdf.parser.clipper.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class ClipperBase
implements Clipper {
    private static final long LOW_RANGE = 0x3FFFFFFFL;
    private static final long HI_RANGE = 0x3FFFFFFFFFFFFFFFL;
    protected LocalMinima minimaList;
    protected LocalMinima currentLM;
    private final List<List<Edge>> edges;
    protected boolean hasOpenPaths;
    protected final boolean preserveCollinear;
    private static final Logger LOGGER = Logger.getLogger(Clipper.class.getName());

    private static void initEdge(Edge e2, Edge eNext, Edge ePrev, Point.LongPoint pt) {
        e2.next = eNext;
        e2.prev = ePrev;
        e2.setCurrent(new Point.LongPoint(pt));
        e2.outIdx = -1;
    }

    private static void initEdge2(Edge e2, Clipper.PolyType polyType) {
        if (e2.getCurrent().getY() >= e2.next.getCurrent().getY()) {
            e2.setBot(new Point.LongPoint(e2.getCurrent()));
            e2.setTop(new Point.LongPoint(e2.next.getCurrent()));
        } else {
            e2.setTop(new Point.LongPoint(e2.getCurrent()));
            e2.setBot(new Point.LongPoint(e2.next.getCurrent()));
        }
        e2.updateDeltaX();
        e2.polyTyp = polyType;
    }

    private static void rangeTest(Point.LongPoint Pt) {
        if (!(Pt.getX() <= 0x3FFFFFFFL && Pt.getY() <= 0x3FFFFFFFL && -Pt.getX() <= 0x3FFFFFFFL && -Pt.getY() <= 0x3FFFFFFFL || Pt.getX() <= 0x3FFFFFFFFFFFFFFFL && Pt.getY() <= 0x3FFFFFFFFFFFFFFFL && -Pt.getX() <= 0x3FFFFFFFFFFFFFFFL && -Pt.getY() <= 0x3FFFFFFFFFFFFFFFL)) {
            throw new IllegalStateException("Coordinate outside allowed range");
        }
    }

    private static Edge removeEdge(Edge e2) {
        e2.prev.next = e2.next;
        e2.next.prev = e2.prev;
        Edge result = e2.next;
        e2.prev = null;
        return result;
    }

    protected ClipperBase(boolean preserveCollinear) {
        this.preserveCollinear = preserveCollinear;
        this.minimaList = null;
        this.currentLM = null;
        this.hasOpenPaths = false;
        this.edges = new ArrayList<List<Edge>>();
    }

    public boolean addPath(Path pg, Clipper.PolyType polyType, boolean Closed) {
        Edge eStart;
        int highI;
        if (!Closed && polyType == Clipper.PolyType.CLIP) {
            throw new IllegalStateException("AddPath: Open paths must be subject.");
        }
        if (Closed) {
            for (highI = pg.size() - 1; highI > 0 && ((Point.LongPoint)pg.get(highI)).equals(pg.get(0)); --highI) {
            }
        }
        while (highI > 0 && ((Point.LongPoint)pg.get(highI)).equals(pg.get(highI - 1))) {
            --highI;
        }
        if (Closed && highI < 2 || !Closed && highI < 1) {
            return false;
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(highI + 1);
        for (int i2 = 0; i2 <= highI; ++i2) {
            edges.add(new Edge());
        }
        boolean IsFlat = true;
        ((Edge)edges.get(1)).setCurrent(new Point.LongPoint((Point.LongPoint)pg.get(1)));
        ClipperBase.rangeTest((Point.LongPoint)pg.get(0));
        ClipperBase.rangeTest((Point.LongPoint)pg.get(highI));
        ClipperBase.initEdge((Edge)edges.get(0), (Edge)edges.get(1), (Edge)edges.get(highI), (Point.LongPoint)pg.get(0));
        ClipperBase.initEdge((Edge)edges.get(highI), (Edge)edges.get(0), (Edge)edges.get(highI - 1), (Point.LongPoint)pg.get(highI));
        for (int i3 = highI - 1; i3 >= 1; --i3) {
            ClipperBase.rangeTest((Point.LongPoint)pg.get(i3));
            ClipperBase.initEdge((Edge)edges.get(i3), (Edge)edges.get(i3 + 1), (Edge)edges.get(i3 - 1), (Point.LongPoint)pg.get(i3));
        }
        Edge e2 = eStart = (Edge)edges.get(0);
        Edge eLoopStop = eStart;
        while (true) {
            if (e2.getCurrent().equals(e2.next.getCurrent()) && (Closed || !e2.next.equals(eStart))) {
                if (e2 == e2.next) break;
                if (e2 == eStart) {
                    eStart = e2.next;
                }
                eLoopStop = e2 = ClipperBase.removeEdge(e2);
                continue;
            }
            if (e2.prev == e2.next) break;
            if (Closed && Point.slopesEqual(e2.prev.getCurrent(), e2.getCurrent(), e2.next.getCurrent()) && (!this.isPreserveCollinear() || !Point.isPt2BetweenPt1AndPt3(e2.prev.getCurrent(), e2.getCurrent(), e2.next.getCurrent()))) {
                if (e2 == eStart) {
                    eStart = e2.next;
                }
                e2 = ClipperBase.removeEdge(e2);
                eLoopStop = e2 = e2.prev;
                continue;
            }
            e2 = e2.next;
            if (e2 == eLoopStop || !Closed && e2.next == eStart) break;
        }
        if (!Closed && e2 == e2.next || Closed && e2.prev == e2.next) {
            return false;
        }
        if (!Closed) {
            this.hasOpenPaths = true;
            eStart.prev.outIdx = -2;
        }
        e2 = eStart;
        do {
            ClipperBase.initEdge2(e2, polyType);
            e2 = e2.next;
            if (!IsFlat || e2.getCurrent().getY() == eStart.getCurrent().getY()) continue;
            IsFlat = false;
        } while (e2 != eStart);
        if (IsFlat) {
            if (Closed) {
                return false;
            }
            e2.prev.outIdx = -2;
            LocalMinima locMin = new LocalMinima();
            locMin.next = null;
            locMin.y = e2.getBot().getY();
            locMin.leftBound = null;
            locMin.rightBound = e2;
            locMin.rightBound.side = Edge.Side.RIGHT;
            locMin.rightBound.windDelta = 0;
            while (true) {
                if (e2.getBot().getX() != e2.prev.getTop().getX()) {
                    e2.reverseHorizontal();
                }
                if (e2.next.outIdx == -2) break;
                e2.nextInLML = e2.next;
                e2 = e2.next;
            }
            this.insertLocalMinima(locMin);
            this.edges.add(edges);
            return true;
        }
        this.edges.add(edges);
        Edge EMin = null;
        if (e2.prev.getBot().equals(e2.prev.getTop())) {
            e2 = e2.next;
        }
        while ((e2 = e2.findNextLocMin()) != EMin) {
            boolean leftBoundIsForward;
            if (EMin == null) {
                EMin = e2;
            }
            LocalMinima locMin = new LocalMinima();
            locMin.next = null;
            locMin.y = e2.getBot().getY();
            if (e2.deltaX < e2.prev.deltaX) {
                locMin.leftBound = e2.prev;
                locMin.rightBound = e2;
                leftBoundIsForward = false;
            } else {
                locMin.leftBound = e2;
                locMin.rightBound = e2.prev;
                leftBoundIsForward = true;
            }
            locMin.leftBound.side = Edge.Side.LEFT;
            locMin.rightBound.side = Edge.Side.RIGHT;
            locMin.leftBound.windDelta = !Closed ? 0 : (locMin.leftBound.next == locMin.rightBound ? -1 : 1);
            locMin.rightBound.windDelta = -locMin.leftBound.windDelta;
            e2 = this.processBound(locMin.leftBound, leftBoundIsForward);
            if (e2.outIdx == -2) {
                e2 = this.processBound(e2, leftBoundIsForward);
            }
            Edge E2 = this.processBound(locMin.rightBound, !leftBoundIsForward);
            if (E2.outIdx == -2) {
                E2 = this.processBound(E2, !leftBoundIsForward);
            }
            if (locMin.leftBound.outIdx == -2) {
                locMin.leftBound = null;
            } else if (locMin.rightBound.outIdx == -2) {
                locMin.rightBound = null;
            }
            this.insertLocalMinima(locMin);
            if (leftBoundIsForward) continue;
            e2 = E2;
        }
        return true;
    }

    public boolean addPaths(Paths ppg, Clipper.PolyType polyType, boolean closed) {
        boolean result = false;
        for (int i2 = 0; i2 < ppg.size(); ++i2) {
            if (!this.addPath((Path)ppg.get(i2), polyType, closed)) continue;
            result = true;
        }
        return result;
    }

    public void clear() {
        this.disposeLocalMinimaList();
        this.edges.clear();
        this.hasOpenPaths = false;
    }

    private void disposeLocalMinimaList() {
        while (this.minimaList != null) {
            LocalMinima tmpLm = this.minimaList.next;
            this.minimaList = null;
            this.minimaList = tmpLm;
        }
        this.currentLM = null;
    }

    private void insertLocalMinima(LocalMinima newLm) {
        if (this.minimaList == null) {
            this.minimaList = newLm;
        } else if (newLm.y >= this.minimaList.y) {
            newLm.next = this.minimaList;
            this.minimaList = newLm;
        } else {
            LocalMinima tmpLm = this.minimaList;
            while (tmpLm.next != null && newLm.y < tmpLm.next.y) {
                tmpLm = tmpLm.next;
            }
            newLm.next = tmpLm.next;
            tmpLm.next = newLm;
        }
    }

    public boolean isPreserveCollinear() {
        return this.preserveCollinear;
    }

    protected void popLocalMinima() {
        LOGGER.entering(ClipperBase.class.getName(), "popLocalMinima");
        if (this.currentLM == null) {
            return;
        }
        this.currentLM = this.currentLM.next;
    }

    private Edge processBound(Edge e2, boolean LeftBoundIsForward) {
        Edge EStart;
        Edge result = e2;
        if (result.outIdx == -2) {
            e2 = result;
            if (LeftBoundIsForward) {
                while (e2.getTop().getY() == e2.next.getBot().getY()) {
                    e2 = e2.next;
                }
                while (e2 != result && e2.deltaX == -3.4E38) {
                    e2 = e2.prev;
                }
            } else {
                while (e2.getTop().getY() == e2.prev.getBot().getY()) {
                    e2 = e2.prev;
                }
                while (e2 != result && e2.deltaX == -3.4E38) {
                    e2 = e2.next;
                }
            }
            if (e2 == result) {
                result = LeftBoundIsForward ? e2.next : e2.prev;
            } else {
                e2 = LeftBoundIsForward ? result.next : result.prev;
                LocalMinima locMin = new LocalMinima();
                locMin.next = null;
                locMin.y = e2.getBot().getY();
                locMin.leftBound = null;
                locMin.rightBound = e2;
                e2.windDelta = 0;
                result = this.processBound(e2, LeftBoundIsForward);
                this.insertLocalMinima(locMin);
            }
            return result;
        }
        if (e2.deltaX == -3.4E38) {
            EStart = LeftBoundIsForward ? e2.prev : e2.next;
            if (EStart.deltaX == -3.4E38) {
                if (EStart.getBot().getX() != e2.getBot().getX() && EStart.getTop().getX() != e2.getBot().getX()) {
                    e2.reverseHorizontal();
                }
            } else if (EStart.getBot().getX() != e2.getBot().getX()) {
                e2.reverseHorizontal();
            }
        }
        EStart = e2;
        if (LeftBoundIsForward) {
            while (result.getTop().getY() == result.next.getBot().getY() && result.next.outIdx != -2) {
                result = result.next;
            }
            if (result.deltaX == -3.4E38 && result.next.outIdx != -2) {
                Edge Horz = result;
                while (Horz.prev.deltaX == -3.4E38) {
                    Horz = Horz.prev;
                }
                if (Horz.prev.getTop().getX() > result.next.getTop().getX()) {
                    result = Horz.prev;
                }
            }
            while (e2 != result) {
                e2.nextInLML = e2.next;
                if (e2.deltaX == -3.4E38 && e2 != EStart && e2.getBot().getX() != e2.prev.getTop().getX()) {
                    e2.reverseHorizontal();
                }
                e2 = e2.next;
            }
            if (e2.deltaX == -3.4E38 && e2 != EStart && e2.getBot().getX() != e2.prev.getTop().getX()) {
                e2.reverseHorizontal();
            }
            result = result.next;
        } else {
            while (result.getTop().getY() == result.prev.getBot().getY() && result.prev.outIdx != -2) {
                result = result.prev;
            }
            if (result.deltaX == -3.4E38 && result.prev.outIdx != -2) {
                Edge Horz = result;
                while (Horz.next.deltaX == -3.4E38) {
                    Horz = Horz.next;
                }
                if (Horz.next.getTop().getX() == result.prev.getTop().getX() || Horz.next.getTop().getX() > result.prev.getTop().getX()) {
                    result = Horz.next;
                }
            }
            while (e2 != result) {
                e2.nextInLML = e2.prev;
                if (e2.deltaX == -3.4E38 && e2 != EStart && e2.getBot().getX() != e2.next.getTop().getX()) {
                    e2.reverseHorizontal();
                }
                e2 = e2.prev;
            }
            if (e2.deltaX == -3.4E38 && e2 != EStart && e2.getBot().getX() != e2.next.getTop().getX()) {
                e2.reverseHorizontal();
            }
            result = result.prev;
        }
        return result;
    }

    protected void reset() {
        this.currentLM = this.minimaList;
        if (this.currentLM == null) {
            return;
        }
        LocalMinima lm = this.minimaList;
        while (lm != null) {
            Edge e2 = lm.leftBound;
            if (e2 != null) {
                e2.setCurrent(new Point.LongPoint(e2.getBot()));
                e2.side = Edge.Side.LEFT;
                e2.outIdx = -1;
            }
            if ((e2 = lm.rightBound) != null) {
                e2.setCurrent(new Point.LongPoint(e2.getBot()));
                e2.side = Edge.Side.RIGHT;
                e2.outIdx = -1;
            }
            lm = lm.next;
        }
    }

    protected class Scanbeam {
        long y;
        Scanbeam next;

        protected Scanbeam() {
        }
    }

    protected class LocalMinima {
        long y;
        Edge leftBound;
        Edge rightBound;
        LocalMinima next;

        protected LocalMinima() {
        }
    }
}

