/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.nio.ByteBuffer;

public class NullMask {
    private byte[] _mask;

    public NullMask(int columnCount) {
        int i2;
        this._mask = new byte[(columnCount + 7) / 8];
        for (i2 = 0; i2 < this._mask.length; ++i2) {
            this._mask[i2] = -1;
        }
        for (i2 = columnCount; i2 < this._mask.length * 8; ++i2) {
            this.markNull(i2);
        }
    }

    public void read(ByteBuffer buffer) {
        buffer.get(this._mask);
    }

    public ByteBuffer wrap() {
        return ByteBuffer.wrap(this._mask);
    }

    public boolean isNull(int columnNumber) {
        return (this._mask[columnNumber / 8] & (byte)(1 << columnNumber % 8)) == 0;
    }

    public void markNull(int columnNumber) {
        int maskIndex = columnNumber / 8;
        this._mask[maskIndex] = (byte)(this._mask[maskIndex] & (byte)(~(1 << columnNumber % 8)));
    }

    public int byteSize() {
        return this._mask.length;
    }
}

