/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class JetFormat {
    public static final int MAX_RECORD_SIZE = 1900;
    public static final short TEXT_FIELD_MAX_LENGTH = 510;
    private static final long OFFSET_VERSION = 20L;
    private static final byte CODE_VERSION_3 = 0;
    private static final byte CODE_VERSION_4 = 1;
    public final int PAGE_SIZE = this.definePageSize();
    public final int MAX_ROW_SIZE = this.defineMaxRowSize();
    public final int OFFSET_NEXT_TABLE_DEF_PAGE = this.defineOffsetNextTableDefPage();
    public final int OFFSET_NUM_ROWS = this.defineOffsetNumRows();
    public final int OFFSET_TABLE_TYPE = this.defineOffsetTableType();
    public final int OFFSET_NUM_COLS = this.defineOffsetNumCols();
    public final int OFFSET_NUM_INDEXES = this.defineOffsetNumIndexes();
    public final int OFFSET_OWNED_PAGES = this.defineOffsetOwnedPages();
    public final int OFFSET_FREE_SPACE_PAGES = this.defineOffsetFreeSpacePages();
    public final int OFFSET_INDEX_DEF_BLOCK = this.defineOffsetIndexDefBlock();
    public final int OFFSET_COLUMN_TYPE = this.defineOffsetColumnType();
    public final int OFFSET_COLUMN_NUMBER = this.defineOffsetColumnNumber();
    public final int OFFSET_COLUMN_PRECISION = this.defineOffsetColumnPrecision();
    public final int OFFSET_COLUMN_SCALE = this.defineOffsetColumnScale();
    public final int OFFSET_COLUMN_VARIABLE = this.defineOffsetColumnVariable();
    public final int OFFSET_COLUMN_COMPRESSED_UNICODE = this.defineOffsetColumnCompressedUnicode();
    public final int OFFSET_COLUMN_LENGTH = this.defineOffsetColumnLength();
    public final int OFFSET_TABLE_DEF_LOCATION = this.defineOffsetTableDefLocation();
    public final int OFFSET_NUM_ROWS_ON_PAGE = this.defineOffsetNumRowsOnPage();
    public final int OFFSET_ROW_LOCATION_BLOCK = this.defineOffsetRowLocationBlock();
    public final int OFFSET_ROW_START = this.defineOffsetRowStart();
    public final int OFFSET_MAP_START = this.defineOffsetMapStart();
    public final int OFFSET_USAGE_MAP_PAGE_DATA = this.defineOffsetUsageMapPageData();
    public final int OFFSET_REFERENCE_MAP_PAGE_NUMBERS = this.defineOffsetReferenceMapPageNumbers();
    public final int OFFSET_FREE_SPACE = this.defineOffsetFreeSpace();
    public final int OFFSET_DATA_ROW_LOCATION_BLOCK = this.defineOffsetDataRowLocationBlock();
    public final int OFFSET_NUM_ROWS_ON_DATA_PAGE = this.defineOffsetNumRowsOnDataPage();
    public final int OFFSET_LVAL_ROW_LOCATION_BLOCK = this.defineOffsetLvalRowLocationBlock();
    public final int OFFSET_USED_PAGES_USAGE_MAP_DEF = this.defineOffsetUsedPagesUsageMapDef();
    public final int OFFSET_FREE_PAGES_USAGE_MAP_DEF = this.defineOffsetFreePagesUsageMapDef();
    public final int OFFSET_INDEX_ENTRY_MASK = this.defineOffsetIndexEntryMask();
    public final int SIZE_INDEX_DEFINITION = this.defineSizeIndexDefinition();
    public final int SIZE_COLUMN_HEADER = this.defineSizeColumnHeader();
    public final int SIZE_ROW_LOCATION = this.defineSizeRowLocation();
    public final int SIZE_LONG_VALUE_DEF = this.defineSizeLongValueDef();
    public final int SIZE_TDEF_BLOCK = this.defineSizeTdefBlock();
    public final int SIZE_COLUMN_DEF_BLOCK = this.defineSizeColumnDefBlock();
    public final int SIZE_INDEX_ENTRY_MASK = this.defineSizeIndexEntryMask();
    public final int PAGES_PER_USAGE_MAP_PAGE = this.definePagesPerUsageMapPage();
    public final Charset CHARSET = this.defineCharset();
    public static final JetFormat VERSION_4 = new Jet4Format();

    public static JetFormat getFormat(FileChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        channel.read(buffer, 20L);
        buffer.flip();
        byte version = buffer.get();
        if (version == 1) {
            return VERSION_4;
        }
        throw new IOException("Unsupported version: " + version);
    }

    private JetFormat() {
    }

    protected abstract int definePageSize();

    protected abstract int defineMaxRowSize();

    protected abstract int defineOffsetNextTableDefPage();

    protected abstract int defineOffsetNumRows();

    protected abstract int defineOffsetTableType();

    protected abstract int defineOffsetNumCols();

    protected abstract int defineOffsetNumIndexes();

    protected abstract int defineOffsetOwnedPages();

    protected abstract int defineOffsetFreeSpacePages();

    protected abstract int defineOffsetIndexDefBlock();

    protected abstract int defineOffsetColumnType();

    protected abstract int defineOffsetColumnNumber();

    protected abstract int defineOffsetColumnPrecision();

    protected abstract int defineOffsetColumnScale();

    protected abstract int defineOffsetColumnVariable();

    protected abstract int defineOffsetColumnCompressedUnicode();

    protected abstract int defineOffsetColumnLength();

    protected abstract int defineOffsetTableDefLocation();

    protected abstract int defineOffsetNumRowsOnPage();

    protected abstract int defineOffsetRowLocationBlock();

    protected abstract int defineOffsetRowStart();

    protected abstract int defineOffsetMapStart();

    protected abstract int defineOffsetUsageMapPageData();

    protected abstract int defineOffsetReferenceMapPageNumbers();

    protected abstract int defineOffsetFreeSpace();

    protected abstract int defineOffsetDataRowLocationBlock();

    protected abstract int defineOffsetNumRowsOnDataPage();

    protected abstract int defineOffsetLvalRowLocationBlock();

    protected abstract int defineOffsetUsedPagesUsageMapDef();

    protected abstract int defineOffsetFreePagesUsageMapDef();

    protected abstract int defineOffsetIndexEntryMask();

    protected abstract int defineSizeIndexDefinition();

    protected abstract int defineSizeColumnHeader();

    protected abstract int defineSizeRowLocation();

    protected abstract int defineSizeLongValueDef();

    protected abstract int defineSizeTdefBlock();

    protected abstract int defineSizeColumnDefBlock();

    protected abstract int defineSizeIndexEntryMask();

    protected abstract int definePagesPerUsageMapPage();

    protected abstract Charset defineCharset();

    private static final class Jet4Format
    extends JetFormat {
        private Jet4Format() {
        }

        protected int definePageSize() {
            return 4096;
        }

        protected int defineMaxRowSize() {
            return this.PAGE_SIZE - 18;
        }

        protected int defineOffsetNextTableDefPage() {
            return 4;
        }

        protected int defineOffsetNumRows() {
            return 16;
        }

        protected int defineOffsetTableType() {
            return 40;
        }

        protected int defineOffsetNumCols() {
            return 45;
        }

        protected int defineOffsetNumIndexes() {
            return 47;
        }

        protected int defineOffsetOwnedPages() {
            return 55;
        }

        protected int defineOffsetFreeSpacePages() {
            return 59;
        }

        protected int defineOffsetIndexDefBlock() {
            return 63;
        }

        protected int defineOffsetColumnType() {
            return 0;
        }

        protected int defineOffsetColumnNumber() {
            return 5;
        }

        protected int defineOffsetColumnPrecision() {
            return 11;
        }

        protected int defineOffsetColumnScale() {
            return 12;
        }

        protected int defineOffsetColumnVariable() {
            return 15;
        }

        protected int defineOffsetColumnCompressedUnicode() {
            return 16;
        }

        protected int defineOffsetColumnLength() {
            return 23;
        }

        protected int defineOffsetTableDefLocation() {
            return 4;
        }

        protected int defineOffsetNumRowsOnPage() {
            return 12;
        }

        protected int defineOffsetRowLocationBlock() {
            return 16;
        }

        protected int defineOffsetRowStart() {
            return 14;
        }

        protected int defineOffsetMapStart() {
            return 5;
        }

        protected int defineOffsetUsageMapPageData() {
            return 4;
        }

        protected int defineOffsetReferenceMapPageNumbers() {
            return 1;
        }

        protected int defineOffsetFreeSpace() {
            return 2;
        }

        protected int defineOffsetDataRowLocationBlock() {
            return 14;
        }

        protected int defineOffsetNumRowsOnDataPage() {
            return 12;
        }

        protected int defineOffsetLvalRowLocationBlock() {
            return 10;
        }

        protected int defineOffsetUsedPagesUsageMapDef() {
            return 4027;
        }

        protected int defineOffsetFreePagesUsageMapDef() {
            return 3958;
        }

        protected int defineOffsetIndexEntryMask() {
            return 27;
        }

        protected int defineSizeIndexDefinition() {
            return 12;
        }

        protected int defineSizeColumnHeader() {
            return 25;
        }

        protected int defineSizeRowLocation() {
            return 2;
        }

        protected int defineSizeLongValueDef() {
            return 12;
        }

        protected int defineSizeTdefBlock() {
            return 63;
        }

        protected int defineSizeColumnDefBlock() {
            return 25;
        }

        protected int defineSizeIndexEntryMask() {
            return 453;
        }

        protected int definePagesPerUsageMapPage() {
            return 32736;
        }

        protected Charset defineCharset() {
            return Charset.forName("UTF-16LE");
        }
    }
}

