/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.UsageMap;
import java.io.IOException;
import java.nio.ByteBuffer;

public class InlineUsageMap
extends UsageMap {
    private static final int MAP_SIZE = 64;
    private int _startPage = 0;

    public InlineUsageMap(PageChannel pageChannel, ByteBuffer dataBuffer, int pageNum, JetFormat format, short rowStart) throws IOException {
        super(pageChannel, dataBuffer, pageNum, format, rowStart);
        this._startPage = dataBuffer.getInt(rowStart + 1);
        this.processMap(dataBuffer, 0, this._startPage);
    }

    protected void addOrRemovePageNumber(int pageNumber, boolean add) throws IOException {
        if (add && pageNumber < this._startPage) {
            throw new IOException("Can't add page number " + pageNumber + " because it is less than start page " + this._startPage);
        }
        int relativePageNumber = pageNumber - this._startPage;
        ByteBuffer buffer = this.getDataBuffer();
        if (!add && !this.getPageNumbers().remove(new Integer(pageNumber)) || add && relativePageNumber > 511) {
            this._startPage = pageNumber;
            buffer.position(this.getRowStart() + 1);
            buffer.putInt(this._startPage);
            this.getPageNumbers().clear();
            if (!add) {
                int j2;
                for (j2 = 0; j2 < 64; ++j2) {
                    buffer.put((byte)-1);
                }
                for (j2 = this._startPage; j2 < this._startPage + 512; ++j2) {
                    this.getPageNumbers().add(new Integer(j2));
                }
            }
            this.getPageChannel().writePage(buffer, this.getDataPageNumber());
            relativePageNumber = pageNumber - this._startPage;
        }
        this.updateMap(pageNumber, relativePageNumber, 1 << relativePageNumber % 8, buffer, add);
        this.getPageChannel().writePage(buffer, this.getDataPageNumber());
    }
}

