/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang.builder.CompareToBuilder;

public class Index
implements Comparable {
    private static final int MAX_COLUMNS = 10;
    private static final short COLUMN_UNUSED = -1;
    private static BidiMap CODES = new DualHashBidiMap();
    private int _pageNumber;
    private int _parentPageNumber;
    private int _rowCount;
    private JetFormat _format;
    private List _allColumns;
    private SortedSet _entries = new TreeSet();
    private Map _columns = new LinkedHashMap();
    private PageChannel _pageChannel;
    private int _indexNumber;
    private String _name;

    public Index(int parentPageNumber, PageChannel channel, JetFormat format) {
        this._parentPageNumber = parentPageNumber;
        this._pageChannel = channel;
        this._format = format;
    }

    public void setIndexNumber(int indexNumber) {
        this._indexNumber = indexNumber;
    }

    public int getIndexNumber() {
        return this._indexNumber;
    }

    public void setRowCount(int rowCount) {
        this._rowCount = rowCount;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void update() throws IOException {
        this._pageChannel.writePage(this.write(), this._pageNumber);
    }

    public ByteBuffer write() throws IOException {
        ByteBuffer buffer = this._pageChannel.createPageBuffer();
        buffer.put((byte)4);
        buffer.put((byte)1);
        buffer.putShort((short)0);
        buffer.putInt(this._parentPageNumber);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        byte[] entryMask = new byte[this._format.SIZE_INDEX_ENTRY_MASK];
        int totalSize = 0;
        for (Entry entry : this._entries) {
            int idx;
            int size = entry.size();
            int n2 = idx = (totalSize += size) / 8;
            entryMask[n2] = (byte)(entryMask[n2] | 1 << totalSize % 8);
        }
        buffer.put(entryMask);
        for (Entry entry : this._entries) {
            entry.write(buffer);
        }
        buffer.putShort(2, (short)(this._format.PAGE_SIZE - buffer.position()));
        return buffer;
    }

    public void read(ByteBuffer buffer, List availableColumns) throws IOException {
        this._allColumns = availableColumns;
        for (int i2 = 0; i2 < 10; ++i2) {
            short columnNumber = buffer.getShort();
            Byte order = new Byte(buffer.get());
            if (columnNumber == -1) continue;
            this._columns.put(availableColumns.get(columnNumber), order);
        }
        buffer.getInt();
        this._pageNumber = buffer.getInt();
        buffer.position(buffer.position() + 10);
        ByteBuffer indexPage = this._pageChannel.createPageBuffer();
        this._pageChannel.readPage(indexPage, this._pageNumber);
        indexPage.position(this._format.OFFSET_INDEX_ENTRY_MASK);
        byte[] entryMask = new byte[this._format.SIZE_INDEX_ENTRY_MASK];
        indexPage.get(entryMask);
        int lastStart = 0;
        for (int i3 = 0; i3 < entryMask.length; ++i3) {
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((entryMask[i3] & 1 << j2) == 0) continue;
                int length = i3 * 8 + j2 - lastStart;
                this._entries.add(new Entry(indexPage));
                lastStart += length;
            }
        }
    }

    public void addRow(Object[] row, int pageNumber, byte rowNumber) {
        this._entries.add(new Entry(row, pageNumber, rowNumber));
    }

    public String toString() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("\tName: " + this._name);
        rtn.append("\n\tNumber: " + this._indexNumber);
        rtn.append("\n\tPage number: " + this._pageNumber);
        rtn.append("\n\tColumns: " + this._columns);
        rtn.append("\n\tEntries: " + this._entries);
        rtn.append("\n\n");
        return rtn.toString();
    }

    public int compareTo(Object obj) {
        Index other = (Index)obj;
        if (this._indexNumber > other.getIndexNumber()) {
            return 1;
        }
        if (this._indexNumber < other.getIndexNumber()) {
            return -1;
        }
        return 0;
    }

    static {
        CODES.put(new Character('^'), new Byte(2));
        CODES.put(new Character('_'), new Byte(3));
        CODES.put(new Character('{'), new Byte(9));
        CODES.put(new Character('|'), new Byte(11));
        CODES.put(new Character('}'), new Byte(13));
        CODES.put(new Character('~'), new Byte(15));
        CODES.put(new Character(' '), new Byte(7));
        CODES.put(new Character('#'), new Byte(12));
        CODES.put(new Character('$'), new Byte(14));
        CODES.put(new Character('%'), new Byte(16));
        CODES.put(new Character('&'), new Byte(18));
        CODES.put(new Character('('), new Byte(20));
        CODES.put(new Character(')'), new Byte(22));
        CODES.put(new Character('*'), new Byte(24));
        CODES.put(new Character(','), new Byte(26));
        CODES.put(new Character('/'), new Byte(30));
        CODES.put(new Character(':'), new Byte(32));
        CODES.put(new Character(';'), new Byte(34));
        CODES.put(new Character('?'), new Byte(36));
        CODES.put(new Character('@'), new Byte(38));
        CODES.put(new Character('+'), new Byte(44));
        CODES.put(new Character('<'), new Byte(46));
        CODES.put(new Character('='), new Byte(48));
        CODES.put(new Character('>'), new Byte(50));
        CODES.put(new Character('0'), new Byte(54));
        CODES.put(new Character('1'), new Byte(56));
        CODES.put(new Character('2'), new Byte(58));
        CODES.put(new Character('3'), new Byte(60));
        CODES.put(new Character('4'), new Byte(62));
        CODES.put(new Character('5'), new Byte(64));
        CODES.put(new Character('6'), new Byte(66));
        CODES.put(new Character('7'), new Byte(68));
        CODES.put(new Character('8'), new Byte(70));
        CODES.put(new Character('9'), new Byte(72));
        CODES.put(new Character('A'), new Byte(74));
        CODES.put(new Character('B'), new Byte(76));
        CODES.put(new Character('C'), new Byte(77));
        CODES.put(new Character('D'), new Byte(79));
        CODES.put(new Character('E'), new Byte(81));
        CODES.put(new Character('F'), new Byte(83));
        CODES.put(new Character('G'), new Byte(85));
        CODES.put(new Character('H'), new Byte(87));
        CODES.put(new Character('I'), new Byte(89));
        CODES.put(new Character('J'), new Byte(91));
        CODES.put(new Character('K'), new Byte(92));
        CODES.put(new Character('L'), new Byte(94));
        CODES.put(new Character('M'), new Byte(96));
        CODES.put(new Character('N'), new Byte(98));
        CODES.put(new Character('O'), new Byte(100));
        CODES.put(new Character('P'), new Byte(102));
        CODES.put(new Character('Q'), new Byte(104));
        CODES.put(new Character('R'), new Byte(105));
        CODES.put(new Character('S'), new Byte(107));
        CODES.put(new Character('T'), new Byte(109));
        CODES.put(new Character('U'), new Byte(111));
        CODES.put(new Character('V'), new Byte(113));
        CODES.put(new Character('W'), new Byte(115));
        CODES.put(new Character('X'), new Byte(117));
        CODES.put(new Character('Y'), new Byte(118));
        CODES.put(new Character('Z'), new Byte(120));
    }

    private class EntryColumn
    implements Comparable {
        private Column _column;
        private Comparable _value;

        public EntryColumn(Column col, Comparable value) {
            this._column = col;
            this._value = value;
        }

        public EntryColumn(Column col, ByteBuffer buffer) throws IOException {
            this._column = col;
            byte flag = buffer.get();
            if (flag != 0) {
                if (col.getType() == 10) {
                    byte b2;
                    StringBuffer sb = new StringBuffer();
                    while ((b2 = buffer.get()) != 1) {
                        Character c2;
                        if (b2 == 43) {
                            b2 = buffer.get();
                        }
                        if ((c2 = (Character)CODES.getKey(new Byte(b2))) == null) continue;
                        sb.append(c2.charValue());
                    }
                    buffer.get();
                    this._value = sb.toString();
                } else {
                    byte[] data = new byte[col.size()];
                    buffer.get(data);
                    this._value = (Comparable)col.read(data, ByteOrder.BIG_ENDIAN);
                    if (this._value instanceof Integer) {
                        this._value = new Integer((int)(((Integer)this._value).longValue() + Integer.MAX_VALUE + 1L));
                    } else if (this._value instanceof Short) {
                        this._value = new Short((short)(((Short)this._value).longValue() + Integer.MAX_VALUE + 1L));
                    }
                }
            }
        }

        public Comparable getValue() {
            return this._value;
        }

        public void write(ByteBuffer buffer) throws IOException {
            buffer.put((byte)127);
            if (this._column.getType() == 10) {
                String s2 = (String)((Object)this._value);
                for (int i2 = 0; i2 < s2.length(); ++i2) {
                    Byte b2 = (Byte)CODES.get(new Character(Character.toUpperCase(s2.charAt(i2))));
                    if (b2 == null) {
                        throw new IOException("Unmapped index value: " + s2.charAt(i2));
                    }
                    byte bv = b2;
                    if (bv == 2 || bv == 3 || bv == 9 || bv == 11 || bv == 13 || bv == 15) {
                        buffer.put((byte)43);
                    }
                    buffer.put(b2);
                    if (!s2.equals("_")) continue;
                    buffer.put((byte)3);
                }
                buffer.put((byte)1);
                buffer.put((byte)0);
            } else {
                Comparable value = this._value;
                if (value instanceof Integer) {
                    value = new Integer((int)(((Integer)value).longValue() - 0x80000000L));
                } else if (value instanceof Short) {
                    value = new Short((short)(((Short)value).longValue() - 0x80000000L));
                }
                buffer.put(this._column.write(value, ByteOrder.BIG_ENDIAN));
            }
        }

        public int size() {
            if (this._value == null) {
                return 0;
            }
            if (this._value instanceof String) {
                int rtn = 3;
                String s2 = (String)((Object)this._value);
                for (int i2 = 0; i2 < s2.length(); ++i2) {
                    ++rtn;
                    if (s2.charAt(i2) != '^' && s2.charAt(i2) != '_' && s2.charAt(i2) != '{' && s2.charAt(i2) != '|' && s2.charAt(i2) != '}' && s2.charAt(i2) != '-') continue;
                    ++rtn;
                }
                return rtn;
            }
            return this._column.size();
        }

        public String toString() {
            return String.valueOf(this._value);
        }

        public int compareTo(Object obj) {
            return new CompareToBuilder().append(this._value, ((EntryColumn)obj).getValue()).toComparison();
        }
    }

    private class Entry
    implements Comparable {
        private int _page;
        private byte _row;
        private List _entryColumns = new ArrayList();

        public Entry(Object[] values, int page, byte rowNumber) {
            this._page = page;
            this._row = rowNumber;
            for (Column col : Index.this._columns.keySet()) {
                Object value = values[col.getColumnNumber()];
                this._entryColumns.add(new EntryColumn(col, (Comparable)value));
            }
        }

        public Entry(ByteBuffer buffer) throws IOException {
            Iterator iter = Index.this._columns.keySet().iterator();
            while (iter.hasNext()) {
                this._entryColumns.add(new EntryColumn((Column)iter.next(), buffer));
            }
            this._page = (buffer.get() & 0xFF) << 16;
            this._page += (buffer.get() & 0xFF) << 8;
            this._page += buffer.get();
            this._row = buffer.get();
        }

        public List getEntryColumns() {
            return this._entryColumns;
        }

        public int getPage() {
            return this._page;
        }

        public byte getRow() {
            return this._row;
        }

        public int size() {
            int rtn = 5;
            Iterator iter = this._entryColumns.iterator();
            while (iter.hasNext()) {
                rtn += ((EntryColumn)iter.next()).size();
            }
            return rtn;
        }

        public void write(ByteBuffer buffer) throws IOException {
            Iterator iter = this._entryColumns.iterator();
            while (iter.hasNext()) {
                ((EntryColumn)iter.next()).write(buffer);
            }
            buffer.put((byte)(this._page >>> 16));
            buffer.put((byte)(this._page >>> 8));
            buffer.put((byte)this._page);
            buffer.put(this._row);
        }

        public String toString() {
            return "Page = " + this._page + ", Row = " + this._row + ", Columns = " + this._entryColumns + "\n";
        }

        public int compareTo(Object obj) {
            if (this == obj) {
                return 0;
            }
            Entry other = (Entry)obj;
            Iterator myIter = this._entryColumns.iterator();
            Iterator otherIter = other.getEntryColumns().iterator();
            while (myIter.hasNext()) {
                EntryColumn otherCol;
                if (!otherIter.hasNext()) {
                    throw new IllegalArgumentException("Trying to compare index entries with a different number of entry columns");
                }
                EntryColumn myCol = (EntryColumn)myIter.next();
                int i2 = myCol.compareTo(otherCol = (EntryColumn)otherIter.next());
                if (i2 == 0) continue;
                return i2;
            }
            return new CompareToBuilder().append(this._page, other.getPage()).append(this._row, other.getRow()).toComparison();
        }
    }
}

