/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.DataTypes;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.scsu.EndOfInputException;
import com.healthmarketscience.jackcess.scsu.Expand;
import com.healthmarketscience.jackcess.scsu.IllegalInputException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Column
implements Comparable {
    private static final Log LOG = LogFactory.getLog(Column.class);
    private static final double DAYS_BETWEEN_EPOCH_AND_1900 = 25569.0;
    private static final double MILLISECONDS_PER_DAY = 8.64E7;
    private static final short LONG_VALUE_TYPE_THIS_PAGE = Short.MIN_VALUE;
    private static final short LONG_VALUE_TYPE_OTHER_PAGE = 16384;
    private static final short LONG_VALUE_TYPE_OTHER_PAGES = 0;
    private boolean _compressedUnicode = false;
    private boolean _variableLength;
    private byte _precision;
    private byte _scale;
    private byte _type;
    private JetFormat _format;
    private PageChannel _pageChannel;
    private short _columnLength;
    private short _columnNumber;
    private String _name;

    public Column() {
        this(JetFormat.VERSION_4);
    }

    public Column(JetFormat format) {
        this._format = format;
    }

    public Column(ByteBuffer buffer, int offset, PageChannel pageChannel, JetFormat format) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Column def block:\n" + ByteUtil.toHexString(buffer, offset, 25));
        }
        this._pageChannel = pageChannel;
        this._format = format;
        this.setType(buffer.get(offset + format.OFFSET_COLUMN_TYPE));
        this._columnNumber = buffer.getShort(offset + format.OFFSET_COLUMN_NUMBER);
        this._columnLength = buffer.getShort(offset + format.OFFSET_COLUMN_LENGTH);
        if (this._type == 16) {
            this._precision = buffer.get(offset + format.OFFSET_COLUMN_PRECISION);
            this._scale = buffer.get(offset + format.OFFSET_COLUMN_SCALE);
        }
        this._variableLength = (buffer.get(offset + format.OFFSET_COLUMN_VARIABLE) & 1) != 1;
        this._compressedUnicode = (buffer.get(offset + format.OFFSET_COLUMN_COMPRESSED_UNICODE) & 1) == 1;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isVariableLength() {
        return this._variableLength;
    }

    public void setVariableLength(boolean variableLength) {
        this._variableLength = variableLength;
    }

    public short getColumnNumber() {
        return this._columnNumber;
    }

    public void setType(byte type) {
        this._type = type;
        this.setLength((short)this.size());
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                this.setVariableLength(false);
                break;
            }
            case 9: 
            case 10: {
                this.setVariableLength(true);
            }
        }
    }

    public byte getType() {
        return this._type;
    }

    public int getSQLType() throws SQLException {
        return DataTypes.toSQLType(this._type);
    }

    public void setSQLType(int type) throws SQLException {
        this.setType(DataTypes.fromSQLType(type));
    }

    public boolean isCompressedUnicode() {
        return this._compressedUnicode;
    }

    public byte getPrecision() {
        return this._precision;
    }

    public byte getScale() {
        return this._scale;
    }

    public void setLength(short length) {
        this._columnLength = length;
    }

    public short getLength() {
        return this._columnLength;
    }

    public Object read(byte[] data) throws IOException {
        return this.read(data, ByteOrder.LITTLE_ENDIAN);
    }

    public Object read(byte[] data, ByteOrder order) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(order);
        switch (this._type) {
            case 1: {
                throw new IOException("Tried to read a boolean from data instead of null mask.");
            }
            case 2: {
                return new Byte(buffer.get());
            }
            case 3: {
                return new Short(buffer.getShort());
            }
            case 4: {
                return new Integer(buffer.getInt());
            }
            case 7: {
                return new Double(buffer.getDouble());
            }
            case 6: {
                return new Float(buffer.getFloat());
            }
            case 8: {
                long time = (long)((buffer.getDouble() - 25569.0) * 8.64E7);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal.setTimeInMillis(time);
                cal.add(5, 1);
                return cal.getTime();
            }
            case 9: {
                return data;
            }
            case 10: {
                if (this._compressedUnicode) {
                    try {
                        String rtn = new Expand().expand(data);
                        if (rtn.length() > 2 && rtn.charAt(0) == '\u00ff' && rtn.charAt(1) == '\u00fe') {
                            rtn = rtn.substring(2);
                        }
                        if (rtn.length() > 1 && rtn.charAt(1) == '\u0000') {
                            char[] fixed = new char[rtn.length() / 2];
                            for (int i2 = 0; i2 < fixed.length; ++i2) {
                                fixed[i2] = rtn.charAt(i2 * 2);
                            }
                            rtn = new String(fixed);
                        }
                        return rtn;
                    }
                    catch (IllegalInputException e2) {
                        throw new IOException("Can't expand text column");
                    }
                    catch (EndOfInputException e3) {
                        throw new IOException("Can't expand text column");
                    }
                }
                return this._format.CHARSET.decode(ByteBuffer.wrap(data)).toString();
            }
            case 5: {
                return null;
            }
            case 11: {
                if (data.length > 0) {
                    return this.getLongValue(data);
                }
                return null;
            }
            case 12: {
                if (data.length > 0) {
                    return this._format.CHARSET.decode(ByteBuffer.wrap(this.getLongValue(data))).toString();
                }
                return null;
            }
            case 16: {
                return null;
            }
            case 13: 
            case 15: {
                return null;
            }
        }
        throw new IOException("Unrecognized data type: " + this._type);
    }

    private byte[] getLongValue(byte[] lvalDefinition) throws IOException {
        ByteBuffer def = ByteBuffer.wrap(lvalDefinition);
        def.order(ByteOrder.LITTLE_ENDIAN);
        short length = def.getShort();
        byte[] rtn = new byte[length];
        short type = def.getShort();
        switch (type) {
            case 16384: {
                if (lvalDefinition.length != this._format.SIZE_LONG_VALUE_DEF) {
                    throw new IOException("Expected " + this._format.SIZE_LONG_VALUE_DEF + " bytes in long value definition, but found " + lvalDefinition.length);
                }
                byte rowNum = def.get();
                int pageNum = ByteUtil.get3ByteInt(def, def.position());
                ByteBuffer lvalPage = this._pageChannel.createPageBuffer();
                this._pageChannel.readPage(lvalPage, pageNum);
                short offset = lvalPage.getShort(14 + rowNum * this._format.SIZE_ROW_LOCATION);
                lvalPage.position(offset);
                lvalPage.get(rtn);
                break;
            }
            case -32768: {
                def.getLong();
                def.get(rtn);
            }
            case 0: {
                return null;
            }
            default: {
                throw new IOException("Unrecognized long value type: " + type);
            }
        }
        return rtn;
    }

    public ByteBuffer writeLongValue(byte[] value) throws IOException {
        ByteBuffer def = ByteBuffer.allocate(this._format.SIZE_LONG_VALUE_DEF + value.length);
        def.order(ByteOrder.LITTLE_ENDIAN);
        def.putShort((short)value.length);
        def.putShort((short)Short.MIN_VALUE);
        def.putInt(0);
        def.putInt(0);
        def.put(value);
        def.flip();
        return def;
    }

    public ByteBuffer writeLongValueInNewPage(byte[] value) throws IOException {
        ByteBuffer lvalPage = this._pageChannel.createPageBuffer();
        lvalPage.put((byte)1);
        lvalPage.put((byte)1);
        lvalPage.putShort((short)(this._format.PAGE_SIZE - this._format.OFFSET_LVAL_ROW_LOCATION_BLOCK - this._format.SIZE_ROW_LOCATION - value.length));
        lvalPage.put((byte)76);
        lvalPage.put((byte)86);
        lvalPage.put((byte)65);
        lvalPage.put((byte)76);
        int offset = this._format.PAGE_SIZE - value.length;
        lvalPage.position(14);
        lvalPage.putShort((short)offset);
        lvalPage.position(offset);
        lvalPage.put(value);
        ByteBuffer def = ByteBuffer.allocate(this._format.SIZE_LONG_VALUE_DEF);
        def.order(ByteOrder.LITTLE_ENDIAN);
        def.putShort((short)value.length);
        def.putShort((short)16384);
        def.put((byte)0);
        def.put(ByteUtil.to3ByteInt(this._pageChannel.writeNewPage(lvalPage)));
        def.putInt(0);
        def.flip();
        return def;
    }

    public ByteBuffer write(Object obj) throws IOException {
        return this.write(obj, ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer write(Object obj, ByteOrder order) throws IOException {
        int size = this.size();
        if (this._type == 11 || this._type == 12) {
            size += ((byte[])obj).length;
        }
        if (this._type == 10) {
            size = this.getLength();
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(order);
        switch (this._type) {
            case 1: {
                break;
            }
            case 2: {
                buffer.put((Byte)obj);
                break;
            }
            case 3: {
                buffer.putShort((Short)obj);
                break;
            }
            case 4: {
                buffer.putInt((Integer)obj);
                break;
            }
            case 7: {
                buffer.putDouble((Double)obj);
                break;
            }
            case 6: {
                buffer.putFloat(((Float)obj).floatValue());
                break;
            }
            case 8: {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)obj);
                long ms = cal.getTimeInMillis();
                ms += (long)TimeZone.getDefault().getOffset(ms);
                buffer.putDouble((double)ms / 8.64E7 + 25569.0);
                break;
            }
            case 9: {
                buffer.put((byte[])obj);
                break;
            }
            case 10: {
                CharSequence text = (CharSequence)obj;
                int maxChars = size / 2;
                if (text.length() > maxChars) {
                    text = text.subSequence(0, maxChars);
                }
                buffer.put(this.encodeText(text));
                break;
            }
            case 11: {
                buffer.put(this.writeLongValue((byte[])obj));
                break;
            }
            case 12: {
                buffer.put(this.writeLongValue(this.encodeText((CharSequence)obj).array()));
                break;
            }
            default: {
                throw new IOException("Unsupported data type: " + this._type);
            }
        }
        buffer.flip();
        return buffer;
    }

    private ByteBuffer encodeText(CharSequence text) {
        return this._format.CHARSET.encode(CharBuffer.wrap(text));
    }

    public int size() {
        switch (this._type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: 
            case 7: {
                return 8;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 255;
            }
            case 10: {
                return 100;
            }
            case 11: {
                return this._format.SIZE_LONG_VALUE_DEF;
            }
            case 12: {
                return this._format.SIZE_LONG_VALUE_DEF;
            }
            case 16: {
                throw new IllegalArgumentException("FIX ME");
            }
            case 13: 
            case 15: {
                throw new IllegalArgumentException("FIX ME");
            }
        }
        throw new IllegalArgumentException("Unrecognized data type: " + this._type);
    }

    public String toString() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("\tName: " + this._name);
        rtn.append("\n\tType: 0x" + Integer.toHexString(this._type));
        rtn.append("\n\tNumber: " + this._columnNumber);
        rtn.append("\n\tLength: " + this._columnLength);
        rtn.append("\n\tVariable length: " + this._variableLength);
        rtn.append("\n\tCompressed Unicode: " + this._compressedUnicode);
        rtn.append("\n\n");
        return rtn.toString();
    }

    public int compareTo(Object obj) {
        Column other = (Column)obj;
        if (this._columnNumber > other.getColumnNumber()) {
            return 1;
        }
        if (this._columnNumber < other.getColumnNumber()) {
            return -1;
        }
        return 0;
    }

    public static short countVariableLength(List columns) {
        short rtn = 0;
        for (Column col : columns) {
            if (!col.isVariableLength()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }
}

