/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.geom;

import com.graphbuilder.geom.Point2d;

public final class Geom {
    public static final Object PARALLEL = new Object();
    public static final Object INTERSECT = new Object();

    private Geom() {
    }

    public static double getAngle(double originX, double originY, double x, double y) {
        double adj = x - originX;
        double opp = y - originY;
        double rad = 0.0;
        if (adj == 0.0) {
            if (opp == 0.0) {
                return 0.0;
            }
            rad = 1.5707963267948966;
        } else {
            rad = Math.atan(opp / adj);
            if (rad < 0.0) {
                rad = -rad;
            }
        }
        if (x >= originX) {
            if (y < originY) {
                rad = Math.PI * 2 - rad;
            }
        } else {
            rad = y < originY ? Math.PI + rad : Math.PI - rad;
        }
        return rad;
    }

    public static double getAngle(Point2d origin, Point2d p2) {
        return Geom.getAngle(origin.getX(), origin.getY(), p2.getX(), p2.getY());
    }

    public static double ptLineDistSq(double x1, double y1, double x2, double y2, double x, double y, double[] result) {
        double run = x2 - x1;
        double rise = y2 - y1;
        double t = 0.0;
        double f2 = run * run + rise * rise;
        if (f2 != 0.0) {
            t = (run * (x - x1) + rise * (y - y1)) / f2;
        }
        double nx = x1 + t * run;
        double ny = y1 + t * rise;
        if (result != null) {
            result[0] = nx;
            result[1] = ny;
            result[2] = t;
        }
        double dx = x - nx;
        double dy = y - ny;
        return dx * dx + dy * dy;
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double x, double y, double[] result) {
        double run = x2 - x1;
        double rise = y2 - y1;
        double t = 0.0;
        double f2 = run * run + rise * rise;
        if (f2 != 0.0) {
            t = (run * (x - x1) + rise * (y - y1)) / f2;
        }
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        double nx = x1 + t * run;
        double ny = y1 + t * rise;
        if (result != null) {
            result[0] = nx;
            result[1] = ny;
            result[2] = t;
        }
        double dx = x - nx;
        double dy = y - ny;
        return dx * dx + dy * dy;
    }

    public static double ptLineDistSq(double[] a2, double[] b2, double[] c2, double[] d2, int n2) {
        int i2;
        for (int i3 = 0; i3 < n2; ++i3) {
            d2[i3] = b2[i3] - a2[i3];
        }
        double f2 = 0.0;
        for (int i4 = 0; i4 < n2; ++i4) {
            f2 += d2[i4] * d2[i4];
        }
        double t = 0.0;
        if (f2 != 0.0) {
            double g2 = 0.0;
            for (i2 = 0; i2 < n2; ++i2) {
                g2 += d2[i2] * (c2[i2] - a2[i2]);
            }
            t = g2 / f2;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            d2[i5] = a2[i5] + t * d2[i5];
        }
        d2[n2] = t;
        double distSq = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            double h2 = c2[i2] - d2[i2];
            distSq += h2 * h2;
        }
        return distSq;
    }

    public static double ptSegDistSq(double[] a2, double[] b2, double[] c2, double[] d2, int n2) {
        int i2;
        for (int i3 = 0; i3 < n2; ++i3) {
            d2[i3] = b2[i3] - a2[i3];
        }
        double f2 = 0.0;
        for (int i4 = 0; i4 < n2; ++i4) {
            f2 += d2[i4] * d2[i4];
        }
        double t = 0.0;
        if (f2 != 0.0) {
            double g2 = 0.0;
            for (i2 = 0; i2 < n2; ++i2) {
                g2 += d2[i2] * (c2[i2] - a2[i2]);
            }
            t = g2 / f2;
        }
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            d2[i5] = a2[i5] + t * d2[i5];
        }
        d2[n2] = t;
        double distSq = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            double h2 = c2[i2] - d2[i2];
            distSq += h2 * h2;
        }
        return distSq;
    }

    public static Object getLineLineIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] result) {
        double bx = x2 - x1;
        double dy = y4 - y3;
        double by = y2 - y1;
        double dx = x4 - x3;
        double b_dot_d_perp = bx * dy - by * dx;
        if (b_dot_d_perp == 0.0) {
            return PARALLEL;
        }
        double cx = x3 - x1;
        double cy = y3 - y1;
        double t = (cx * dy - cy * dx) / b_dot_d_perp;
        if (result != null) {
            result[0] = x1 + t * bx;
            result[1] = y1 + t * by;
            result[2] = t;
        }
        return INTERSECT;
    }

    public static Object getLineSegIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] result) {
        double bx = x2 - x1;
        double dy = y4 - y3;
        double by = y2 - y1;
        double dx = x4 - x3;
        double b_dot_d_perp = bx * dy - by * dx;
        if (b_dot_d_perp == 0.0) {
            return PARALLEL;
        }
        double cx = x3 - x1;
        double cy = y3 - y1;
        double u = (cx * by - cy * bx) / b_dot_d_perp;
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        if (result != null) {
            result[0] = x3 + u * dx;
            result[1] = y3 + u * dy;
            result[2] = u;
        }
        return INTERSECT;
    }

    public static Object getSegSegIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] result) {
        double bx = x2 - x1;
        double dy = y4 - y3;
        double by = y2 - y1;
        double dx = x4 - x3;
        double b_dot_d_perp = bx * dy - by * dx;
        if (b_dot_d_perp == 0.0) {
            return PARALLEL;
        }
        double cx = x3 - x1;
        double cy = y3 - y1;
        double t = (cx * dy - cy * dx) / b_dot_d_perp;
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        double u = (cx * by - cy * bx) / b_dot_d_perp;
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        if (result != null) {
            result[0] = x1 + t * bx;
            result[1] = y1 + t * by;
            result[2] = t;
        }
        return INTERSECT;
    }

    public static boolean getCircle(double x1, double y1, double x2, double y2, double x3, double y3, double[] result) {
        double ax = x2 - x1;
        double cy = y1 - y3;
        double ay = y2 - y1;
        double cx = x1 - x3;
        double aPerpDOTc = ax * cy - ay * cx;
        if (aPerpDOTc == 0.0) {
            return false;
        }
        double bx = x3 - x2;
        double by = y3 - y2;
        double bDOTc = bx * cx + by * cy;
        double qo = bDOTc / aPerpDOTc;
        double sx = x1 + (ax - qo * ay) / 2.0;
        double sy = y1 + (ay + qo * ax) / 2.0;
        double dx = x1 - sx;
        double dy = y1 - sy;
        double rSquared = dx * dx + dy * dy;
        if (result != null) {
            result[0] = sx;
            result[1] = sy;
            result[2] = rSquared;
        }
        return true;
    }

    public static double getTriangleAreaSq(double x1, double y1, double x2, double y2, double x3, double y3) {
        double t;
        double ax = x1 - x2;
        double ay = y1 - y2;
        double bx = x2 - x3;
        double by = y2 - y3;
        double cx = x3 - x1;
        double cy = y3 - y1;
        double a2 = (ax * ax + ay * ay) / 2.0;
        double b2 = (bx * bx + by * by) / 2.0;
        double c2 = (cx * cx + cy * cy) / 2.0;
        if (b2 < a2) {
            t = a2;
            a2 = b2;
            b2 = t;
        }
        if (c2 < a2) {
            t = a2;
            a2 = c2;
            c2 = t;
        }
        double d2 = (a2 + (b2 - c2)) / 2.0;
        return a2 * b2 - d2 * d2;
    }

    public static double getTriangleAreaSq(double a2, double b2, double c2) {
        double t;
        if (a2 < 0.0) {
            throw new IllegalArgumentException("a >= 0 required");
        }
        if (b2 < 0.0) {
            throw new IllegalArgumentException("b >= 0 required");
        }
        if (c2 < 0.0) {
            throw new IllegalArgumentException("c >= 0 required");
        }
        if (a2 > b2 + c2) {
            throw new IllegalArgumentException("a <= b + c required");
        }
        if (b2 > a2 + c2) {
            throw new IllegalArgumentException("b <= a + c required");
        }
        if (c2 > a2 + b2) {
            throw new IllegalArgumentException("c <= a + b required");
        }
        if (a2 < c2) {
            t = c2;
            c2 = a2;
            a2 = t;
        }
        if (b2 < c2) {
            t = c2;
            c2 = b2;
            b2 = t;
        }
        if (a2 < b2) {
            t = b2;
            b2 = a2;
            a2 = t;
        }
        return (a2 + (b2 + c2)) * (c2 - (a2 - b2)) * (c2 + (a2 - b2)) * (a2 + (b2 - c2)) / 16.0;
    }
}

