/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.homelinux.elabor.file.PatternFileFilter;
import org.homelinux.elabor.json.JsonTools;

public class TextTestHelper
extends TestCase {
    private static final String X00_X7F = "[^\\x00-\\x7F]";

    public static void checkTextFile(File outFile, String encoding, String[] result) throws UnsupportedEncodingException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream inputStream = new FileInputStream(outFile);){
            String path = outFile.getAbsolutePath();
            TextTestHelper.checkInputStream(inputStream, encoding, result, path);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkInputStream(InputStream inputStream, String encoding, String[] result, String label) throws UnsupportedEncodingException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, encoding);
            try {
                try (BufferedReader bufferedReader = new BufferedReader(reader);){
                    String line;
                    int lineNumber = 0;
                    String[] stringArray = result;
                    int n2 = result.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String cleanReadline;
                        line = stringArray[n3];
                        ++lineNumber;
                        String readLine = bufferedReader.readLine();
                        String cleanLine = line.replaceAll(X00_X7F, "");
                        String string = cleanReadline = readLine == null ? null : readLine.replaceAll(X00_X7F, "");
                        if (!cleanLine.equals(cleanReadline)) {
                            System.err.println(String.valueOf(label) + ": " + lineNumber);
                            System.err.println(cleanLine);
                            System.err.println(cleanReadline);
                        }
                        TextTestHelper.assertEquals(cleanLine, cleanReadline);
                        ++n3;
                    }
                    line = bufferedReader.readLine();
                    if (line != null) {
                        System.err.println(label);
                    }
                    TextTestHelper.assertNull(line);
                }
                if (reader == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void checkTextFile(File outFile, String encoding, String[] result, int skipStart, int skipEnd) throws UnsupportedEncodingException, IOException {
        TextTestHelper.assertTrue(outFile.exists());
        FileInputStream inputStream = new FileInputStream(outFile);
        TextTestHelper.checkInputStream(inputStream, encoding, result, skipStart, skipEnd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkInputStream(InputStream inputStream, String encoding, String[] result, int skipStart, int skipEnd) throws UnsupportedEncodingException, IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, encoding);
            try {
                try (BufferedReader bufferedReader = new BufferedReader(reader);){
                    int index = 0;
                    while (index < skipStart) {
                        String line = bufferedReader.readLine();
                        TextTestHelper.assertNotNull(line);
                        ++index;
                    }
                    String[] stringArray = result;
                    int n2 = result.length;
                    int line = 0;
                    while (line < n2) {
                        String line2 = stringArray[line];
                        String current = bufferedReader.readLine();
                        TextTestHelper.assertNotNull(current);
                        TextTestHelper.assertEquals(line2, current);
                        ++line;
                    }
                    index = 0;
                    while (index < skipEnd) {
                        String line3 = bufferedReader.readLine();
                        TextTestHelper.assertNotNull(line3);
                        ++index;
                    }
                    TextTestHelper.assertNull(bufferedReader.readLine());
                }
                if (reader == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void clearFolder(File folder) {
        folder.mkdirs();
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray[n3];
                if (file.isDirectory()) {
                    TextTestHelper.clearFolder(file);
                }
                file.delete();
                ++n3;
            }
        }
    }

    public static void checkTextFile(File expected, String encoding, File actual) throws UnsupportedEncodingException, IOException {
        String[] value = TextTestHelper.getLines(expected);
        TextTestHelper.checkTextFile(actual, encoding, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getLines(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileReader reader = new FileReader(file);
            try {
                try (BufferedReader bfr = new BufferedReader(reader);){
                    String line;
                    while ((line = bfr.readLine()) != null) {
                        lines.add(line);
                    }
                }
                if (reader == null) return lines.toArray(new String[lines.size()]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return lines.toArray(new String[lines.size()]);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void checkFolder(File checkFolder, File outputFolder) throws UnsupportedEncodingException, IOException {
        File[] checkFiles = checkFolder.listFiles();
        if (checkFiles != null) {
            File[] fileArray = checkFiles;
            int n2 = checkFiles.length;
            int n3 = 0;
            while (n3 < n2) {
                File outputFile;
                File checkFile = fileArray[n3];
                String fileName = checkFile.getName();
                if (fileName.startsWith("!")) {
                    outputFile = TextTestHelper.getOutputFile(outputFolder, fileName = fileName.substring(1));
                    if (outputFile.exists()) {
                        TextTestHelper.fail("esiste il file: " + outputFile.getAbsolutePath());
                    }
                } else {
                    outputFile = TextTestHelper.getOutputFile(outputFolder, fileName);
                    if (outputFile.exists()) {
                        if (checkFile.isDirectory()) {
                            if (outputFile.isDirectory()) {
                                TextTestHelper.checkFolder(checkFile, outputFile);
                            } else {
                                TextTestHelper.fail(String.valueOf(outputFile.getAbsolutePath()) + " non \u00e8 una cartella");
                            }
                        } else if (outputFile.isDirectory()) {
                            TextTestHelper.fail(String.valueOf(outputFile.getAbsolutePath()) + " \u00e8 una cartella");
                        } else if (outputFile.getName().toLowerCase().endsWith(".zip")) {
                            TextTestHelper.checkZipFile(checkFile, outputFile);
                        } else {
                            TextTestHelper.checkTextFile(checkFile, "utf-8", outputFile);
                        }
                    } else {
                        TextTestHelper.fail("non esiste il file: " + outputFile.getAbsolutePath());
                    }
                }
                ++n3;
            }
        }
    }

    private static void checkZipFile(File checkFile, File outputFile) throws IOException {
        File tempFolder = File.createTempFile("test", ".d");
        tempFolder.delete();
        File checkFolder = new File(tempFolder, "check");
        checkFolder.mkdirs();
        File outFolder = new File(tempFolder, "output");
        outFolder.mkdirs();
        ZipFile checkZip = new ZipFile(checkFile);
        checkZip.extractAll(checkFolder.getAbsolutePath());
        ZipFile outZip = new ZipFile(outputFile);
        outZip.extractAll(outFolder.getAbsolutePath());
        TextTestHelper.checkFolder(checkFolder, outFolder);
    }

    private static File getOutputFile(File outputFolder, String fileName) {
        String pattern = fileName.replaceAll("[\\|X]", "(.*)");
        File outputFile = new File(outputFolder, fileName);
        RegexFileFilter filter = new RegexFileFilter(pattern);
        File[] files = outputFolder.listFiles(filter);
        if (files != null && files.length == 1) {
            outputFile = files[0];
        }
        return outputFile;
    }

    public static void checkJsonFile(File folder, String fileName, String actual) throws IOException {
        Map<String, Object> actualMap = JsonTools.toMap(actual);
        File file = new File(folder, fileName);
        Map<String, Object> expectedMap = JsonTools.toMap(file);
        Set<String> expectedKeySet = expectedMap.keySet();
        Set<String> actualKeySet = actualMap.keySet();
        if (actualKeySet.equals(expectedKeySet)) {
            for (String key : expectedKeySet) {
                Object actualObject;
                Object expectedObject = expectedMap.get(key);
                if (TextTestHelper.stringMatch(expectedObject, actualObject = actualMap.get(key))) continue;
                TextTestHelper.assertEquals(JsonTools.toString(expectedMap), JsonTools.toString(actualMap));
            }
        } else {
            TextTestHelper.assertEquals(JsonTools.toString(expectedMap), JsonTools.toString(actualMap));
        }
    }

    private static boolean stringMatch(Object expectedObject, Object actualObject) {
        boolean match;
        if (expectedObject instanceof String && actualObject instanceof String) {
            String expectedPattern = (String)expectedObject;
            String actualText = (String)actualObject;
            Pattern pattern = Pattern.compile(String.valueOf(expectedPattern) + "$");
            match = pattern.matcher(actualText).find();
        } else {
            match = JsonTools.toString(actualObject).equals(JsonTools.toString(expectedObject));
        }
        return match;
    }

    public static void checkTextFile(File folder, String pattern, String encoding, String[] content) throws UnsupportedEncodingException, IOException {
        PatternFileFilter filter = new PatternFileFilter(pattern, null);
        File[] files = folder.listFiles(filter);
        TextTestHelper.assertNotNull(files);
        TextTestHelper.assertEquals(1, files.length);
        TextTestHelper.checkTextFile(files[0], encoding, content);
    }

    public static String readFileContent(File testFolder, String fileName) throws IOException {
        File file = new File(testFolder, fileName);
        String absolutePath = file.getAbsolutePath();
        Path path = Paths.get(absolutePath, new String[0]);
        return new String(Files.readAllBytes(path)).replaceAll("\n", "");
    }

    public static void matchText(String[] matches, String actual) {
        String check = actual;
        String[] stringArray = matches;
        int n2 = matches.length;
        int n3 = 0;
        while (n3 < n2) {
            String match = stringArray[n3];
            int index = check.indexOf(match);
            if (index < 0) {
                System.err.println("expected: " + match);
                System.err.println("found:    " + check);
            }
            TextTestHelper.assertTrue(index >= 0);
            check = check.substring(index + match.length());
            ++n3;
        }
    }
}

