/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.xml.filtri;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.xml.DefaultExportXmlHandler;
import biz.elabor.prebilling.services.xml.ExportR2GXmlStrategy;
import biz.elabor.prebilling.services.xml.Pdo2GNRExportXmlHandler;
import biz.elabor.prebilling.services.xml.Pdo2GRExportXmlHandler;
import biz.elabor.prebilling.services.xml.RFO2GNRExportXmlHandler;
import biz.elabor.prebilling.services.xml.RNO2GExportXmlHandler;
import biz.elabor.prebilling.services.xml.RNV2GExportXmlHandler;
import biz.elabor.prebilling.services.xml.RSN2GExportXmlHandler;
import biz.elabor.prebilling.services.xml.RecordStatoMisureStrategy;
import biz.elabor.prebilling.services.xml.Rt2GExportXmlStrategy;
import biz.elabor.prebilling.services.xml.SM2GNRExportXmlHandler;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.Vno2GExportXmlHandler;
import biz.elabor.prebilling.services.xml.d479.Export2GXmlStrategy;
import biz.elabor.prebilling.services.xml.d479.ExportF2gXmlStrategy;
import biz.elabor.prebilling.services.xml.d479.ExportRfo2GRXmlStrategy;
import biz.elabor.prebilling.services.xml.d479.ExportRtr2GRXmlStrategy;
import biz.elabor.prebilling.services.xml.d479.ExportSnm2GXmlStrategy;
import biz.elabor.prebilling.services.xml.d479.GetMisureTypeStrategy;
import biz.elabor.prebilling.services.xml.d479.GetSnm2GEXmlStrategy;
import biz.elabor.prebilling.services.xml.ds.DS2GExportXmlHandler;
import biz.elabor.prebilling.services.xml.ds.DS2GSplitter;
import biz.elabor.prebilling.services.xml.ds.DSR2GExportXmlHandler;
import biz.elabor.prebilling.services.xml.ds.DSR2GSplitter;
import biz.elabor.prebilling.services.xml.ds.DSRExportXMLHandler;
import biz.elabor.prebilling.services.xml.ds.DSSplitter;
import biz.elabor.prebilling.services.xml.ds.ExportDSRXmlStrategy;
import biz.elabor.prebilling.services.xml.ds.ExportDSXmlStrategy;
import biz.elabor.prebilling.services.xml.ds.GetDS2GXmlStrategy;
import biz.elabor.prebilling.services.xml.ds.GetDSR2GXmlStrategy;
import biz.elabor.prebilling.services.xml.ds.GetDSRXmlStrategy;
import biz.elabor.prebilling.services.xml.ds.GetDSXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportAv2gXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportAvR2gXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportAvRXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportAvXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportPdoXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportPnoXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportRettificheXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportRfoXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportRnvXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportRsnXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportRtXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportSmXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportSmisXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportSnfXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportSnmXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportSofXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportVnoXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportVp2gXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportVpR2gXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportVpRXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportVpXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.periodo.GetAv2gXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetAvR2gXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetAvRXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetAvXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetPdo2GNRXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetPdo2GRXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetPdoXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetPno2GXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetPnoXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetRtXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetRtr2gXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSmXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSmisXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSnfXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSnmXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSofXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetVno2GEXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetVnoXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetVp2gXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetVpR2gXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetVpRXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetVpXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRfoXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRnoXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRnvXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRsnXmlStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.IsolateStrategy;
import biz.elabor.prebilling.web.xml.filtri.FiltriXml;
import biz.elabor.prebilling.web.xml.filtri.Pdo2GNRSplitter;
import biz.elabor.prebilling.web.xml.filtri.Pdo2GRSplitter;
import biz.elabor.prebilling.web.xml.filtri.PdoSplitter;
import biz.elabor.prebilling.web.xml.filtri.Pno2GSplitter;
import biz.elabor.prebilling.web.xml.filtri.PnoSplitter;
import java.util.Random;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class XmlFilterStrategiesHandler
extends AbstractStrategiesHandler {
    private final String reseller;
    private final FiltriXml filtri;

    public XmlFilterStrategiesHandler(String reseller, FiltriXml filtri, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.reseller = reseller;
        this.filtri = filtri;
    }

    @Override
    public StrategiesManager buildStrategiesManager() {
        String randomSuffix = "-" + new Random().nextLong();
        DefaultExportXmlHandler defaultEXH = new DefaultExportXmlHandler();
        Rt2GExportXmlStrategy rt2GEXH = new Rt2GExportXmlStrategy();
        Vno2GExportXmlHandler vno2GEXH = new Vno2GExportXmlHandler();
        Pdo2GNRExportXmlHandler pdo2GNREXH = new Pdo2GNRExportXmlHandler();
        Pdo2GRExportXmlHandler pdo2GREXH = new Pdo2GRExportXmlHandler();
        RNO2GExportXmlHandler rno2GXH = new RNO2GExportXmlHandler();
        RNV2GExportXmlHandler rnv2GXH = new RNV2GExportXmlHandler();
        RSN2GExportXmlHandler rsn2GXH = new RSN2GExportXmlHandler();
        RFO2GNRExportXmlHandler rfo2GNRXH = new RFO2GNRExportXmlHandler();
        SM2GNRExportXmlHandler sm2GNRXH = new SM2GNRExportXmlHandler();
        FileCopyStrategy fileCopyStrategy = new FileCopyStrategy(Funzionalita.XML_DEL65, this.configuration, this.talkManager);
        RecordStatoMisureStrategy recordStatoMisureStrategy = new RecordStatoMisureStrategy(this.misureDao, this.talkManager);
        StrategiesManager manager = new StrategiesManager(this.configuration);
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.XML_DEL65, this.reseller, "xmldel65.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new GetResellersStrategy(this.prebillingDao));
        manager.addStrategy(new GetMisureTypeStrategy(this.prebillingDao));
        this.buildPdoStrategies(defaultEXH, fileCopyStrategy, recordStatoMisureStrategy, manager);
        this.buildPdo2GNRStrategies(pdo2GNREXH, fileCopyStrategy, recordStatoMisureStrategy, manager, randomSuffix);
        this.buildPdo2GRStrategies(pdo2GREXH, fileCopyStrategy, recordStatoMisureStrategy, manager, randomSuffix);
        this.buildPnoStrategies(defaultEXH, fileCopyStrategy, recordStatoMisureStrategy, manager);
        this.buildPno2GStrategies(defaultEXH, fileCopyStrategy, recordStatoMisureStrategy, manager, randomSuffix);
        this.buildDSStrategies(defaultEXH, fileCopyStrategy, recordStatoMisureStrategy, manager);
        DS2GExportXmlHandler ds2gEXH = new DS2GExportXmlHandler();
        this.buildDS2GStrategies(ds2gEXH, fileCopyStrategy, recordStatoMisureStrategy, manager, randomSuffix);
        DSR2GExportXmlHandler ds32gEXH = new DSR2GExportXmlHandler();
        this.buildDSR2GStrategies(ds32gEXH, fileCopyStrategy, recordStatoMisureStrategy, manager, randomSuffix);
        manager.addStrategy(new GetSnm2GEXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetSnfXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetAvXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetAv2gXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetAvRXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetAvR2gXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetVpXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetVp2gXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetVpRXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetVpR2gXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetSnmXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetSofXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetRnoXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetDSRXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetRfoXmlStrategy(this.reseller, this.filtri, this.misureDao, this.talkManager));
        manager.addStrategy(new GetVnoXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetVno2GEXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetSmXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetRtXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetRtr2gXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetSmisXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetRnvXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new GetRsnXmlStrategy(this.reseller, this.filtri, this.misureDao));
        manager.addStrategy(new ExportSnfXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportF2gXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportSnmXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportAvXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportAv2gXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportAvRXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportAvR2gXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportVpXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportVp2gXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportVpRXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportVpR2gXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportSofXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportRfoXmlStrategy(TipoFlusso.RFO, Funzionalita.XML_DEL65, this.reseller, defaultEXH, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportRfoXmlStrategy(TipoFlusso.RFO2G, Funzionalita.XML_DEL65, this.reseller, rfo2GNRXH, this.configuration, this.talkManager, ""));
        manager.addStrategy(new ExportRfo2GRXmlStrategy(TipoFlusso.RFO2G, Funzionalita.XML_DEL65, this.reseller, this.configuration, this.talkManager, ""));
        DSRExportXMLHandler dsrEXH = new DSRExportXMLHandler();
        manager.addStrategy(new ExportDSRXmlStrategy(dsrEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportRettificheXmlStrategy(TipoFlusso.RNO, Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportRettificheXmlStrategy(TipoFlusso.RNO2G, Funzionalita.XML_DEL65, rno2GXH, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(new ExportRettificheXmlStrategy(TipoFlusso.RNV2G, Funzionalita.XML_DEL65, rnv2GXH, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(new ExportVnoXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new Export2GXmlStrategy(TipoFlusso.VNO2G, Funzionalita.XML_DEL65, vno2GEXH, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(new ExportSmXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(new ExportRtXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(new Export2GXmlStrategy(TipoFlusso.RT2G, Funzionalita.XML_DEL65, rt2GEXH, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(new Export2GXmlStrategy(TipoFlusso.SM2G, Funzionalita.XML_DEL65, sm2GNRXH, this.reseller, this.configuration, this.talkManager, "", Trattamento.F));
        manager.addStrategy(new ExportRtr2GRXmlStrategy(TipoFlusso.RTR2G, Funzionalita.XML_DEL65, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(new ExportSmisXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportSnm2GXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportRnvXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportRsnXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, randomSuffix));
        manager.addStrategy(new ExportRettificheXmlStrategy(TipoFlusso.RSN2G, Funzionalita.XML_DEL65, rsn2GXH, this.reseller, this.configuration, this.talkManager, ""));
        manager.addStrategy(recordStatoMisureStrategy);
        manager.addStrategy(fileCopyStrategy);
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.XML_DEL65, this.reseller, TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }

    private void buildPno2GStrategies(DefaultExportXmlHandler handler, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager, String folderSuffix) {
        GetPno2GXmlStrategy getStrategy = new GetPno2GXmlStrategy(this.reseller, this.filtri, this.misureDao);
        Export2GXmlStrategy exportStrategy = new Export2GXmlStrategy(TipoFlusso.PNO2G, Funzionalita.XML_DEL65, handler, this.reseller, this.configuration, this.talkManager, folderSuffix);
        Pno2GSplitter splitter = new Pno2GSplitter(this.reseller, this.filtri, this.misureDao);
        IsolableServiceStrategy[] strategies = new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy};
        IsolateStrategy isolateStrategy = new IsolateStrategy(strategies, splitter, this.configuration);
        manager.addStrategy(isolateStrategy);
    }

    private void buildDS2GStrategies(ExportXmlHandler handler, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager, String folderSuffix) {
        GetDS2GXmlStrategy getStrategy = new GetDS2GXmlStrategy(this.reseller, this.filtri, this.misureDao);
        Export2GXmlStrategy exportStrategy = new Export2GXmlStrategy(TipoFlusso.DS2G, Funzionalita.XML_DEL65, handler, this.reseller, this.configuration, this.talkManager, folderSuffix);
        DS2GSplitter splitter = new DS2GSplitter(this.reseller, this.filtri, this.misureDao);
        IsolableServiceStrategy[] strategies = new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy};
        IsolateStrategy isolateStrategy = new IsolateStrategy(strategies, splitter, this.configuration);
        manager.addStrategy(isolateStrategy);
    }

    private void buildDSR2GStrategies(ExportXmlHandler handler, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager, String folderSuffix) {
        GetDSR2GXmlStrategy getStrategy = new GetDSR2GXmlStrategy(this.reseller, this.filtri, this.misureDao);
        ExportR2GXmlStrategy exportStrategy = new ExportR2GXmlStrategy(TipoFlusso.DSR2G, Funzionalita.XML_DEL65, handler, this.reseller, this.configuration, this.talkManager, folderSuffix);
        DSR2GSplitter splitter = new DSR2GSplitter(this.reseller, this.filtri, this.misureDao);
        IsolableServiceStrategy[] strategies = new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy};
        IsolateStrategy isolateStrategy = new IsolateStrategy(strategies, splitter, this.configuration);
        manager.addStrategy(isolateStrategy);
    }

    private void buildDSStrategies(DefaultExportXmlHandler defaultEXH, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager) {
        GetDSXmlStrategy getStrategy = new GetDSXmlStrategy(this.reseller, this.filtri, this.misureDao);
        ExportDSXmlStrategy exportStrategy = new ExportDSXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, "");
        DSSplitter splitter = new DSSplitter(this.reseller, this.filtri, this.misureDao);
        manager.addStrategy(new IsolateStrategy(new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy}, splitter, this.configuration));
    }

    private void buildPnoStrategies(DefaultExportXmlHandler defaultEXH, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager) {
        GetPnoXmlStrategy getStrategy = new GetPnoXmlStrategy(this.reseller, this.filtri, this.misureDao);
        ExportPnoXmlStrategy exportStrategy = new ExportPnoXmlStrategy(Funzionalita.XML_DEL65, defaultEXH, this.reseller, this.configuration, this.talkManager, "");
        PnoSplitter splitter = new PnoSplitter(this.reseller, this.filtri, this.misureDao);
        manager.addStrategy(new IsolateStrategy(new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy}, splitter, this.configuration));
    }

    private void buildPdoStrategies(DefaultExportXmlHandler handler, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager) {
        GetPdoXmlStrategy getStrategy = new GetPdoXmlStrategy(this.reseller, this.filtri, this.misureDao, this.talkManager);
        ExportPdoXmlStrategy exportStrategy = new ExportPdoXmlStrategy(Funzionalita.XML_DEL65, TipoFlusso.PDO, this.reseller, handler, this.configuration, this.talkManager, "");
        PdoSplitter splitter = new PdoSplitter(this.reseller, this.filtri, this.misureDao);
        manager.addStrategy(new IsolateStrategy(new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy}, splitter, this.configuration));
    }

    private void buildPdo2GRStrategies(Pdo2GRExportXmlHandler handler, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager, String folderSuffix) {
        GetPdo2GRXmlStrategy getStrategy = new GetPdo2GRXmlStrategy(this.reseller, this.filtri, this.misureDao, this.talkManager);
        Export2GXmlStrategy exportStrategy = new Export2GXmlStrategy(TipoFlusso.PDO2G, Funzionalita.XML_DEL65, handler, this.reseller, this.configuration, this.talkManager, folderSuffix);
        Pdo2GRSplitter splitter = new Pdo2GRSplitter(this.reseller, this.filtri, this.misureDao);
        manager.addStrategy(new IsolateStrategy(new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy}, splitter, this.configuration));
    }

    private void buildPdo2GNRStrategies(Pdo2GNRExportXmlHandler handler, FileCopyStrategy fileCopyStrategy, RecordStatoMisureStrategy recordStatoMisureStrategy, StrategiesManager manager, String folderSuffix) {
        GetPdo2GNRXmlStrategy getStrategy = new GetPdo2GNRXmlStrategy(this.reseller, this.filtri, this.misureDao, this.talkManager);
        ExportPdoXmlStrategy exportStrategy = new ExportPdoXmlStrategy(Funzionalita.XML_DEL65, TipoFlusso.PDO2G, this.reseller, handler, this.configuration, this.talkManager, folderSuffix);
        IsolableServiceStrategy[] isolableStrategies = new IsolableServiceStrategy[]{getStrategy, exportStrategy, recordStatoMisureStrategy, fileCopyStrategy};
        Pdo2GNRSplitter splitter = new Pdo2GNRSplitter(this.reseller, this.filtri, this.misureDao);
        IsolateStrategy isolateStrategy = new IsolateStrategy(isolableStrategies, splitter, this.configuration);
        manager.addStrategy(isolateStrategy);
    }
}

