/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.xml;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import biz.elabor.prebilling.web.xml.filtri.IsolateSplitter;
import java.util.logging.Logger;
import org.homelinux.elabor.tools.MemoryTools;

public class IsolateStrategy
implements ServiceStrategy {
    private final IsolableServiceStrategy[] strategies;
    private final IsolateSplitter splitter;
    private final int prefixLength;
    private final int maxPartitionCount;

    public IsolateStrategy(IsolableServiceStrategy[] strategies, IsolateSplitter splitter, PrebillingConfiguration configuration) {
        this.strategies = strategies;
        this.splitter = splitter;
        this.prefixLength = configuration.getXmlPrefixLength();
        this.maxPartitionCount = configuration.getMaxPrefixCount();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        Logger logger = status.getLogger();
        Iterable<Partition> partitions = this.splitter.split("", this.prefixLength);
        return this.execute(partitions, logger, status);
    }

    public boolean execute(Iterable<Partition> partitions, Logger logger, ServiceStatus status) {
        boolean ok = true;
        for (Partition partition : partitions) {
            ok &= this.export(partition, logger, status);
        }
        return ok;
    }

    public boolean export(Partition partition, Logger logger, ServiceStatus status) {
        boolean ok;
        String prefix = partition.getPrefix();
        int count = partition.getCount();
        MemoryTools.logMemory(logger, "prefisso '" + prefix + "' inizio (" + count + ")");
        if (count > this.maxPartitionCount) {
            Iterable<Partition> partitions = this.splitter.split(prefix, prefix.length() + 1);
            ok = this.execute(partitions, logger, status);
        } else {
            ok = true;
            IsolableServiceStrategy[] isolableServiceStrategyArray = this.strategies;
            int n2 = this.strategies.length;
            int n3 = 0;
            while (n3 < n2) {
                IsolableServiceStrategy strategy = isolableServiceStrategyArray[n3];
                String name = strategy.getClass().getName();
                MemoryTools.logMemory(logger, String.valueOf(name) + " inizio");
                ok = strategy.executePartition(status, partition);
                MemoryTools.logMemory(logger, String.valueOf(name) + " fine");
                if (!ok) break;
                ++n3;
            }
        }
        MemoryTools.logMemory(logger, "prefisso '" + prefix + "' fine");
        return ok;
    }
}

