/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.tariffe;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.ExcludeMisureStrategy;
import biz.elabor.prebilling.services.tariffe.GetAliquotePerditeStrategy;
import biz.elabor.prebilling.services.tariffe.GetApplicazioniStrategy;
import biz.elabor.prebilling.services.tariffe.GetComuniStrategy;
import biz.elabor.prebilling.services.tariffe.GetOfferteStrategy;
import biz.elabor.prebilling.services.tariffe.GetPraStrategy;
import biz.elabor.prebilling.services.tariffe.RecordStatoTariffeStrategy;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import biz.elabor.prebilling.web.tariffe.ExportErroriTariffeLog;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class TariffeStrategiesHandler
extends AbstractStrategiesHandler {
    private String annoTxt;
    private String meseTxt;
    private TipoCalcolo tipo;
    private Destinatari destinatari;
    private String codicePod;
    private String codiceReseller;
    private boolean scivoloEnabled;
    private boolean scivoloForced;
    private final TipoTrattamento tipoTrattamento;
    private final boolean bloccoIndice;

    public TariffeStrategiesHandler(String annoTxt, String meseTxt, TipoCalcolo tipo, Destinatari destinatari, String codicePod, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento tipoTrattamento, String codiceReseller, boolean bloccoIndice, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
        this.tipo = tipo;
        this.destinatari = destinatari;
        this.codicePod = codicePod;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.tipoTrattamento = tipoTrattamento;
        this.codiceReseller = codiceReseller;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public StrategiesManager buildStrategiesManager() throws InvalidParameterValue {
        int anno = ControllerHelper.checkInt("anno", this.annoTxt);
        Month mese = ControllerHelper.checkEnum("mese", this.meseTxt, Month.class);
        this.handleSession(anno, mese);
        return this.buildStrategiesManager(anno, mese);
    }

    public void handleSession(int anno, Month mese) {
    }

    private StrategiesManager buildStrategiesManager(int anno, Month mese) {
        String ambito = CheckStatusStrategy.getAmbito(this.destinatari, this.codiceReseller);
        boolean consumoComplessivo = this.configuration.isConsumoComplessivo();
        StrategiesManager service = new StrategiesManager(this.configuration);
        service.addStrategy(new CheckStatusStrategy(Funzionalita.TARIFFE, this.destinatari, this.codiceReseller, "check", this.configuration, this.prebillingDao, this.talkManager));
        service.addStrategy(new ExcludeMisureStrategy(anno, mese, this.codicePod, this.giadaDao, this.misureDao, this.configuration, this.talkManager));
        service.addStrategy(new GetCalendarStrategy(this.configuration, this.prebillingDao));
        service.addStrategy(new GetComuniStrategy(this.misureDao));
        service.addStrategy(new GetPraStrategy(this.misureDao, consumoComplessivo));
        service.addStrategy(new GetOfferteStrategy(this.prebillingDao));
        service.addStrategy(new GetApplicazioniStrategy(this.prebillingDao));
        service.addStrategy(new GetAliquotePerditeStrategy(this.misureDao));
        ServiceStrategy exportRettificheTariffeStrategy = this.destinatari.getExportRettificheTariffeStrategy(anno, mese, this.tipo, this.codicePod, this.codiceReseller, this.scivoloEnabled, this.scivoloForced, this.tipoTrattamento, this.bloccoIndice, this.configuration, this.giadaDao, this.misureDao, this.indiciDao, this.talkManager);
        service.addStrategy(exportRettificheTariffeStrategy);
        service.addStrategy(new ExportErroriTariffeLog(this.configuration, this.talkManager));
        service.addStrategy(new RecordStatoTariffeStrategy(this.misureDao, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.TARIFFE, ambito, TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        service.addStrategy(new FileCopyStrategy(Funzionalita.TARIFFE, this.configuration, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.TARIFFE, ambito, TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return service;
    }
}

